/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.internal.dm;
import java.util.ArrayList;
import java.util.Arrays;

public final class RoomConfig {
    private final RoomUpdateListener od;
    private final RoomStatusUpdateListener oe;
    private final RealTimeMessageReceivedListener of;
    private final String nM;
    private final int nR;
    private final String[] og;
    private final Bundle oh;
    private final boolean oi;

    private RoomConfig(Builder builder) {
        this.od = builder.od;
        this.oe = builder.oe;
        this.of = builder.of;
        this.nM = builder.oj;
        this.nR = builder.nR;
        this.oh = builder.oh;
        this.oi = builder.oi;
        int n2 = builder.ok.size();
        this.og = builder.ok.toArray(new String[n2]);
        if (this.of == null) {
            dm.a(this.oi, (Object)"Must either enable sockets OR specify a message listener");
        }
    }

    public RoomUpdateListener getRoomUpdateListener() {
        return this.od;
    }

    public String getInvitationId() {
        return this.nM;
    }

    public RoomStatusUpdateListener getRoomStatusUpdateListener() {
        return this.oe;
    }

    public RealTimeMessageReceivedListener getMessageReceivedListener() {
        return this.of;
    }

    public int getVariant() {
        return this.nR;
    }

    public String[] getInvitedPlayerIds() {
        return this.og;
    }

    public Bundle getAutoMatchCriteria() {
        return this.oh;
    }

    public boolean isSocketEnabled() {
        return this.oi;
    }

    public static Builder builder(RoomUpdateListener listener) {
        return new Builder(listener);
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        final RoomUpdateListener od;
        RoomStatusUpdateListener oe;
        RealTimeMessageReceivedListener of;
        String oj = null;
        int nR = -1;
        ArrayList<String> ok = new ArrayList();
        Bundle oh;
        boolean oi = false;

        private Builder(RoomUpdateListener updateListener) {
            this.od = dm.a(updateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public Builder setInvitationIdToAccept(String invitationId) {
            dm.e(invitationId);
            this.oj = invitationId;
            return this;
        }

        public Builder setRoomStatusUpdateListener(RoomStatusUpdateListener listener) {
            this.oe = listener;
            return this;
        }

        public Builder setMessageReceivedListener(RealTimeMessageReceivedListener listener) {
            this.of = listener;
            return this;
        }

        public Builder addPlayersToInvite(String ... playerIds) {
            dm.e(playerIds);
            this.ok.addAll(Arrays.asList(playerIds));
            return this;
        }

        public Builder addPlayersToInvite(ArrayList<String> playerIds) {
            dm.e(playerIds);
            this.ok.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            this.nR = variant;
            return this;
        }

        public Builder setSocketCommunicationEnabled(boolean enableSockets) {
            this.oi = enableSockets;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.oh = autoMatchCriteria;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfig(this);
        }
    }
}

