/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.net.Uri;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.DownloadListener;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.internal.bf;
import com.google.android.gms.internal.ci;
import com.google.android.gms.internal.cj;
import com.google.android.gms.internal.ck;
import com.google.android.gms.internal.cn;
import com.google.android.gms.internal.co;
import com.google.android.gms.internal.cr;
import com.google.android.gms.internal.cs;
import com.google.android.gms.internal.ct;
import com.google.android.gms.internal.cu;
import com.google.android.gms.internal.h;
import com.google.android.gms.internal.x;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class cq
extends WebView
implements DownloadListener {
    private final cr hT;
    private final MutableContextWrapper hU;
    private final Object eJ = new Object();
    private final h go;
    private final co hV;
    private bf hW;
    private x fg;
    private boolean hX;
    private boolean hY;

    public static cq a(Context context, x x2, boolean bl2, boolean bl3, h h2, co co2) {
        MutableContextWrapper mutableContextWrapper = new MutableContextWrapper(context);
        return new cq(mutableContextWrapper, x2, bl2, bl3, h2, co2);
    }

    private cq(MutableContextWrapper mutableContextWrapper, x x2, boolean bl2, boolean bl3, h h2, co co2) {
        super((Context)mutableContextWrapper);
        this.hU = mutableContextWrapper;
        this.fg = x2;
        this.hX = bl2;
        this.go = h2;
        this.hV = co2;
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        ci.a((Context)mutableContextWrapper, co2.hP, webSettings);
        if (Build.VERSION.SDK_INT >= 17) {
            ck.a(this.getContext(), webSettings);
        } else if (Build.VERSION.SDK_INT >= 11) {
            cj.a(this.getContext(), webSettings);
        }
        this.setDownloadListener(this);
        this.hT = Build.VERSION.SDK_INT >= 11 ? new ct(this, bl3) : new cr(this, bl3);
        this.setWebViewClient(this.hT);
        if (Build.VERSION.SDK_INT >= 14) {
            this.setWebChromeClient(new cu(this));
        } else if (Build.VERSION.SDK_INT >= 11) {
            this.setWebChromeClient(new cs(this));
        }
        this.aA();
    }

    public void a(String string2, Map<String, ?> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("javascript:AFMA_ReceiveMessage('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        if (map != null) {
            try {
                String string3 = ci.l(map).toString();
                stringBuilder.append(",");
                stringBuilder.append(string3);
            }
            catch (JSONException jSONException) {
                cn.q("Could not convert AFMA event parameters to JSON.");
                return;
            }
        }
        stringBuilder.append(");");
        cn.p("Dispatching AFMA event: " + stringBuilder);
        this.loadUrl(stringBuilder.toString());
    }

    public void as() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.hV.hP);
        this.a("onhide", hashMap);
    }

    public void at() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.hV.hP);
        this.a("onshow", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public bf au() {
        Object object = this.eJ;
        synchronized (object) {
            return this.hW;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public x av() {
        Object object = this.eJ;
        synchronized (object) {
            return this.fg;
        }
    }

    public cr aw() {
        return this.hT;
    }

    public h ax() {
        return this.go;
    }

    public co ay() {
        return this.hV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean az() {
        Object object = this.eJ;
        synchronized (object) {
            return this.hX;
        }
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long size) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)url), mimeType);
            this.getContext().startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            cn.m("Couldn't find an Activity to view url/mimetype: " + url + " / " + mimeType);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.go != null) {
            this.go.a(event);
        }
        return super.onTouchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Object object = this.eJ;
        synchronized (object) {
            if (this.isInEditMode() || this.hX) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            int n2 = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n3 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n4 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n5 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int n6 = Integer.MAX_VALUE;
            if (n2 == Integer.MIN_VALUE || n2 == 0x40000000) {
                n6 = n3;
            }
            int n7 = Integer.MAX_VALUE;
            if (n4 == Integer.MIN_VALUE || n4 == 0x40000000) {
                n7 = n5;
            }
            if (this.fg.widthPixels > n6 || this.fg.heightPixels > n7) {
                cn.q("Not enough space to show ad. Needs " + this.fg.widthPixels + "x" + this.fg.heightPixels + ", but only has " + n3 + "x" + n5);
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.fg.widthPixels, this.fg.heightPixels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Context context, x x2) {
        Object object = this.eJ;
        synchronized (object) {
            this.hU.setBaseContext(context);
            this.hW = null;
            this.fg = x2;
            this.hX = false;
            ci.b(this);
            this.loadUrl("about:blank");
            this.hT.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(bf bf2) {
        Object object = this.eJ;
        synchronized (object) {
            this.hW = bf2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void i(boolean bl2) {
        Object object = this.eJ;
        synchronized (object) {
            this.hX = bl2;
            this.aA();
        }
    }

    public void setContext(Context context) {
        this.hU.setBaseContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aA() {
        Object object = this.eJ;
        synchronized (object) {
            if (this.hX || this.fg.ex) {
                if (Build.VERSION.SDK_INT < 14) {
                    cn.m("Disabling hardware acceleration on an overlay.");
                    this.aB();
                } else {
                    cn.m("Enabling hardware acceleration on an overlay.");
                    this.aC();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                cn.m("Disabling hardware acceleration on an AdView.");
                this.aB();
            } else {
                cn.m("Enabling hardware acceleration on an AdView.");
                this.aC();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aB() {
        Object object = this.eJ;
        synchronized (object) {
            if (!this.hY && Build.VERSION.SDK_INT >= 11) {
                cj.c((View)this);
            }
            this.hY = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aC() {
        Object object = this.eJ;
        synchronized (object) {
            if (this.hY && Build.VERSION.SDK_INT >= 11) {
                cj.d((View)this);
            }
            this.hY = false;
        }
    }
}

