/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.instructions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.CompoundInstruction;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionsEvaluationMessages;

public class Constructor
extends CompoundInstruction {
    private int fArgCount;
    private String fSignature;

    public Constructor(String signature, int argCount, int start) {
        super(start);
        this.fArgCount = argCount;
        this.fSignature = signature;
    }

    public void execute() throws CoreException {
        IJavaValue[] args = new IJavaValue[this.fArgCount];
        for (int i = this.fArgCount - 1; i >= 0; --i) {
            args[i] = this.popValue();
        }
        IJavaClassType clazz = (IJavaClassType)this.pop();
        IJavaObject result = clazz.newInstance(this.fSignature, args, this.getContext().getThread());
        this.push(result);
    }

    public String toString() {
        return InstructionsEvaluationMessages.getString("Constructor.constructor__1") + this.fSignature;
    }
}

