/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.EclipseHomeInitializer;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.ModelProviderEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.PluginPathFinder;
import org.eclipse.pde.internal.core.TargetPlatformRegistryLoader;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.preferences.TargetPlatformPreferencePage;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ExternalPluginsBlock {
    private CheckboxTableViewer pluginListViewer;
    private TargetPlatformPreferencePage page;
    private static final String KEY_RELOAD = "ExternalPluginsBlock.reload";
    private static final String KEY_WORKSPACE = "ExternalPluginsBlock.workspace";
    private boolean reloaded;
    private TablePart tablePart;
    private HashSet changed = new HashSet();
    private IPluginModelBase[] initialModels;
    private IPluginModelBase[] fModels;
    private PDEState fCurrentState;

    public ExternalPluginsBlock(TargetPlatformPreferencePage page) {
        this.page = page;
        String[] buttonLabels = new String[]{PDEPlugin.getResourceString(KEY_RELOAD), null, PDEPlugin.getResourceString("WizardCheckboxTablePart.selectAll"), PDEPlugin.getResourceString("WizardCheckboxTablePart.deselectAll"), null, PDEPlugin.getResourceString(KEY_WORKSPACE)};
        this.tablePart = new TablePart(buttonLabels);
        this.tablePart.setSelectAllIndex(2);
        this.tablePart.setDeselectAllIndex(3);
        PDEPlugin.getDefault().getLabelProvider().connect(this);
    }

    void computeDelta() {
        int type = 0;
        IPluginModelBase[] addedArray = null;
        IPluginModelBase[] removedArray = null;
        IModel[] changedArray = null;
        if (this.reloaded) {
            type = 3;
            removedArray = this.initialModels;
            addedArray = this.getAllModels();
        } else if (this.changed.size() > 0) {
            type |= 4;
            changedArray = this.changed.toArray(new IModel[this.changed.size()]);
        }
        this.changed.clear();
        if (type != 0) {
            ExternalModelManager registry = PDECore.getDefault().getExternalModelManager();
            ModelProviderEvent event = new ModelProviderEvent((Object)registry, type, (IModel[])addedArray, (IModel[])removedArray, changedArray);
            registry.fireModelProviderEvent((IModelProviderEvent)event);
        }
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 15;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("ExternalPluginsBlock.title"));
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.tablePart.createControl(container);
        this.pluginListViewer = this.tablePart.getTableViewer();
        this.pluginListViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.pluginListViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        gd = (GridData)this.tablePart.getControl().getLayoutData();
        gd.heightHint = 100;
        gd.widthHint = 100;
        return container;
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
    }

    private IPluginModelBase[] getAllModels() {
        if (this.fModels == null) {
            this.initialModels = PDECore.getDefault().getExternalModelManager().getAllModels();
            return this.initialModels;
        }
        return this.fModels;
    }

    protected void handleReload() {
        String platformPath = this.page.getPlatformPath();
        if (platformPath != null && platformPath.length() > 0) {
            URL[] pluginPaths = PluginPathFinder.getPluginPaths((String)platformPath);
            ReloadOperation op = new ReloadOperation(pluginPaths);
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException e) {
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.pluginListViewer.setInput((Object)PDECore.getDefault().getExternalModelManager());
            this.changed.clear();
            this.handleSelectAll(true);
            this.reloaded = true;
        }
        this.page.resetNeedsReload();
    }

    public void initialize() {
        String platformPath = this.page.getPlatformPath();
        if (platformPath != null && platformPath.length() == 0) {
            return;
        }
        this.pluginListViewer.setInput((Object)PDECore.getDefault().getExternalModelManager());
        IPluginModelBase[] allModels = this.getAllModels();
        Vector<IPluginModelBase> selection = new Vector<IPluginModelBase>();
        for (int i = 0; i < allModels.length; ++i) {
            IPluginModelBase model = allModels[i];
            if (!model.isEnabled()) continue;
            selection.add(model);
        }
        this.tablePart.setSelection(selection.toArray());
    }

    public void save() {
        BusyIndicator.showWhile((Display)this.page.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ExternalPluginsBlock.this.savePreferences();
                if (ExternalPluginsBlock.this.reloaded) {
                    EclipseHomeInitializer.resetEclipseHomeVariable();
                }
                ExternalPluginsBlock.this.updateModels();
                ExternalPluginsBlock.this.computeDelta();
            }
        });
    }

    private void savePreferences() {
        Path defaultPath;
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        Path newPath = new Path(this.page.getPlatformPath());
        String mode = ExternalPluginsBlock.arePathsEqual((IPath)newPath, (IPath)(defaultPath = new Path(ExternalModelManager.computeDefaultPlatformPath()))) ? "useThis" : "useOther";
        preferences.setValue("target_mode", mode);
        preferences.setValue("platform_path", this.page.getPlatformPath());
        String[] locations = this.page.getPlatformLocations();
        for (int i = 0; i < locations.length && i < 5; ++i) {
            preferences.setValue("saved_platform" + i, locations[i]);
        }
        PDECore.getDefault().savePluginPreferences();
    }

    private void updateModels() {
        Iterator iter = this.changed.iterator();
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            model.setEnabled(this.tablePart.getTableViewer().getChecked((Object)model));
        }
        if (this.reloaded) {
            PDECore.getDefault().getExternalModelManager().reset(this.fCurrentState, this.fModels);
        }
    }

    public static boolean arePathsEqual(IPath path1, IPath path2) {
        String device = path1.getDevice();
        if (device != null) {
            path1 = path1.setDevice(device.toUpperCase());
        }
        if ((device = path2.getDevice()) != null) {
            path2 = path2.setDevice(device.toUpperCase());
        }
        return path1.equals(path2);
    }

    private void selectNotInWorkspace() {
        WorkspaceModelManager wm = PDECore.getDefault().getWorkspaceModelManager();
        IPluginModelBase[] wsModels = wm.getAllModels();
        IPluginModelBase[] exModels = this.getAllModels();
        Vector<IPluginModelBase> selected = new Vector<IPluginModelBase>();
        for (int i = 0; i < exModels.length; ++i) {
            IPluginModelBase exModel = exModels[i];
            boolean inWorkspace = false;
            for (int j = 0; j < wsModels.length; ++j) {
                IPluginModelBase wsModel = wsModels[j];
                String extId = exModel.getPluginBase().getId();
                String wsId = wsModel.getPluginBase().getId();
                if (extId == null || wsId == null || !extId.equals(wsId)) continue;
                inWorkspace = true;
                break;
            }
            if (!inWorkspace) {
                selected.add(exModel);
            }
            if (exModel.isEnabled() == inWorkspace) {
                this.changed.add(exModel);
                continue;
            }
            if (!this.changed.contains(exModel)) continue;
            this.changed.remove(exModel);
        }
        this.tablePart.setSelection(selected.toArray());
    }

    public void handleSelectAll(boolean selected) {
        this.tablePart.selectAll(selected);
    }

    static /* synthetic */ IPluginModelBase[] access$102(ExternalPluginsBlock x0, IPluginModelBase[] x1) {
        x0.fModels = x1;
        return x1;
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String[] buttonLabels) {
            super(null, buttonLabels);
        }

        protected void buttonSelected(Button button, int index) {
            switch (index) {
                case 0: {
                    ExternalPluginsBlock.this.handleReload();
                    break;
                }
                case 5: {
                    ExternalPluginsBlock.this.selectNotInWorkspace();
                    break;
                }
                default: {
                    super.buttonSelected(button, index);
                }
            }
        }

        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit toolkit) {
            StructuredViewer viewer = super.createStructuredViewer(parent, style, toolkit);
            viewer.setSorter(ListUtil.PLUGIN_SORTER);
            return viewer;
        }

        protected void elementChecked(Object element, boolean checked) {
            IPluginModelBase model = (IPluginModelBase)element;
            if (ExternalPluginsBlock.this.changed.contains(model) && model.isEnabled() == checked) {
                ExternalPluginsBlock.this.changed.remove(model);
            } else if (model.isEnabled() != checked) {
                ExternalPluginsBlock.this.changed.add(model);
            }
            super.elementChecked(element, checked);
        }

        protected void handleSelectAll(boolean select) {
            super.handleSelectAll(select);
            IPluginModelBase[] allModels = ExternalPluginsBlock.this.getAllModels();
            for (int i = 0; i < allModels.length; ++i) {
                IPluginModelBase model = allModels[i];
                if (model.isEnabled() != select) {
                    ExternalPluginsBlock.this.changed.add(model);
                    continue;
                }
                if (!ExternalPluginsBlock.this.changed.contains(model) || model.isEnabled() != select) continue;
                ExternalPluginsBlock.this.changed.remove(model);
            }
        }
    }

    public class PluginContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            return ExternalPluginsBlock.this.getAllModels();
        }
    }

    class ReloadOperation
    implements IRunnableWithProgress {
        private URL[] pluginPaths;

        public ReloadOperation(URL[] pluginPaths) {
            this.pluginPaths = pluginPaths;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            ExternalPluginsBlock.this.fCurrentState = new PDEState();
            ExternalPluginsBlock.access$102(ExternalPluginsBlock.this, TargetPlatformRegistryLoader.loadModels((URL[])this.pluginPaths, (boolean)true, (PDEState)ExternalPluginsBlock.this.fCurrentState, (IProgressMonitor)monitor));
        }
    }
}

