/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.view;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.FileAdapter;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class PluginsLabelProvider
extends LabelProvider {
    private PDELabelProvider sharedProvider = PDEPlugin.getDefault().getLabelProvider();
    private Image projectImage;
    private Image folderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");

    public PluginsLabelProvider() {
        this.projectImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        this.sharedProvider.connect((Object)this);
    }

    public void dispose() {
        this.sharedProvider.disconnect((Object)this);
        super.dispose();
    }

    public String getText(Object obj) {
        if (obj instanceof ModelEntry) {
            return this.getText((ModelEntry)obj);
        }
        if (obj instanceof FileAdapter) {
            return this.getText((FileAdapter)obj);
        }
        if (obj instanceof IPackageFragmentRoot) {
            IPath path = ((IPackageFragmentRoot)obj).getPath();
            return path.lastSegment();
        }
        if (obj instanceof IJavaElement) {
            return ((IJavaElement)obj).getElementName();
        }
        if (obj instanceof IStorage) {
            return ((IStorage)obj).getName();
        }
        return super.getText(obj);
    }

    public Image getImage(Object obj) {
        if (obj instanceof ModelEntry) {
            return this.getImage((ModelEntry)obj);
        }
        if (obj instanceof FileAdapter) {
            return this.getImage((FileAdapter)obj);
        }
        if (obj instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)obj;
            boolean hasSource = false;
            try {
                hasSource = root.getSourceAttachmentPath() != null;
            }
            catch (JavaModelException e) {
                // empty catch block
            }
            return JavaUI.getSharedImages().getImage(hasSource ? "org.eclipse.jdt.ui.jar_lsrc_obj.gif" : "org.eclipse.jdt.ui.jar_l_obj.gif");
        }
        if (obj instanceof IPackageFragment) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
        }
        if (obj instanceof ICompilationUnit) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jcu_obj.gif");
        }
        if (obj instanceof IClassFile) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.classf_obj.gif");
        }
        if (obj instanceof IStorage) {
            String name = ((IStorage)obj).getName();
            return this.getFileImage(name);
        }
        return null;
    }

    private String getText(ModelEntry entry) {
        IPluginModelBase model = entry.getActiveModel();
        String text = this.sharedProvider.getText(model);
        if (!model.isEnabled()) {
            text = PDEPlugin.getFormattedMessage("PluginsView.disabled", text);
        }
        return text;
    }

    private String getText(FileAdapter file) {
        return file.getFile().getName();
    }

    private Image getImage(ModelEntry entry) {
        IPluginModelBase model = entry.getActiveModel();
        if (model.getUnderlyingResource() != null) {
            return this.projectImage;
        }
        if (model instanceof IPluginModel) {
            return this.sharedProvider.getObjectImage((IPlugin)model.getPluginBase(), true, entry.isInJavaSearch());
        }
        return this.sharedProvider.getObjectImage((IFragment)model.getPluginBase(), true, entry.isInJavaSearch());
    }

    private Image getImage(FileAdapter fileAdapter) {
        if (fileAdapter.isDirectory()) {
            return this.folderImage;
        }
        return this.getFileImage(fileAdapter.getFile().getName());
    }

    private Image getFileImage(String fileName) {
        ImageDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(fileName);
        return this.sharedProvider.get(desc);
    }
}

