/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewProjectCreationPage
extends WizardNewProjectCreationPage {
    protected Button fJavaButton;
    protected boolean fIsFragment;
    protected Button fBundleCheck;
    private Label fSourceLabel;
    private Text fSourceText;
    private Label fOutputlabel;
    private Text fOutputText;
    private AbstractFieldData fData;

    public NewProjectCreationPage(String pageName, AbstractFieldData data, boolean isFragment) {
        super(pageName);
        this.fIsFragment = isFragment;
        this.fData = data;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite control = (Composite)this.getControl();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        control.setLayout((Layout)layout);
        this.createProjectTypeGroup(control);
        this.createBundleStructureGroup(control);
        Dialog.applyDialogFont((Control)control);
        this.setControl((Control)control);
    }

    private void createProjectTypeGroup(Composite container) {
        Group group = new Group(container, 0);
        group.setText(PDEPlugin.getResourceString("ProjectStructurePage.settings"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.fJavaButton = this.createButton((Composite)group);
        this.fJavaButton.setText(PDEPlugin.getResourceString("ProjectStructurePage.java"));
        this.fJavaButton.setSelection(true);
        this.fJavaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = NewProjectCreationPage.this.fJavaButton.getSelection();
                NewProjectCreationPage.this.fSourceLabel.setEnabled(enabled);
                NewProjectCreationPage.this.fSourceText.setEnabled(enabled);
                NewProjectCreationPage.this.fOutputlabel.setEnabled(enabled);
                NewProjectCreationPage.this.fOutputText.setEnabled(enabled);
                NewProjectCreationPage.this.validatePage();
            }
        });
        this.fSourceLabel = this.createLabel((Composite)group, PDEPlugin.getResourceString("ProjectStructurePage.source"));
        this.fSourceText = this.createText((Composite)group);
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        this.fSourceText.setText(store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName"));
        this.fOutputlabel = this.createLabel((Composite)group, PDEPlugin.getResourceString("ProjectStructurePage.output"));
        this.fOutputText = this.createText((Composite)group);
        this.fOutputText.setText(store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
    }

    private void createBundleStructureGroup(Composite container) {
        Group group = new Group(container, 0);
        group.setText(PDEPlugin.getResourceString("ProjectStructurePage.alternateFormat"));
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        this.fBundleCheck = new Button((Composite)group, 32);
        if (this.fIsFragment) {
            this.fBundleCheck.setText(PDEPlugin.getResourceString("ProjectStructurePage.fbundle"));
        } else {
            this.fBundleCheck.setText(PDEPlugin.getResourceString("ProjectStructurePage.pbundle"));
        }
        Label label = new Label((Composite)group, 64);
        label.setText(PDEPlugin.getResourceString("ProjectStructurePage.note"));
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        gd.horizontalIndent = 22;
        label.setLayoutData((Object)gd);
    }

    private Button createButton(Composite container) {
        Button button = new Button(container, 32);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        button.setLayoutData((Object)gd);
        return button;
    }

    public boolean hasBundleStructure() {
        if (this.fBundleCheck == null) {
            return false;
        }
        return this.fBundleCheck.getSelection();
    }

    public boolean isJavaProject() {
        if (this.fJavaButton == null) {
            return false;
        }
        return this.fJavaButton.getSelection();
    }

    private Label createLabel(Composite container, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalIndent = 22;
        label.setLayoutData((Object)gd);
        return label;
    }

    private Text createText(Composite container) {
        Text text = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        text.setLayoutData((Object)gd);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewProjectCreationPage.this.validatePage();
            }
        });
        return text;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.updateData();
        }
    }

    public void updateData() {
        this.fData.setIsSimple(!this.isJavaProject());
        this.fData.setSourceFolderName(this.fSourceText.getText().trim());
        this.fData.setOutputFolderName(this.fOutputText.getText().trim());
        this.fData.setHasBundleStructure(this.fBundleCheck.getSelection());
    }
}

