/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseFile;
import org.eclipse.team.internal.ccvs.core.resources.EclipseResource;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;

class EclipseFolder
extends EclipseResource
implements ICVSFolder {
    protected EclipseFolder(IContainer container) {
        super((IResource)container);
    }

    public ICVSResource[] members(int flags) throws CVSException {
        ArrayList<ICVSResource> result = new ArrayList<ICVSResource>();
        IResource[] resources = EclipseSynchronizer.getInstance().members((IContainer)this.resource);
        boolean includeFiles = (flags & 1) != 0 || (flags & 3) == 0;
        boolean includeFolders = (flags & 2) != 0 || (flags & 3) == 0;
        boolean includeManaged = (flags & 0x10) != 0 || (flags & 0x1C) == 0;
        boolean includeUnmanaged = (flags & 8) != 0 || (flags & 0x1C) == 0;
        boolean includeIgnored = (flags & 4) != 0;
        boolean includeExisting = (flags & 0x20) != 0 || (flags & 0x60) == 0;
        boolean includePhantoms = (flags & 0x40) != 0 || (flags & 0x60) == 0;
        for (int i = 0; i < resources.length; ++i) {
            IResource resource = resources[i];
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor(resource);
            if ((!includeFiles || resource.getType() != 1) && (!includeFolders || resource.getType() != 2)) continue;
            boolean isManaged = cvsResource.isManaged();
            boolean isIgnored = cvsResource.isIgnored();
            if (!(isManaged && includeManaged || isIgnored && includeIgnored) && (isManaged || isIgnored || !includeUnmanaged)) continue;
            boolean exists = cvsResource.exists();
            if ((!includeExisting || !exists) && (!includePhantoms || exists || !isManaged)) continue;
            result.add(cvsResource);
        }
        return result.toArray(new ICVSResource[result.size()]);
    }

    public ICVSFolder getFolder(String name) throws CVSException {
        if (".".equals(name) || "./".equals(name)) {
            return this;
        }
        Path path = new Path(name);
        if (this.resource.getType() == 8 && path.segmentCount() == 1) {
            return new EclipseFolder((IContainer)((IWorkspaceRoot)this.resource).getProject(name));
        }
        return new EclipseFolder((IContainer)((IContainer)this.resource).getFolder((IPath)new Path(name)));
    }

    public ICVSFile getFile(String name) throws CVSException {
        return new EclipseFile(((IContainer)this.resource).getFile((IPath)new Path(name)));
    }

    public void mkdir() throws CVSException {
        try {
            if (this.resource.getType() == 4) {
                IProject project = (IProject)this.resource;
                project.create(null);
                project.open(null);
            } else {
                ((IFolder)this.resource).create(false, true, null);
                EclipseSynchronizer.getInstance().created(this.getIResource());
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException(this.resource, Policy.bind("EclipseFolder_problem_creating", this.resource.getFullPath().toString(), e.getStatus().getMessage()), e);
        }
    }

    public boolean isFolder() {
        return true;
    }

    public void acceptChildren(ICVSResourceVisitor visitor) throws CVSException {
        ICVSResource[] subFiles = this.members(1);
        for (int i = 0; i < subFiles.length; ++i) {
            subFiles[i].accept(visitor);
        }
        ICVSResource[] subFolders = this.members(2);
        for (int i = 0; i < subFolders.length; ++i) {
            subFolders[i].accept(visitor);
        }
    }

    public void accept(ICVSResourceVisitor visitor) throws CVSException {
        visitor.visitFolder(this);
    }

    public void accept(ICVSResourceVisitor visitor, boolean recurse) throws CVSException {
        visitor.visitFolder(this);
        ICVSResource[] resources = recurse ? this.members(127) : this.members(1);
        for (int i = 0; i < resources.length; ++i) {
            resources[i].accept(visitor, recurse);
        }
    }

    public String getRemoteLocation(ICVSFolder stopSearching) throws CVSException {
        String parentLocation;
        if (this.getFolderSyncInfo() != null) {
            return this.getFolderSyncInfo().getRemoteLocation();
        }
        ICVSFolder parent = this.getParent();
        if (parent != null && !this.equals(stopSearching) && (parentLocation = parent.getRemoteLocation(stopSearching)) != null) {
            return parentLocation + "/" + this.getName();
        }
        return null;
    }

    public FolderSyncInfo getFolderSyncInfo() throws CVSException {
        return EclipseSynchronizer.getInstance().getFolderSync((IContainer)this.resource);
    }

    public void setFolderSyncInfo(final FolderSyncInfo folderInfo) throws CVSException {
        if (this.resource.getType() == 8) {
            return;
        }
        this.run(new ICVSRunnable(){

            public void run(IProgressMonitor monitor) throws CVSException {
                EclipseSynchronizer synchronizer = EclipseSynchronizer.getInstance();
                synchronizer.setFolderSync((IContainer)EclipseFolder.this.resource, folderInfo);
                byte[] newSyncBytes = new ResourceSyncInfo(EclipseFolder.this.getName()).getBytes();
                byte[] oldSyncBytes = EclipseFolder.this.getSyncBytes();
                if (oldSyncBytes == null || !Util.equals(newSyncBytes, oldSyncBytes)) {
                    EclipseFolder.this.setSyncBytes(newSyncBytes);
                }
            }
        }, null);
    }

    public boolean isCVSFolder() throws CVSException {
        return EclipseSynchronizer.getInstance().getFolderSync((IContainer)this.resource) != null;
    }

    public void unmanage(IProgressMonitor monitor) throws CVSException {
        this.run(new ICVSRunnable(){

            public void run(IProgressMonitor monitor) throws CVSException {
                monitor = Policy.monitorFor(monitor);
                monitor.beginTask(null, 100);
                EclipseFolder.recursiveUnmanage((IContainer)EclipseFolder.this.resource, Policy.subMonitorFor(monitor, 99));
                EclipseFolder.super.unmanage(Policy.subMonitorFor(monitor, 1));
                monitor.done();
            }
        }, Policy.subMonitorFor(monitor, 99));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void recursiveUnmanage(IContainer container, IProgressMonitor monitor) {
        try {
            monitor.beginTask(null, 10);
            monitor.subTask(container.getFullPath().toOSString());
            EclipseSynchronizer.getInstance().deleteFolderSync(container);
            IResource[] members = container.members(true);
            for (int i = 0; i < members.length; ++i) {
                monitor.worked(1);
                IResource resource = members[i];
                if (members[i].getType() == 1) continue;
                EclipseFolder.recursiveUnmanage((IContainer)resource, monitor);
            }
        }
        catch (CoreException coreException) {
        }
        finally {
            monitor.done();
        }
    }

    public boolean isIgnored() throws CVSException {
        if (this.isCVSFolder()) {
            return false;
        }
        return super.isIgnored();
    }

    public ICVSResource getChild(String namedPath) throws CVSException {
        Path path = new Path(namedPath);
        if (path.segmentCount() == 0) {
            return this;
        }
        IResource child = ((IContainer)this.resource).findMember((IPath)path, true);
        if (child != null) {
            if (child.getType() == 1) {
                return new EclipseFile((IFile)child);
            }
            return new EclipseFolder((IContainer)child);
        }
        return null;
    }

    public ICVSResource[] fetchChildren(IProgressMonitor monitor) throws CVSException {
        return this.members(3);
    }

    public void delete() throws CVSException {
        if (!this.exists()) {
            return;
        }
        try {
            this.resource.delete(false, null);
        }
        catch (CoreException e) {
            throw new CVSException(e.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModified(IProgressMonitor monitor) throws CVSException {
        try {
            boolean modified;
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(Policy.bind("EclipseFolder.isModifiedProgress", this.resource.getFullPath().toString()), 1000);
            IContainer container = (IContainer)this.getIResource();
            int state = EclipseSynchronizer.getInstance().getModificationState(this.getIResource());
            if (state == 0) {
                if (!this.isCVSFolder()) {
                    boolean bl = container.exists();
                    return bl;
                }
                modified = this.calculateAndSaveChildModificationStates(monitor);
                EclipseSynchronizer.getInstance().setModified(this, modified);
            } else {
                modified = state == 2;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    public void handleModification(boolean forAddition) throws CVSException {
        if (this.isIgnored() || !forAddition) {
            return;
        }
        FolderSyncInfo info = this.getFolderSyncInfo();
        if (info == null) {
            EclipseSynchronizer.getInstance().setDirtyIndicator(this.getIResource(), true);
        }
    }

    private boolean calculateAndSaveChildModificationStates(IProgressMonitor monitor) throws CVSException {
        ICVSResource[] children = this.members(123);
        for (int i = 0; i < children.length; ++i) {
            ICVSResource resource = children[i];
            if (resource.isModified(null)) {
                return true;
            }
            monitor.worked(1);
        }
        return false;
    }

    public String getRepositoryRelativePath() throws CVSException {
        FolderSyncInfo info = this.getFolderSyncInfo();
        if (info == null) {
            return null;
        }
        return info.getRepository();
    }
}

