/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecorationBuilder;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.internal.decorators.LightweightDecoratorDefinition;
import org.eclipse.ui.internal.decorators.OverlayCache;
import org.eclipse.ui.internal.misc.StatusUtil;

class LightweightDecoratorManager {
    private LightweightRunnable runnable = new LightweightRunnable();
    private HashMap cachedLightweightDecorators = new HashMap();
    private LightweightDecoratorDefinition[] lightweightDefinitions;
    private static final LightweightDecoratorDefinition[] EMPTY_LIGHTWEIGHT_DEF = new LightweightDecoratorDefinition[0];
    private OverlayCache overlayCache = new OverlayCache();

    LightweightDecoratorManager(LightweightDecoratorDefinition[] definitions) {
        this.lightweightDefinitions = definitions;
    }

    LightweightDecoratorDefinition[] getDefinitions() {
        return this.lightweightDefinitions;
    }

    public boolean addDecorator(LightweightDecoratorDefinition decorator) {
        if (this.getLightweightDecoratorDefinition(decorator.getId()) == null) {
            LightweightDecoratorDefinition[] oldDefs = this.lightweightDefinitions;
            this.lightweightDefinitions = new LightweightDecoratorDefinition[this.lightweightDefinitions.length + 1];
            System.arraycopy(oldDefs, 0, this.lightweightDefinitions, 0, oldDefs.length);
            this.lightweightDefinitions[oldDefs.length] = decorator;
            return true;
        }
        return false;
    }

    private LightweightDecoratorDefinition getLightweightDecoratorDefinition(String decoratorId) {
        for (int i = 0; i < this.lightweightDefinitions.length; ++i) {
            if (!this.lightweightDefinitions[i].getId().equals(decoratorId)) continue;
            return this.lightweightDefinitions[i];
        }
        return null;
    }

    LightweightDecoratorDefinition[] enabledDefinitions() {
        ArrayList<LightweightDecoratorDefinition> result = new ArrayList<LightweightDecoratorDefinition>();
        for (int i = 0; i < this.lightweightDefinitions.length; ++i) {
            if (!this.lightweightDefinitions[i].isEnabled()) continue;
            result.add(this.lightweightDefinitions[i]);
        }
        LightweightDecoratorDefinition[] returnArray = new LightweightDecoratorDefinition[result.size()];
        result.toArray(returnArray);
        return returnArray;
    }

    boolean hasEnabledDefinitions() {
        for (int i = 0; i < this.lightweightDefinitions.length; ++i) {
            if (!this.lightweightDefinitions[i].isEnabled()) continue;
            return true;
        }
        return false;
    }

    void reset() {
        this.cachedLightweightDecorators.clear();
    }

    void shutdown() {
        for (int i = 0; i < this.lightweightDefinitions.length; ++i) {
            if (!this.lightweightDefinitions[i].isEnabled()) continue;
            this.lightweightDefinitions[i].setEnabled(false);
        }
        this.overlayCache.disposeAll();
    }

    LightweightDecoratorDefinition getDecoratorDefinition(String decoratorId) {
        for (int i = 0; i < this.lightweightDefinitions.length; ++i) {
            if (!this.lightweightDefinitions[i].getId().equals(decoratorId)) continue;
            return this.lightweightDefinitions[i];
        }
        return null;
    }

    LightweightDecoratorDefinition[] getDecoratorsFor(Object element) {
        if (element == null) {
            return EMPTY_LIGHTWEIGHT_DEF;
        }
        String className = element.getClass().getName();
        LightweightDecoratorDefinition[] decoratorArray = (LightweightDecoratorDefinition[])this.cachedLightweightDecorators.get(className);
        if (decoratorArray != null) {
            return decoratorArray;
        }
        Collection decorators = DecoratorManager.getDecoratorsFor(element, this.enabledDefinitions());
        if (decorators.size() == 0) {
            decoratorArray = EMPTY_LIGHTWEIGHT_DEF;
        } else {
            decoratorArray = new LightweightDecoratorDefinition[decorators.size()];
            decorators.toArray(decoratorArray);
        }
        this.cachedLightweightDecorators.put(className, decoratorArray);
        return decoratorArray;
    }

    void getDecorations(Object element, DecorationBuilder decoration, boolean adaptableDecoration) {
        LightweightDecoratorDefinition[] decorators = this.getDecoratorsFor(element);
        for (int i = 0; i < decorators.length; ++i) {
            if (adaptableDecoration && !decorators[i].isAdaptable() || !decorators[i].getEnablement().isEnabledFor(element)) continue;
            decoration.setCurrentDefinition(decorators[i]);
            this.decorate(element, decoration, decorators[i]);
        }
    }

    private void decorate(Object element, DecorationBuilder decoration, LightweightDecoratorDefinition decorator) {
        this.runnable.setValues(element, decoration, decorator);
        Platform.run((ISafeRunnable)this.runnable);
    }

    OverlayCache getOverlayCache() {
        return this.overlayCache;
    }

    private class LightweightRunnable
    implements ISafeRunnable {
        private Object element;
        private DecorationBuilder decoration;
        private LightweightDecoratorDefinition decorator;

        private LightweightRunnable() {
        }

        void setValues(Object object, DecorationBuilder builder, LightweightDecoratorDefinition definition) {
            this.element = object;
            this.decoration = builder;
            this.decorator = definition;
        }

        public void handleException(Throwable exception) {
            IStatus status = StatusUtil.newStatus(4, exception.getMessage(), exception);
            WorkbenchPlugin.log("Exception in Decorator", status);
            this.decorator.crashDisable();
        }

        public void run() throws Exception {
            this.decorator.decorate(this.element, this.decoration);
        }
    }
}

