/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.pde.core.ISourceObject;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;

public abstract class SchemaObject
extends PlatformObject
implements ISchemaObject,
ISourceObject,
Serializable {
    protected String name;
    private String description;
    private transient ISchemaObject parent;
    private Vector comments;
    private int[] range;

    public SchemaObject(ISchemaObject parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public ISchemaObject getParent() {
        return this.parent;
    }

    public void setParent(ISchemaObject parent) {
        this.parent = parent;
    }

    public ISchema getSchema() {
        ISchemaObject object = this;
        while (object.getParent() != null) {
            object = object.getParent();
        }
        return (ISchema)object;
    }

    public String getWritableDescription() {
        return SchemaObject.getWritableDescription(this.getDescription());
    }

    public static String getWritableDescription(String input) {
        if (input == null) {
            return "";
        }
        String result = input.trim();
        StringBuffer buf = new StringBuffer();
        block7: for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block7;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    buf.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public void setDescription(String newDescription) {
        String oldValue = this.description;
        this.description = newDescription;
        this.getSchema().fireModelObjectChanged(this, "description", oldValue, this.description);
    }

    public void setName(String newName) {
        String oldValue = this.name;
        this.name = newName;
        this.getSchema().fireModelObjectChanged(this, "name", oldValue, this.name);
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }

    public void addComments(Node node) {
        this.comments = this.addComments(node, this.comments);
    }

    public Vector addComments(Node node, Vector result) {
        for (Node prev = node.getPreviousSibling(); prev != null; prev = prev.getPreviousSibling()) {
            if (prev.getNodeType() == 3) continue;
            if (!(prev instanceof Comment)) break;
            String comment = prev.getNodeValue();
            if (result == null) {
                result = new Vector<String>();
            }
            result.add(comment);
        }
        return result;
    }

    void writeComments(PrintWriter writer) {
        this.writeComments(writer, this.comments);
    }

    void writeComments(PrintWriter writer, Vector source) {
        if (source == null) {
            return;
        }
        for (int i = 0; i < source.size(); ++i) {
            String comment = (String)source.elementAt(i);
            writer.println("<!--" + comment + "-->");
        }
    }

    public int getStartLine() {
        if (this.range == null) {
            return -1;
        }
        return this.range[0];
    }

    public int getStopLine() {
        if (this.range == null) {
            return -1;
        }
        return this.range[1];
    }

    void bindSourceLocation(Node node, Hashtable lineTable) {
        if (lineTable == null) {
            return;
        }
        Integer[] lines = (Integer[])lineTable.get(node);
        if (lines != null) {
            this.range = new int[]{lines[0], lines[1]};
        }
    }
}

