/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;

public class ASTNodeSearchUtil {
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$MethodDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$VariableDeclarationFragment;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$FieldDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$TypeDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ClassInstanceCreation;

    private ASTNodeSearchUtil() {
    }

    public static ASTNode[] getAstNodes(SearchMatch[] searchResults, CompilationUnit cuNode) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(searchResults.length);
        for (int i = 0; i < searchResults.length; ++i) {
            ASTNode node = ASTNodeSearchUtil.getAstNode(searchResults[i], cuNode);
            if (node == null) continue;
            result.add(node);
        }
        return result.toArray(new ASTNode[result.size()]);
    }

    public static ASTNode getAstNode(SearchMatch searchResult, CompilationUnit cuNode) {
        ASTNode selectedNode = ASTNodeSearchUtil.getAstNode(cuNode, searchResult.getOffset(), searchResult.getLength());
        if (selectedNode == null) {
            return null;
        }
        if (selectedNode.getParent() == null) {
            return null;
        }
        return selectedNode;
    }

    private static ASTNode getAstNode(CompilationUnit cuNode, int start, int length) {
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(start, length), true);
        cuNode.accept((ASTVisitor)analyzer);
        ASTNode node = analyzer.getFirstSelectedNode();
        if (node == null && analyzer.getLastCoveringNode() instanceof SuperConstructorInvocation) {
            node = analyzer.getLastCoveringNode().getParent();
        } else if (node == null && analyzer.getLastCoveringNode() instanceof ConstructorInvocation) {
            node = analyzer.getLastCoveringNode().getParent();
        }
        if (node == null) {
            return null;
        }
        ASTNode parentNode = node.getParent();
        if (parentNode instanceof MethodDeclaration) {
            MethodDeclaration md = (MethodDeclaration)parentNode;
            if (!(node instanceof SimpleName) && md.isConstructor() && md.getBody() != null && md.getBody().statements().size() > 0 && (md.getBody().statements().get(0) instanceof ConstructorInvocation || md.getBody().statements().get(0) instanceof SuperConstructorInvocation) && ((ASTNode)md.getBody().statements().get(0)).getLength() == length + 1) {
                return (ASTNode)md.getBody().statements().get(0);
            }
        }
        if (parentNode instanceof SuperConstructorInvocation && parentNode.getLength() == length + 1) {
            return parentNode;
        }
        if (parentNode instanceof ConstructorInvocation && parentNode.getLength() == length + 1) {
            return parentNode;
        }
        return node;
    }

    public static MethodDeclaration getMethodDeclarationNode(IMethod iMethod, CompilationUnit cuNode) throws JavaModelException {
        return (MethodDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode((IMember)iMethod, cuNode), class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = ASTNodeSearchUtil.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration);
    }

    public static VariableDeclarationFragment getFieldDeclarationFragmentNode(IField iField, CompilationUnit cuNode) throws JavaModelException {
        ASTNode node = ASTNodeSearchUtil.getNameNode((IMember)iField, cuNode);
        if (node instanceof VariableDeclarationFragment) {
            return (VariableDeclarationFragment)node;
        }
        return (VariableDeclarationFragment)ASTNodes.getParent(node, class$org$eclipse$jdt$core$dom$VariableDeclarationFragment == null ? (class$org$eclipse$jdt$core$dom$VariableDeclarationFragment = ASTNodeSearchUtil.class$("org.eclipse.jdt.core.dom.VariableDeclarationFragment")) : class$org$eclipse$jdt$core$dom$VariableDeclarationFragment);
    }

    public static FieldDeclaration getFieldDeclarationNode(IField iField, CompilationUnit cuNode) throws JavaModelException {
        return (FieldDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode((IMember)iField, cuNode), class$org$eclipse$jdt$core$dom$FieldDeclaration == null ? (class$org$eclipse$jdt$core$dom$FieldDeclaration = ASTNodeSearchUtil.class$("org.eclipse.jdt.core.dom.FieldDeclaration")) : class$org$eclipse$jdt$core$dom$FieldDeclaration);
    }

    public static TypeDeclaration getTypeDeclarationNode(IType iType, CompilationUnit cuNode) throws JavaModelException {
        return (TypeDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode((IMember)iType, cuNode), class$org$eclipse$jdt$core$dom$TypeDeclaration == null ? (class$org$eclipse$jdt$core$dom$TypeDeclaration = ASTNodeSearchUtil.class$("org.eclipse.jdt.core.dom.TypeDeclaration")) : class$org$eclipse$jdt$core$dom$TypeDeclaration);
    }

    public static ClassInstanceCreation getClassInstanceCreationNode(IType iType, CompilationUnit cuNode) throws JavaModelException {
        return (ClassInstanceCreation)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode((IMember)iType, cuNode), class$org$eclipse$jdt$core$dom$ClassInstanceCreation == null ? (class$org$eclipse$jdt$core$dom$ClassInstanceCreation = ASTNodeSearchUtil.class$("org.eclipse.jdt.core.dom.ClassInstanceCreation")) : class$org$eclipse$jdt$core$dom$ClassInstanceCreation);
    }

    public static List getBodyDeclarationList(IType iType, CompilationUnit cuNode) throws JavaModelException {
        if (iType.isAnonymous()) {
            return ASTNodeSearchUtil.getClassInstanceCreationNode(iType, cuNode).getAnonymousClassDeclaration().bodyDeclarations();
        }
        return ASTNodeSearchUtil.getTypeDeclarationNode(iType, cuNode).bodyDeclarations();
    }

    public static ASTNode[] getDeclarationNodes(IJavaElement element, CompilationUnit cuNode) throws JavaModelException {
        switch (element.getElementType()) {
            case 8: {
                return new ASTNode[]{ASTNodeSearchUtil.getFieldDeclarationNode((IField)element, cuNode)};
            }
            case 12: {
                return ASTNodeSearchUtil.getImportNodes((IImportContainer)element, cuNode);
            }
            case 13: {
                return new ASTNode[]{ASTNodeSearchUtil.getImportDeclarationNode((IImportDeclaration)element, cuNode)};
            }
            case 10: {
                return new ASTNode[]{ASTNodeSearchUtil.getInitializerNode((IInitializer)element, cuNode)};
            }
            case 9: {
                return new ASTNode[]{ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)element, cuNode)};
            }
            case 11: {
                return new ASTNode[]{ASTNodeSearchUtil.getPackageDeclarationNode((IPackageDeclaration)element, cuNode)};
            }
            case 7: {
                return new ASTNode[]{ASTNodeSearchUtil.getTypeDeclarationNode((IType)element, cuNode)};
            }
        }
        Assert.isTrue(false, String.valueOf(element.getElementType()));
        return null;
    }

    private static ASTNode getNameNode(IMember iMember, CompilationUnit cuNode) throws JavaModelException {
        return NodeFinder.perform((ASTNode)cuNode, iMember.getNameRange());
    }

    public static PackageDeclaration getPackageDeclarationNode(IPackageDeclaration reference, CompilationUnit cuNode) throws JavaModelException {
        return (PackageDeclaration)ASTNodeSearchUtil.findNode(reference.getSourceRange(), cuNode);
    }

    public static ImportDeclaration getImportDeclarationNode(IImportDeclaration reference, CompilationUnit cuNode) throws JavaModelException {
        return (ImportDeclaration)ASTNodeSearchUtil.findNode(reference.getSourceRange(), cuNode);
    }

    public static ASTNode[] getImportNodes(IImportContainer reference, CompilationUnit cuNode) throws JavaModelException {
        IJavaElement[] imps = reference.getChildren();
        ASTNode[] result = new ASTNode[imps.length];
        for (int i = 0; i < imps.length; ++i) {
            result[i] = ASTNodeSearchUtil.getImportDeclarationNode((IImportDeclaration)imps[i], cuNode);
        }
        return result;
    }

    public static Initializer getInitializerNode(IInitializer initializer, CompilationUnit cuNode) throws JavaModelException {
        ASTNode node = ASTNodeSearchUtil.findNode(initializer.getSourceRange(), cuNode);
        if (node instanceof Initializer) {
            return (Initializer)node;
        }
        if (node instanceof Block && node.getParent() instanceof Initializer) {
            return (Initializer)node.getParent();
        }
        return null;
    }

    private static ASTNode findNode(ISourceRange range, CompilationUnit cuNode) {
        NodeFinder nodeFinder = new NodeFinder(range.getOffset(), range.getLength());
        cuNode.accept((ASTVisitor)nodeFinder);
        ASTNode coveredNode = nodeFinder.getCoveredNode();
        if (coveredNode != null) {
            return coveredNode;
        }
        return nodeFinder.getCoveringNode();
    }

    public static ASTNode[] findNodes(SearchMatch[] searchResults, CompilationUnit cuNode) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(searchResults.length);
        for (int i = 0; i < searchResults.length; ++i) {
            ASTNode node = ASTNodeSearchUtil.findNode(searchResults[i], cuNode);
            if (node == null) continue;
            result.add(node);
        }
        return result.toArray(new ASTNode[result.size()]);
    }

    public static ASTNode findNode(SearchMatch searchResult, CompilationUnit cuNode) {
        ASTNode selectedNode = NodeFinder.perform((ASTNode)cuNode, searchResult.getOffset(), searchResult.getLength());
        if (selectedNode == null) {
            return null;
        }
        if (selectedNode.getParent() == null) {
            return null;
        }
        return selectedNode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

