/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.jdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

class LocationLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final int COLUMN_ICON = 0;
    private static final int COLUMN_LINE = 1;
    private static final int COLUMN_INFO = 2;

    LocationLabelProvider() {
    }

    public String getText(Object element) {
        return this.getColumnText(element, 2);
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    private String removeWhitespaceOutsideStringLiterals(CallLocation callLocation) {
        StringBuffer buf = new StringBuffer();
        boolean withinString = false;
        String s = callLocation.getCallText();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '\"') {
                boolean bl = withinString = !withinString;
            }
            if (withinString) {
                buf.append(ch);
                continue;
            }
            if (Character.isWhitespace(ch)) {
                if (buf.length() != 0 && Character.isWhitespace(buf.charAt(buf.length() - 1))) continue;
                if (ch != ' ') {
                    ch = ' ';
                }
                buf.append(ch);
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return JavaPluginImages.get("org.eclipse.jdt.ui.occ_match.gif");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof CallLocation) {
            CallLocation callLocation = (CallLocation)element;
            switch (columnIndex) {
                case 1: {
                    int lineNumber = callLocation.getLineNumber();
                    if (lineNumber == -1) {
                        return CallHierarchyMessages.getString("LocationLabelProvider.unknown");
                    }
                    return String.valueOf(lineNumber);
                }
                case 2: {
                    return this.removeWhitespaceOutsideStringLiterals(callLocation);
                }
            }
        }
        return "";
    }
}

