/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.search.ui.IGroupByKeyComputer;

public class GroupByKeyComputer
implements IGroupByKeyComputer {
    IJavaElement fLastJavaElement = null;
    String fLastHandle = null;

    public Object computeGroupByKey(IMarker marker) {
        if (marker == null) {
            return null;
        }
        IJavaElement jElement = this.getJavaElement(marker);
        if (jElement != null && jElement.exists()) {
            return this.fLastHandle;
        }
        return null;
    }

    private String getJavaElementHandleId(IMarker marker) {
        try {
            return (String)marker.getAttribute("org.eclipse.jdt.internal.ui.search.handleID");
        }
        catch (CoreException ex) {
            ExceptionHandler.handle(ex, SearchMessages.getString("Search.Error.markerAttributeAccess.title"), SearchMessages.getString("Search.Error.markerAttributeAccess.message"));
            return null;
        }
    }

    private IJavaElement getJavaElement(IMarker marker) {
        String handle = this.getJavaElementHandleId(marker);
        if (handle == null) {
            this.fLastHandle = null;
            this.fLastJavaElement = null;
            return null;
        }
        if (!handle.equals(this.fLastHandle)) {
            this.fLastJavaElement = SearchUtil.getJavaElement(marker);
            this.fLastHandle = this.fLastJavaElement != null ? this.fLastJavaElement.getHandleIdentifier() : null;
        }
        return this.fLastJavaElement;
    }
}

