/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class JavaSearchResultLabelProvider
extends LabelProvider {
    public static final int SHOW_ELEMENT_CONTAINER = 1;
    public static final int SHOW_CONTAINER_ELEMENT = 2;
    public static final int SHOW_PATH = 3;
    public static final String POTENTIAL_MATCH = SearchMessages.getString("JavaSearchResultLabelProvider.potentialMatch");
    private AppearanceAwareLabelProvider fLabelProvider;
    private ILabelDecorator fDecorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
    private IMarker fLastMarker;
    private IJavaElement fLastJavaElement;

    public JavaSearchResultLabelProvider() {
        this.fLabelProvider = new AppearanceAwareLabelProvider(1627389961, 1);
        this.fLabelProvider.addLabelDecorator(new ProblemsLabelDecorator(null));
    }

    public String getText(Object o) {
        String decoratedText;
        boolean isPotentialMatch;
        this.fLastMarker = null;
        IJavaElement javaElement = this.getJavaElement(o);
        boolean bl = isPotentialMatch = this.fLastMarker != null && this.fLastMarker.getAttribute("potentialMatch", false);
        if (javaElement == null) {
            if (this.fLastMarker != null) {
                if (isPotentialMatch) {
                    return super.getText((Object)this.fLastMarker.getResource()) + POTENTIAL_MATCH;
                }
                return super.getText((Object)this.fLastMarker.getResource());
            }
            return "";
        }
        if (javaElement instanceof IImportDeclaration) {
            javaElement = ((IImportDeclaration)javaElement).getParent().getParent();
        }
        String text = "";
        text = isPotentialMatch ? this.fLabelProvider.getText(javaElement) + POTENTIAL_MATCH : this.fLabelProvider.getText(javaElement);
        if (this.fDecorator != null && (decoratedText = this.fDecorator.decorateText(text, (Object)javaElement)) != null) {
            return decoratedText;
        }
        return text;
    }

    public Image getImage(Object o) {
        Image decoratedImage;
        IJavaElement javaElement = this.getJavaElement(o);
        Image image = this.fLabelProvider.getImage(o);
        if (image == null) {
            return JavaPluginImages.get("org.eclipse.jdt.ui.unknown_obj.gif");
        }
        if (this.fDecorator != null && javaElement != null && (decoratedImage = this.fDecorator.decorateImage(image, (Object)javaElement)) != null) {
            return decoratedImage;
        }
        return image;
    }

    public void setAppearance(int appearanceFlag) {
        int flags = 1627389961;
        if (appearanceFlag == 1) {
            flags |= 0x2A9141;
        } else if (appearanceFlag == 2) {
            flags |= 0x1528A1;
        } else if (appearanceFlag == 3) {
            flags |= 0x1528A1;
            flags |= 0x10000000;
        }
        this.fLabelProvider.setTextFlags(flags);
    }

    private IJavaElement getJavaElement(Object o) {
        if (o instanceof IJavaElement) {
            return (IJavaElement)o;
        }
        IMarker marker = this.getMarker(o);
        if (marker == null) {
            return null;
        }
        return this.getJavaElement(marker, (ISearchResultViewEntry)o);
    }

    protected IMarker getMarker(Object o) {
        if (!(o instanceof ISearchResultViewEntry)) {
            return null;
        }
        return ((ISearchResultViewEntry)o).getSelectedMarker();
    }

    private IJavaElement getJavaElement(IMarker marker, ISearchResultViewEntry entry) {
        if (this.fLastMarker != marker) {
            boolean canUseGroupByKey = !marker.getAttribute("potentialMatch", false) && !marker.getAttribute("org.eclipse.jdt.internal.ui.search.isWorkingCopy", false) && !marker.getAttribute("org.eclipse.jdt.internal.ui.search.handleIdChanged", false);
            this.fLastJavaElement = canUseGroupByKey && entry.getGroupByKey() instanceof IJavaElement ? (IJavaElement)entry.getGroupByKey() : SearchUtil.getJavaElement(marker);
            this.fLastMarker = marker;
        }
        return this.fLastJavaElement;
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        this.fLabelProvider.addListener(listener);
    }

    public void dispose() {
        super.dispose();
        this.fLabelProvider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.fLabelProvider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        this.fLabelProvider.removeListener(listener);
    }
}

