/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.internal.ui.refactoring.Assert;

public class WorkbenchRunnableAdapter
implements IRunnableWithProgress {
    private IWorkspaceRunnable fWorkspaceRunnable;
    private ISchedulingRule fRule;

    public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable, ISchedulingRule rule) {
        Assert.isNotNull(runnable);
        Assert.isNotNull(rule);
        this.fWorkspaceRunnable = runnable;
        this.fRule = rule;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.fRule;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            ResourcesPlugin.getWorkspace().run(this.fWorkspaceRunnable, this.fRule, 1, monitor);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }
}

