/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.cheatsheets.CheatSheetStopWatch;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheet;
import org.eclipse.ui.internal.cheatsheets.data.Item;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetViewer;
import org.eclipse.ui.internal.cheatsheets.views.CoreItem;
import org.eclipse.ui.internal.cheatsheets.views.IntroItem;
import org.eclipse.ui.internal.cheatsheets.views.Page;
import org.eclipse.ui.internal.cheatsheets.views.ViewItem;

public class CheatSheetPage
extends Page {
    protected final RGB activeRGB = new RGB(232, 242, 254);
    protected Color activeColor;
    protected final RGB alternateRGB = new RGB(244, 244, 244);
    protected Color alternateColor;
    private CheatSheet cheatSheet;
    private ArrayList viewItemList;
    private CheatSheetViewer viewer;

    public CheatSheetPage(CheatSheet cheatSheet, ArrayList viewItemList, CheatSheetViewer cheatSheetViewer) {
        this.cheatSheet = cheatSheet;
        this.viewItemList = viewItemList;
        this.viewer = cheatSheetViewer;
    }

    public void createPart(Composite parent) {
        super.createPart(parent);
    }

    protected void createInfoArea(Composite parent) {
        CheatSheetStopWatch.startStopWatch("CheatSheetPage.createInfoArea()");
        super.createInfoArea(parent);
        CheatSheetStopWatch.printLapTime("CheatSheetPage.createInfoArea()", "Time in CheatSheetPage.createInfoArea() after super.createInfoArea(): ");
        IntroItem intro = new IntroItem(this.toolkit, this.form, this.cheatSheet.getIntroItem(), this.activeColor, this.viewer);
        CheatSheetStopWatch.printLapTime("CheatSheetPage.createInfoArea()", "Time in CheatSheetPage.createInfoArea() after new IntroItem(): ");
        intro.setItemColor(intro.alternateColor);
        intro.setBold(true);
        this.viewItemList.add(intro);
        CheatSheetStopWatch.printLapTime("CheatSheetPage.createInfoArea()", "Time in CheatSheetPage.createInfoArea() before add loop: ");
        ArrayList items = this.cheatSheet.getItems();
        for (int i = 0; i < items.size(); ++i) {
            Color color = i % 2 == 0 ? this.backgroundColor : this.alternateColor;
            CoreItem coreItem = new CoreItem(this.toolkit, this.form, (Item)items.get(i), color, this.viewer);
            this.viewItemList.add(coreItem);
        }
        CheatSheetStopWatch.printLapTime("CheatSheetPage.createInfoArea()", "Time in CheatSheetPage.createInfoArea(): ");
    }

    protected String getTitle() {
        if (this.cheatSheet != null & this.cheatSheet.getTitle() != null) {
            return this.cheatSheet.getTitle();
        }
        return "";
    }

    public void dispose() {
        super.dispose();
        if (this.alternateColor != null) {
            this.alternateColor.dispose();
        }
        if (this.activeColor != null) {
            this.activeColor.dispose();
        }
    }

    protected void init(Display display) {
        super.init(display);
        this.activeColor = new Color((Device)display, this.activeRGB);
        this.alternateColor = new Color((Device)display, this.alternateRGB);
    }

    public void initialized() {
        Iterator iter = this.viewItemList.iterator();
        while (iter.hasNext()) {
            ViewItem item = (ViewItem)iter.next();
            item.initialized();
        }
    }
}

