/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.ISite;
import org.eclipse.update.internal.core.InternalSiteManager;
import org.eclipse.update.internal.core.UpdateCore;

public class SiteManager {
    private static String os;
    private static String ws;
    private static String arch;
    private static String nl;
    private static boolean isHttpProxyEnable;
    private static final String P_HTTP_HOST = "http.proxyHost";
    private static final String P_HTTP_PORT = "http.proxyPort";
    private static final String P_HTTP_PROXY = "http.proxySet";

    private SiteManager() {
    }

    public static ISite getSite(URL siteURL) throws CoreException {
        return InternalSiteManager.getSite(siteURL, true, null);
    }

    public static ISite getSite(URL siteURL, IProgressMonitor monitor) throws CoreException {
        return InternalSiteManager.getSite(siteURL, true, monitor);
    }

    public static ISite getSite(URL siteURL, boolean usesCache) throws CoreException {
        return InternalSiteManager.getSite(siteURL, usesCache, null);
    }

    public static ISite getSite(URL siteURL, boolean usesCache, IProgressMonitor monitor) throws CoreException {
        return InternalSiteManager.getSite(siteURL, usesCache, monitor);
    }

    public static ILocalSite getLocalSite() throws CoreException {
        return InternalSiteManager.getLocalSite();
    }

    public static void handleNewChanges() throws CoreException {
    }

    public static String getOSArch() {
        if (arch == null) {
            arch = Platform.getOSArch();
        }
        return arch;
    }

    public static String getOS() {
        if (os == null) {
            os = Platform.getOS();
        }
        return os;
    }

    public static String getWS() {
        if (ws == null) {
            ws = Platform.getWS();
        }
        return ws;
    }

    public static void setOSArch(String arch) {
        SiteManager.arch = arch;
    }

    public static void setOS(String os) {
        SiteManager.os = os;
    }

    public static void setWS(String ws) {
        SiteManager.ws = ws;
    }

    public static void setNL(String nl) {
        SiteManager.nl = nl;
    }

    public static long getEstimatedTransferRate(URL site) {
        if (site == null) {
            return 0L;
        }
        return InternalSiteManager.getEstimatedTransferRate(site.getHost());
    }

    public static String getNL() {
        if (nl == null) {
            nl = Platform.getNL();
        }
        return nl;
    }

    public static String getHttpProxyServer() {
        return System.getProperty(P_HTTP_HOST);
    }

    public static String getHttpProxyPort() {
        return System.getProperty(P_HTTP_PORT);
    }

    public static boolean isHttpProxyEnable() {
        return isHttpProxyEnable;
    }

    public static void setHttpProxyInfo(boolean enable, String httpProxyServer, String httpProxyPort) {
        isHttpProxyEnable = enable;
        if (!enable || httpProxyServer == null || httpProxyPort == null) {
            System.getProperties().remove(P_HTTP_HOST);
            System.getProperties().remove(P_HTTP_PORT);
            System.getProperties().remove(P_HTTP_PROXY);
            UpdateCore.warn("Remove proxy server info");
            UpdateCore.getPlugin().getPluginPreferences().setValue(UpdateCore.HTTP_PROXY_ENABLE, SiteManager.isHttpProxyEnable());
            UpdateCore.getPlugin().savePluginPreferences();
            return;
        }
        System.getProperties().setProperty(P_HTTP_PROXY, enable ? "true" : "false");
        System.getProperties().setProperty(P_HTTP_HOST, httpProxyServer);
        System.getProperties().setProperty(P_HTTP_PORT, httpProxyPort);
        UpdateCore.warn("Added proxy server info:" + httpProxyServer + ":" + httpProxyPort);
        UpdateCore.getPlugin().getPluginPreferences().setValue(UpdateCore.HTTP_PROXY_HOST, SiteManager.getHttpProxyServer());
        UpdateCore.getPlugin().getPluginPreferences().setValue(UpdateCore.HTTP_PROXY_PORT, SiteManager.getHttpProxyPort());
        UpdateCore.getPlugin().getPluginPreferences().setValue(UpdateCore.HTTP_PROXY_ENABLE, SiteManager.isHttpProxyEnable());
        UpdateCore.getPlugin().savePluginPreferences();
    }
}

