/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.SiteEntry;
import org.eclipse.update.internal.core.Assert;
import org.eclipse.update.internal.core.BaseSiteLocalFactory;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfiguredSiteModel;
import org.eclipse.update.internal.model.InstallConfigurationModel;

public class InstallConfigurationParser {
    private PlatformConfiguration platformConfig;
    private URL siteURL;
    private InstallConfigurationModel config;
    private ConfiguredSiteModel configSite;

    public InstallConfigurationParser(IPlatformConfiguration platformConfig, InstallConfigurationModel config) throws IOException, CoreException {
        Assert.isTrue(platformConfig instanceof PlatformConfiguration);
        this.platformConfig = (PlatformConfiguration)platformConfig;
        this.config = config;
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.debug("Start parsing Configuration:" + config.getURL().toExternalForm());
        }
        this.processConfig(this.platformConfig);
    }

    private void processSite(SiteEntry siteEntry) throws CoreException, IOException {
        this.siteURL = siteEntry.getURL();
        try {
            this.siteURL = Platform.asLocalURL((URL)this.siteURL);
            if (this.siteURL.getProtocol().equals("file")) {
                this.siteURL = new File(this.siteURL.getFile()).toURL();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        ISite site = SiteManager.getSite(this.siteURL, null);
        BaseSiteLocalFactory factory = new BaseSiteLocalFactory();
        this.configSite = factory.createConfigurationSiteModel((SiteModel)((Object)site), siteEntry.getSitePolicy().getType());
        this.configSite.setPlatformURLString(siteEntry.getURL().toExternalForm());
        this.configSite.setEnabled(siteEntry.isEnabled());
        this.configSite.setUpdatable(siteEntry.isUpdateable());
        this.config.addConfigurationSiteModel(this.configSite);
        this.configSite.setInstallConfigurationModel(this.config);
        FeatureEntry[] features = siteEntry.getFeatureEntries();
        for (int i = 0; i < features.length; ++i) {
            this.processFeature(features[i]);
        }
    }

    private void processFeature(FeatureEntry feature) throws CoreException, IOException {
        String path = feature.getURL();
        URL url = UpdateManagerUtils.getURL(this.siteURL, path, null);
        if (url != null) {
            SiteFeatureReference ref = new SiteFeatureReference();
            ref.setSite((ISite)((Object)this.configSite.getSiteModel()));
            ref.setURL(url);
            this.configSite.getConfigurationPolicyModel().addConfiguredFeatureReference(ref);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
                UpdateCore.debug("End Processing DefaultFeature Tag: url:" + url.toExternalForm());
            }
        } else {
            UpdateCore.log(Policy.bind("InstallConfigurationParser.FeatureReferenceNoURL"), new Exception());
        }
    }

    private void processConfig(PlatformConfiguration platformConfig) throws IOException, CoreException {
        Date date = new Date(platformConfig.getChangeStamp());
        this.config.setCreationDate(date);
        this.config.setLabel(date.toString());
        SiteEntry[] sites = platformConfig.getConfiguration().getSites();
        for (int i = 0; i < sites.length; ++i) {
            this.processSite(sites[i]);
        }
    }
}

