/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.NavigationAction;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.compare.internal.IgnoreWhiteSpaceAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.EditorActionBarContributor;

public class CompareEditorContributor
extends EditorActionBarContributor {
    private IEditorPart fActiveEditorPart = null;
    private IgnoreWhiteSpaceAction fIgnoreWhitespace;
    private NavigationAction fNext;
    private NavigationAction fPrevious;
    private NavigationAction fToolbarNext;
    private NavigationAction fToolbarPrevious;

    public CompareEditorContributor() {
        ResourceBundle bundle = CompareUI.getResourceBundle();
        this.fIgnoreWhitespace = new IgnoreWhiteSpaceAction(bundle, null);
        WorkbenchHelp.setHelp((IAction)this.fIgnoreWhitespace, (String)"org.eclipse.compare.ignore_whitespace_action_context");
        this.fNext = new NavigationAction(bundle, true);
        WorkbenchHelp.setHelp((IAction)this.fNext, (String)"org.eclipse.compare.global_next_diff_action_context");
        this.fPrevious = new NavigationAction(bundle, false);
        WorkbenchHelp.setHelp((IAction)this.fPrevious, (String)"org.eclipse.compare.global_previous_diff_action_context");
        this.fToolbarNext = new NavigationAction(bundle, true);
        WorkbenchHelp.setHelp((IAction)this.fToolbarNext, (String)"org.eclipse.compare.next_diff_action_context");
        this.fToolbarPrevious = new NavigationAction(bundle, false);
        WorkbenchHelp.setHelp((IAction)this.fToolbarPrevious, (String)"org.eclipse.compare.previous_diff_action_context");
    }

    public void contributeToToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.fIgnoreWhitespace);
        tbm.add((IAction)this.fToolbarNext);
        tbm.add((IAction)this.fToolbarPrevious);
    }

    public void contributeToMenu(IMenuManager menuManager) {
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        IEditorInput input;
        if (this.fActiveEditorPart == targetEditor) {
            return;
        }
        this.fActiveEditorPart = targetEditor;
        if (this.fActiveEditorPart != null && (input = this.fActiveEditorPart.getEditorInput()) instanceof CompareEditorInput) {
            CompareEditorInput compareInput = (CompareEditorInput)input;
            this.fNext.setCompareEditorInput(compareInput);
            this.fPrevious.setCompareEditorInput(compareInput);
            this.fToolbarNext.setCompareEditorInput(compareInput);
            this.fToolbarPrevious.setCompareEditorInput(compareInput);
        }
        if (targetEditor instanceof CompareEditor) {
            IActionBars actionBars = this.getActionBars();
            CompareEditor editor = (CompareEditor)targetEditor;
            editor.setActionBars(actionBars);
            actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.fNext);
            actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.fPrevious);
            CompareConfiguration cc = editor.getCompareConfiguration();
            this.fIgnoreWhitespace.setCompareConfiguration(cc);
        }
    }
}

