/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class PluginVersionReplaceTask
extends Task {
    private static final String PLUGIN = "plugin";
    private static final String FRAGMENT = "fragment";
    private static final String VERSION = "version";
    private static final String BACKSLASH = "\"";
    private String pluginFilePath;
    private boolean plugin = true;
    private String newVersion;

    public void setPluginFilePath(String path) {
        this.pluginFilePath = path;
    }

    public void setVersionNumber(String qualifier) {
        this.newVersion = qualifier;
    }

    public void setInput(String input) {
        if (input.equalsIgnoreCase("fragment.xml")) {
            this.plugin = false;
        }
    }

    public void execute() {
        StringBuffer buffer = null;
        try {
            buffer = this.readFile(new File(this.pluginFilePath));
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        int startPlugin = this.plugin ? this.scan(buffer, 0, PLUGIN) : this.scan(buffer, 0, FRAGMENT);
        if (startPlugin == -1) {
            return;
        }
        int endPlugin = this.scan(buffer, startPlugin + 1, ">");
        int versionAttr = this.scan(buffer, startPlugin, VERSION);
        if (versionAttr == -1 || versionAttr > endPlugin) {
            return;
        }
        int startVersionId = this.scan(buffer, versionAttr + 1, BACKSLASH);
        int endVersionId = this.scan(buffer, startVersionId + 1, BACKSLASH);
        buffer.replace(++startVersionId, endVersionId, this.newVersion);
        try {
            PluginVersionReplaceTask.transferStreams(new ByteArrayInputStream(buffer.toString().getBytes()), new FileOutputStream(this.pluginFilePath));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private int scan(StringBuffer buf, int start, String targetName) {
        return this.scan(buf, start, new String[]{targetName});
    }

    private int scan(StringBuffer buf, int start, String[] targets) {
        for (int i = start; i < buf.length(); ++i) {
            for (int j = 0; j < targets.length; ++j) {
                String match;
                if (i >= buf.length() - targets[j].length() || !targets[j].equals(match = buf.substring(i, i + targets[j].length()))) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer readFile(File targetName) throws IOException {
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(new FileInputStream(targetName)));
        StringBuffer result = new StringBuffer();
        char[] buf = new char[4096];
        try {
            int count = reader.read(buf, 0, buf.length);
            while (count != -1) {
                result.append(buf, 0, count);
                count = reader.read(buf, 0, buf.length);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transferStreams(InputStream source, OutputStream destination) throws IOException {
        source = new BufferedInputStream(source);
        destination = new BufferedOutputStream(destination);
        try {
            byte[] buffer = new byte[8192];
            while (true) {
                int bytesRead = -1;
                bytesRead = source.read(buffer);
                if (bytesRead == -1) {
                    break;
                }
                destination.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                source.close();
            }
            catch (IOException e) {}
            try {
                destination.close();
            }
            catch (IOException iOException) {}
        }
    }
}

