/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tomcat.internal;

import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.help.internal.appserver.PluginClassLoaderWrapper;

public class WebAppClassLoader
extends URLClassLoader {
    private ClassLoader pluginLoader;
    private PluginClassLoaderWrapper tomcatPluginLoader;

    public WebAppClassLoader(ClassLoader pluginLoader) {
        super(new URL[0]);
        this.pluginLoader = pluginLoader;
        this.tomcatPluginLoader = new PluginClassLoaderWrapper("org.eclipse.tomcat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String className) throws ClassNotFoundException {
        Class<?> c = null;
        try {
            c = this.tomcatPluginLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            c = this.pluginLoader.loadClass(className);
        }
        return c;
    }

    public URL getResource(String resName) {
        URL u = this.pluginLoader.getResource(resName);
        if (u == null) {
            return this.tomcatPluginLoader.getResource(resName);
        }
        return u;
    }

    public URL[] getURLs() {
        URL[] pluginLoaderURLs = this.pluginLoader instanceof URLClassLoader ? ((URLClassLoader)this.pluginLoader).getURLs() : new URL[]{};
        URL[] tomcatPluginLoaderURLs = this.tomcatPluginLoader.getURLs();
        URL[] urls = new URL[pluginLoaderURLs.length + tomcatPluginLoaderURLs.length];
        System.arraycopy(pluginLoaderURLs, 0, urls, 0, pluginLoaderURLs.length);
        System.arraycopy(tomcatPluginLoaderURLs, 0, urls, pluginLoaderURLs.length, tomcatPluginLoaderURLs.length);
        return urls;
    }
}

