/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;

public class TextChanges {
    private TextChanges() {
    }

    public static IDocument getDocument(IFile file) throws CoreException {
        IPath path;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer buffer = manager.getTextFileBuffer(path = file.getFullPath());
        if (buffer == null) {
            return null;
        }
        return buffer.getDocument();
    }

    public static RefactoringStatus isValid(IFile file, boolean existed, long lastModificationStamp, boolean fSave) throws CoreException {
        if (!existed) {
            if (file.exists()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getFormattedString("TextChanges.error.existing", file.getFullPath().toString()));
            }
        } else {
            ITextFileBufferManager manager;
            ITextFileBuffer buffer;
            if (!file.exists()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getFormattedString("TextChanges.error.not_existing", file.getFullPath().toString()));
            }
            if (lastModificationStamp != file.getModificationStamp()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getFormattedString("TextChanges.error.content_changed", file.getFullPath().toString()));
            }
            if (file.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getFormattedString("TextChanges.error.read_only", file.getFullPath().toString()));
            }
            if (!file.isSynchronized(0)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getFormattedString("TextChanges.error.outOfSync", file.getFullPath().toString()));
            }
            if (fSave && (buffer = (manager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(file.getFullPath())) != null && buffer.isDirty()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getFormattedString("TextChanges.error.unsaved_changes", file.getFullPath().toString()));
            }
        }
        return new RefactoringStatus();
    }

    public static RefactoringStatus isValid(IDocument document, int length) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        if (length != document.getLength()) {
            result.addFatalError(RefactoringCoreMessages.getString("TextChanges.error.document_content_changed"));
        }
        return result;
    }
}

