/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.localstore.CollectSyncStatusVisitor;
import org.eclipse.core.internal.localstore.CopyVisitor;
import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.internal.localstore.DeleteVisitor;
import org.eclipse.core.internal.localstore.FileSystemStore;
import org.eclipse.core.internal.localstore.HistoryStore;
import org.eclipse.core.internal.localstore.IsSynchronizedVisitor;
import org.eclipse.core.internal.localstore.RefreshLocalAliasVisitor;
import org.eclipse.core.internal.localstore.RefreshLocalVisitor;
import org.eclipse.core.internal.localstore.UnifiedTree;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.ModelObjectWriter;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class FileSystemResourceManager
implements ICoreConstants,
IManager {
    protected Workspace workspace;
    protected HistoryStore historyStore;
    protected FileSystemStore localStore;

    public FileSystemResourceManager(Workspace workspace) {
        this.workspace = workspace;
        this.localStore = new FileSystemStore();
    }

    protected ArrayList allPathsForLocation(IPath location) {
        IProject[] projects = this.getWorkspace().getRoot().getProjects();
        ArrayList<IPath> results = new ArrayList<IPath>();
        for (int i = 0; i < projects.length; ++i) {
            IPath suffix;
            IProject project = projects[i];
            IPath testLocation = project.getLocation();
            if (testLocation != null && testLocation.isPrefixOf(location)) {
                suffix = location.removeFirstSegments(testLocation.segmentCount());
                results.add(project.getFullPath().append(suffix));
            }
            if (!project.isAccessible()) continue;
            IResource[] children = null;
            try {
                children = project.members();
            }
            catch (CoreException e) {
                // empty catch block
            }
            if (children == null) continue;
            for (int j = 0; j < children.length; ++j) {
                IResource child = children[j];
                if (!child.isLinked() || (testLocation = child.getLocation()) == null || !testLocation.isPrefixOf(location)) continue;
                suffix = location.removeFirstSegments(testLocation.segmentCount());
                results.add(child.getFullPath().append(suffix));
            }
        }
        return results;
    }

    public IResource[] allResourcesFor(IPath location, boolean files) {
        IResource resource;
        ArrayList result = this.allPathsForLocation(location);
        int count = 0;
        int imax = result.size();
        for (int i = 0; i < imax; ++i) {
            resource = this.resourceFor((IPath)result.get(i), files);
            result.set(i, resource);
            if (resource == null) continue;
            ++count;
        }
        IResource[] toReturn = files ? (IResource[])new IFile[count] : (IResource[])new IContainer[count];
        count = 0;
        Iterator it = result.iterator();
        while (it.hasNext()) {
            resource = (IResource)it.next();
            if (resource == null) continue;
            toReturn[count++] = resource;
        }
        return toReturn;
    }

    public IContainer containerForLocation(IPath location) {
        IPath path = this.pathForLocation(location);
        return path == null ? null : (IContainer)this.resourceFor(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(IResource target, IResource destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            int totalWork = ((Resource)target).countResources(2, false);
            String title = Policy.bind("localstore.copying", target.getFullPath().toString());
            monitor.beginTask(title, totalWork);
            IPath location = this.locationFor(destination);
            if (location == null) {
                String message = Policy.bind("localstore.locationUndefined", target.getFullPath().toString());
                throw new ResourceException(271, target.getFullPath(), message, null);
            }
            if (location.toFile().exists()) {
                String message = Policy.bind("localstore.resourceExists", destination.getFullPath().toString());
                throw new ResourceException(272, destination.getFullPath(), message, null);
            }
            CopyVisitor visitor = new CopyVisitor(target, destination, updateFlags, monitor);
            UnifiedTree tree = new UnifiedTree(target);
            tree.accept(visitor, 2);
            IStatus status = visitor.getStatus();
            if (!status.isOK()) {
                throw new ResourceException(status);
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(IResource target, boolean force, boolean convertToPhantom, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            Resource resource = (Resource)target;
            int totalWork = resource.countResources(2, false);
            String title = Policy.bind("localstore.deleting", resource.getFullPath().toString());
            monitor.beginTask(title, totalWork *= 2);
            MultiStatus status = new MultiStatus("org.eclipse.core.resources", 273, Policy.bind("localstore.deleteProblem"), null);
            List skipList = null;
            UnifiedTree tree = new UnifiedTree(target);
            if (!force) {
                IProgressMonitor sub = Policy.subMonitorFor(monitor, totalWork / 2);
                sub.beginTask("", 10000);
                CollectSyncStatusVisitor refreshVisitor = new CollectSyncStatusVisitor(Policy.bind("localstore.deleteProblem"), sub);
                tree.accept(refreshVisitor, 2);
                status.merge((IStatus)refreshVisitor.getSyncStatus());
                skipList = refreshVisitor.getAffectedResources();
            }
            DeleteVisitor deleteVisitor = new DeleteVisitor(skipList, force, convertToPhantom, keepHistory, Policy.subMonitorFor(monitor, force ? totalWork : totalWork / 2));
            tree.accept(deleteVisitor, 2);
            status.merge((IStatus)deleteVisitor.getStatus());
            if (!status.isOK()) {
                throw new ResourceException((IStatus)status);
            }
        }
        finally {
            monitor.done();
        }
    }

    public IFile fileForLocation(IPath location) {
        IPath path = this.pathForLocation(location);
        return path == null ? null : (IFile)this.resourceFor(path, true);
    }

    public IPath getDescriptionLocationFor(IProject target) {
        IPath projectLocation = this.locationFor(target);
        return projectLocation == null ? null : projectLocation.append(".project");
    }

    public int getEncoding(File target) throws CoreException {
        IPath location = this.locationFor(target);
        if (location == null) {
            ((Project)target.getProject()).checkExists(-1, true);
        }
        if (location == null) {
            String message = Policy.bind("localstore.locationUndefined", target.getFullPath().toString());
            throw new ResourceException(271, target.getFullPath(), message, null);
        }
        java.io.File localFile = location.toFile();
        if (!localFile.exists()) {
            String message = Policy.bind("localstore.fileNotFound", localFile.getAbsolutePath());
            throw new ResourceException(271, target.getFullPath(), message, null);
        }
        return this.getStore().getEncoding(localFile);
    }

    public HistoryStore getHistoryStore() {
        return this.historyStore;
    }

    protected IPath getProjectDefaultLocation(IProject project) {
        return Platform.getLocation().append(project.getFullPath());
    }

    public FileSystemStore getStore() {
        return this.localStore;
    }

    protected Workspace getWorkspace() {
        return this.workspace;
    }

    public boolean hasSavedProject(IProject project) {
        IPath location = this.getDescriptionLocationFor(project);
        return location == null ? false : location.toFile().exists();
    }

    public boolean internalWrite(IProject target, IProjectDescription description, int updateFlags, boolean hasPublicChanges, boolean hasPrivateChanges) throws CoreException {
        IStatus result;
        IPath location = this.locationFor(target);
        if (location == null) {
            String message = Policy.bind("localstore.locationUndefined", target.getFullPath().toString());
            throw new ResourceException(272, target.getFullPath(), message, null);
        }
        this.getStore().writeFolder(location.toFile());
        if (hasPrivateChanges) {
            this.getWorkspace().getMetaArea().writePrivateDescription(target);
        }
        if (!hasPublicChanges) {
            return false;
        }
        if (description == null) {
            return false;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            new ModelObjectWriter().write((Object)description, out);
        }
        catch (IOException e) {
            String msg = Policy.bind("resources.writeMeta", target.getFullPath().toString());
            throw new ResourceException(568, target.getFullPath(), msg, e);
        }
        byte[] newContents = out.toByteArray();
        IFile descriptionFile = target.getFile(".project");
        if (!descriptionFile.exists()) {
            this.workspace.createResource(descriptionFile, false);
        } else if (!this.descriptionChanged(descriptionFile, newContents)) {
            return false;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(newContents);
        if (descriptionFile.isReadOnly() && !(result = this.getWorkspace().validateEdit(new IFile[]{descriptionFile}, null)).isOK()) {
            throw new ResourceException(result);
        }
        descriptionFile.setContents(in, updateFlags, null);
        long lastModified = ((Resource)((Object)descriptionFile)).getResourceInfo(false, false).getLocalSyncInfo();
        ResourceInfo info = ((Resource)((Object)target)).getResourceInfo(false, true);
        this.updateLocalSync(info, lastModified);
        this.getWorkspace().getMetaArea().clearOldDescription(target);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean descriptionChanged(IFile descriptionFile, byte[] newContents) {
        byte[] oldContents;
        BufferedInputStream stream;
        block19: {
            block17: {
                stream = null;
                stream = new BufferedInputStream(descriptionFile.getContents());
                int newLength = newContents.length;
                oldContents = new byte[newLength];
                int read = ((InputStream)stream).read(oldContents);
                if (read == newLength) break block17;
                boolean bl = true;
                Object var9_11 = null;
                try {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
                catch (IOException e1) {
                    // empty catch block
                }
                return bl;
            }
            if (((InputStream)stream).read() < 0) break block19;
            boolean bl = true;
            Object var9_12 = null;
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            return bl;
        }
        boolean bl = !Arrays.equals(newContents, oldContents);
        Object var9_13 = null;
        try {
            if (stream != null) {
                ((InputStream)stream).close();
            }
        }
        catch (IOException e1) {
            // empty catch block
        }
        return bl;
        catch (Exception e) {
            try {
                Object var9_14 = null;
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                try {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
                catch (IOException e1) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException e1) {}
        }
        return true;
    }

    public boolean isDescriptionSynchronized(IProject target) {
        IFile descriptionFile = target.getFile(".project");
        ResourceInfo projectInfo = ((Resource)((Object)target)).getResourceInfo(false, false);
        if (projectInfo == null) {
            return false;
        }
        return projectInfo.getLocalSyncInfo() == CoreFileSystemLibrary.getLastModified(descriptionFile.getLocation().toOSString());
    }

    public boolean isSynchronized(IResource target, int depth) {
        switch (target.getType()) {
            case 8: {
                if (depth == 0) {
                    return true;
                }
                depth = depth == 1 ? 0 : depth;
                IProject[] projects = ((IWorkspaceRoot)target).getProjects();
                for (int i = 0; i < projects.length; ++i) {
                    if (this.isSynchronized(projects[i], depth)) continue;
                    return false;
                }
                return true;
            }
            case 4: {
                if (target.isAccessible()) break;
                return true;
            }
            case 1: {
                if (!this.fastIsSynchronized((File)target)) break;
                return true;
            }
        }
        IsSynchronizedVisitor visitor = new IsSynchronizedVisitor(Policy.monitorFor(null));
        UnifiedTree tree = new UnifiedTree(target);
        try {
            tree.accept(visitor, depth);
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
            return false;
        }
        catch (IsSynchronizedVisitor.ResourceChangedException e) {
            return false;
        }
        return true;
    }

    public void link(Resource target, IPath localLocation) {
        long lastModified = 0L;
        if (localLocation.isAbsolute()) {
            lastModified = CoreFileSystemLibrary.getLastModified(localLocation.toFile().getAbsolutePath());
        }
        ResourceInfo info = target.getResourceInfo(false, true);
        this.updateLocalSync(info, lastModified);
    }

    public IPath locationFor(IResource target) {
        IPath location;
        switch (target.getType()) {
            case 8: {
                return Platform.getLocation();
            }
            case 4: {
                Project project = (Project)target;
                ProjectDescription description = project.internalGetDescription();
                if (description != null && description.getLocation() != null) {
                    IPath resolved = this.workspace.getPathVariableManager().resolvePath(description.getLocation());
                    return resolved != null && resolved.isAbsolute() ? resolved : null;
                }
                return this.getProjectDefaultLocation(project);
            }
        }
        IPath targetPath = target.getFullPath();
        int numSegments = targetPath.segmentCount();
        IResource linked = target;
        if (numSegments > 2) {
            linked = this.workspace.getRoot().getFolder(targetPath.removeLastSegments(numSegments - 2));
        }
        ProjectDescription description = ((Project)target.getProject()).internalGetDescription();
        if (linked.isLinked() && (location = description.getLinkLocation(linked.getName())) != null) {
            location = this.workspace.getPathVariableManager().resolvePath(location);
            if (!location.isAbsolute()) {
                return null;
            }
            return location.append(targetPath.removeFirstSegments(2));
        }
        if (description != null && description.getLocation() != null) {
            IPath resolved = this.workspace.getPathVariableManager().resolvePath(description.getLocation());
            if (!resolved.isAbsolute()) {
                return null;
            }
            return resolved.append(target.getProjectRelativePath());
        }
        return Platform.getLocation().append(target.getFullPath());
    }

    protected IPath pathForLocation(IPath location) {
        if (Platform.getLocation().equals(location)) {
            return Path.ROOT;
        }
        IProject[] projects = this.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < projects.length; ++i) {
            IProject project = projects[i];
            IPath projectLocation = project.getLocation();
            if (projectLocation == null || !projectLocation.isPrefixOf(location)) continue;
            int segmentsToRemove = projectLocation.segmentCount();
            return project.getFullPath().append(location.removeFirstSegments(segmentsToRemove));
        }
        return null;
    }

    public boolean fastIsSynchronized(File target) {
        long stat;
        IPath location;
        ResourceInfo info = target.getResourceInfo(false, false);
        return target.exists(target.getFlags(info), true) && (location = target.getLocation()) != null && CoreFileSystemLibrary.isFile(stat = CoreFileSystemLibrary.getStat(location.toString())) && info.getLocalSyncInfo() == CoreFileSystemLibrary.getLastModified(stat);
    }

    public InputStream read(IFile target, boolean force, IProgressMonitor monitor) throws CoreException {
        IPath location = this.locationFor(target);
        if (location == null) {
            ((Project)target.getProject()).checkExists(-1, true);
        }
        if (location == null) {
            String message = Policy.bind("localstore.locationUndefined", target.getFullPath().toString());
            throw new ResourceException(271, target.getFullPath(), message, null);
        }
        java.io.File localFile = location.toFile();
        if (!localFile.exists()) {
            String message = Policy.bind("localstore.fileNotFound", localFile.getAbsolutePath());
            throw new ResourceException(271, target.getFullPath(), message, null);
        }
        if (!force) {
            ResourceInfo info = ((Resource)((Object)target)).getResourceInfo(true, false);
            int flags = ((Resource)((Object)target)).getFlags(info);
            ((Resource)((Object)target)).checkExists(flags, true);
            if (CoreFileSystemLibrary.getLastModified(localFile.getAbsolutePath()) != info.getLocalSyncInfo()) {
                String message = Policy.bind("localstore.resourceIsOutOfSync", target.getFullPath().toString());
                throw new ResourceException(274, target.getFullPath(), message, null);
            }
        }
        return this.getStore().read(localFile);
    }

    public ProjectDescription read(IProject target, boolean creation) throws CoreException {
        boolean isDefaultLocation;
        IPath projectLocation = null;
        ProjectDescription privateDescription = null;
        if (creation) {
            privateDescription = new ProjectDescription();
            this.getWorkspace().getMetaArea().readPrivateDescription(target, privateDescription);
            projectLocation = privateDescription.getLocation();
        } else {
            ProjectDescription description = ((Project)target).internalGetDescription();
            if (description != null && description.getLocation() != null) {
                projectLocation = description.getLocation();
            }
        }
        boolean bl = isDefaultLocation = projectLocation == null;
        if (isDefaultLocation) {
            projectLocation = this.getProjectDefaultLocation(target);
        }
        IPath descriptionPath = this.workspace.getPathVariableManager().resolvePath(projectLocation).append(".project");
        ProjectDescription description = null;
        if (!descriptionPath.toFile().exists()) {
            description = this.getWorkspace().getMetaArea().readOldDescription(target);
            if (description == null) {
                String msg = Policy.bind("resources.missingProjectMeta", target.getName());
                throw new ResourceException(567, target.getFullPath(), msg, null);
            }
            return description;
        }
        ResourceException error = null;
        try {
            description = new ProjectDescriptionReader().read(descriptionPath);
        }
        catch (IOException e) {
            String msg = Policy.bind("resources.readProjectMeta", target.getName());
            error = new ResourceException(567, target.getFullPath(), msg, e);
        }
        if (error == null && description == null) {
            String msg = Policy.bind("resources.readProjectMeta", target.getName());
            error = new ResourceException(567, target.getFullPath(), msg, null);
        }
        if (description != null) {
            description.setName(target.getName());
            if (!isDefaultLocation) {
                description.setLocation(projectLocation);
            }
            if (creation && privateDescription != null) {
                description.setDynamicReferences(privateDescription.getDynamicReferences(false));
            }
        }
        long lastModified = CoreFileSystemLibrary.getLastModified(descriptionPath.toOSString());
        IFile descriptionFile = target.getFile(".project");
        ResourceInfo info = ((Resource)((Object)descriptionFile)).getResourceInfo(false, false);
        if (info == null) {
            info = this.getWorkspace().createResource(descriptionFile, false);
            this.updateLocalSync(info, lastModified);
        }
        if (!creation) {
            this.updateLocalSync(info, lastModified);
        }
        info = ((Resource)((Object)target)).getResourceInfo(false, true);
        this.updateLocalSync(info, lastModified);
        if (error != null) {
            throw error;
        }
        return description;
    }

    public boolean refresh(IResource target, int depth, boolean updateAliases, IProgressMonitor monitor) throws CoreException {
        switch (target.getType()) {
            case 8: {
                return this.refreshRoot((IWorkspaceRoot)target, depth, updateAliases, monitor);
            }
            case 4: {
                if (!target.isAccessible()) {
                    return false;
                }
            }
            case 1: 
            case 2: {
                return this.refreshResource(target, depth, updateAliases, monitor);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean refreshResource(IResource target, int depth, boolean updateAliases, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        int totalWork = 250;
        String title = Policy.bind("localstore.refreshing", target.getFullPath().toString());
        try {
            monitor.beginTask(title, totalWork);
            RefreshLocalVisitor visitor = updateAliases ? new RefreshLocalAliasVisitor(monitor) : new RefreshLocalVisitor(monitor);
            UnifiedTree tree = new UnifiedTree(target);
            tree.accept(visitor, depth);
            IStatus result = visitor.getErrorStatus();
            if (!result.isOK()) {
                throw new ResourceException(result);
            }
            boolean bl = visitor.resourcesChanged();
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean refreshRoot(IWorkspaceRoot target, int depth, boolean updateAliases, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        IProject[] projects = target.getProjects();
        int totalWork = projects.length;
        String title = Policy.bind("localstore.refreshingRoot");
        try {
            monitor.beginTask(title, totalWork);
            if (depth == 0) {
                boolean bl = false;
                return bl;
            }
            boolean changed = false;
            depth = depth == 1 ? 0 : depth;
            for (int i = 0; i < projects.length; ++i) {
                changed |= this.refresh(projects[i], depth, updateAliases, Policy.subMonitorFor(monitor, 1));
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    protected IResource resourceFor(IPath path, boolean files) {
        int numSegments = path.segmentCount();
        if (files && numSegments < 2) {
            return null;
        }
        IWorkspaceRoot root = this.getWorkspace().getRoot();
        if (path.isRoot()) {
            return root;
        }
        if (numSegments == 1) {
            return root.getProject(path.segment(0));
        }
        return files ? root.getFile(path) : root.getFolder(path);
    }

    public long setLocalTimeStamp(IResource target, ResourceInfo info, long value) throws CoreException {
        IPath location = target.getLocation();
        if (location == null) {
            String message = Policy.bind("localstore.locationUndefined", target.getFullPath().toString());
            throw new ResourceException(272, target.getFullPath(), message, null);
        }
        java.io.File localFile = location.toFile();
        localFile.setLastModified(value);
        long actualValue = CoreFileSystemLibrary.getLastModified(localFile.getAbsolutePath());
        this.updateLocalSync(info, actualValue);
        return actualValue;
    }

    public void shutdown(IProgressMonitor monitor) throws CoreException {
        this.historyStore.shutdown(monitor);
    }

    public void startup(IProgressMonitor monitor) throws CoreException {
        IPath location = this.getWorkspace().getMetaArea().getHistoryStoreLocation();
        location.toFile().mkdirs();
        this.historyStore = new HistoryStore(this.getWorkspace(), location, 256);
        this.historyStore.startup(monitor);
    }

    public void updateLocalSync(ResourceInfo info, long localSyncInfo) {
        info.setLocalSyncInfo(localSyncInfo);
        if (localSyncInfo == -1L) {
            info.clear(2);
        } else {
            info.set(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(IFile target, IPath location, InputStream content, boolean force, boolean keepHistory, boolean append, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(null);
        try {
            if (location == null) {
                String message = Policy.bind("localstore.locationUndefined", target.getFullPath().toString());
                throw new ResourceException(272, target.getFullPath(), message, null);
            }
            String locationString = location.toOSString();
            long stat = CoreFileSystemLibrary.getStat(locationString);
            if (CoreFileSystemLibrary.isReadOnly(stat)) {
                String message = Policy.bind("localstore.couldNotWriteReadOnly", target.getFullPath().toString());
                throw new ResourceException(272, target.getFullPath(), message, null);
            }
            long lastModified = CoreFileSystemLibrary.getLastModified(stat);
            java.io.File localFile = new java.io.File(locationString);
            if (force) {
                if (append && !target.isLocal(0) && !localFile.exists()) {
                    String message = Policy.bind("resources.mustBeLocal", target.getFullPath().toString());
                    throw new ResourceException(369, target.getFullPath(), message, null);
                }
            } else if (target.isLocal(0)) {
                ResourceInfo info = ((Resource)((Object)target)).getResourceInfo(true, false);
                if (lastModified != info.getLocalSyncInfo()) {
                    String message = Policy.bind("localstore.resourceIsOutOfSync", target.getFullPath().toString());
                    throw new ResourceException(274, target.getFullPath(), message, null);
                }
            } else {
                if (localFile.exists()) {
                    String message = Policy.bind("localstore.resourceExists", target.getFullPath().toString());
                    throw new ResourceException(268, target.getFullPath(), message, null);
                }
                if (append) {
                    String message = Policy.bind("resources.mustBeLocal", target.getFullPath().toString());
                    throw new ResourceException(369, target.getFullPath(), message, null);
                }
            }
            UniversalUniqueIdentifier uuid = null;
            if (keepHistory && localFile.exists()) {
                uuid = this.historyStore.addState(target.getFullPath(), location, lastModified, false);
            }
            this.getStore().write(localFile, content, append, monitor);
            lastModified = CoreFileSystemLibrary.getLastModified(locationString);
            ResourceInfo info = ((Resource)((Object)target)).getResourceInfo(false, true);
            this.updateLocalSync(info, lastModified);
            if (uuid != null) {
                CoreFileSystemLibrary.copyAttributes(this.historyStore.getFileFor(uuid).getAbsolutePath(), locationString, false);
            }
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {}
        }
    }

    public void write(IFolder target, boolean force, IProgressMonitor monitor) throws CoreException {
        IPath location = this.locationFor(target);
        if (location == null) {
            String message = Policy.bind("localstore.locationUndefined", target.getFullPath().toString());
            throw new ResourceException(272, target.getFullPath(), message, null);
        }
        java.io.File file = location.toFile();
        if (!force) {
            if (file.isDirectory()) {
                String message = Policy.bind("localstore.resourceExists", target.getFullPath().toString());
                throw new ResourceException(268, target.getFullPath(), message, null);
            }
            if (file.exists()) {
                String message = Policy.bind("localstore.fileExists", target.getFullPath().toString());
                throw new ResourceException(274, target.getFullPath(), message, null);
            }
        }
        this.getStore().writeFolder(file);
        long lastModified = CoreFileSystemLibrary.getLastModified(file.getAbsolutePath());
        ResourceInfo info = ((Resource)((Object)target)).getResourceInfo(false, true);
        this.updateLocalSync(info, lastModified);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeSilently(IProject target) throws CoreException {
        block9: {
            IPath location = this.locationFor(target);
            if (location == null) {
                return;
            }
            this.getStore().writeFolder(location.toFile());
            ProjectDescription desc = ((Project)target).internalGetDescription();
            if (desc == null) {
                return;
            }
            this.getWorkspace().getMetaArea().writePrivateDescription(target);
            java.io.File file = location.append(".project").toFile();
            FileOutputStream fout = null;
            try {
                try {
                    fout = new FileOutputStream(file);
                    new ModelObjectWriter().write((Object)desc, fout);
                }
                catch (IOException e) {
                    String msg = Policy.bind("resources.writeMeta", target.getFullPath().toString());
                    throw new ResourceException(568, target.getFullPath(), msg, e);
                }
                Object var9_6 = null;
                if (fout == null) break block9;
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                if (fout == null) throw throwable;
                try {
                    fout.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            fout.close();
        }
        this.getWorkspace().getMetaArea().clearOldDescription(target);
    }

    public String getLocalName(java.io.File target) {
        java.io.File root = target.getParentFile();
        String[] list = root.list();
        if (list == null) {
            return null;
        }
        String targetName = target.getName();
        for (int i = 0; i < list.length; ++i) {
            if (!targetName.equalsIgnoreCase(list[i])) continue;
            return list[i];
        }
        return null;
    }
}

