/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.internal.events.BuilderPersistentInfo;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.SavedState;
import org.eclipse.core.internal.resources.Synchronizer;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceTreeReader_0;
import org.eclipse.core.internal.resources.WorkspaceTreeReader_2;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class WorkspaceTreeReader {
    protected Workspace workspace;

    public WorkspaceTreeReader(Workspace workspace) {
        this.workspace = workspace;
    }

    public void readTree(DataInputStream input, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.reading");
            monitor.beginTask(message, Policy.totalWork);
            this.readWorkspaceFields(input, Policy.subMonitorFor(monitor, Policy.opWork * 20 / 100));
            HashMap savedStates = new HashMap(20);
            ArrayList pluginsToBeLinked = new ArrayList(20);
            this.readPluginsSavedStates(input, savedStates, pluginsToBeLinked, Policy.subMonitorFor(monitor, Policy.opWork * 10 / 100));
            this.workspace.getSaveManager().setPluginsSavedState(savedStates);
            ArrayList buildersToBeLinked = new ArrayList(20);
            this.readBuildersPersistentInfo(input, buildersToBeLinked, Policy.subMonitorFor(monitor, Policy.opWork * 10 / 100));
            ElementTree[] trees = this.readTrees((IPath)Path.ROOT, input, Policy.subMonitorFor(monitor, Policy.opWork * 40 / 100));
            this.linkPluginsSavedStateToTrees(pluginsToBeLinked, trees, Policy.subMonitorFor(monitor, Policy.opWork * 10 / 100));
            this.linkBuildersToTrees(buildersToBeLinked, trees, pluginsToBeLinked.size(), Policy.subMonitorFor(monitor, Policy.opWork * 10 / 100));
        }
        catch (IOException e) {
            String message = Policy.bind("resources.readWorkspaceTree");
            throw new ResourceException(567, null, message, e);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readWorkspaceFields(DataInputStream input, IProgressMonitor monitor) throws IOException, CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            this.workspace.nextNodeId = input.readLong();
            this.workspace.nextModificationStamp = input.readLong();
            this.workspace.nextMarkerId = input.readLong();
            ((Synchronizer)this.workspace.getSynchronizer()).readPartners(input);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPluginsSavedStates(DataInputStream input, HashMap savedStates, List plugins, IProgressMonitor monitor) throws IOException, CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            int stateCount = input.readInt();
            for (int i = 0; i < stateCount; ++i) {
                String pluginId = input.readUTF();
                SavedState state = new SavedState(this.workspace, pluginId, null, null);
                savedStates.put(pluginId, state);
                plugins.add(state);
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBuildersPersistentInfo(DataInputStream input, List builders, IProgressMonitor monitor) throws IOException, CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            int builderCount = input.readInt();
            for (int i = 0; i < builderCount; ++i) {
                BuilderPersistentInfo info = new BuilderPersistentInfo();
                info.setProjectName(input.readUTF());
                info.setBuilderName(input.readUTF());
                builders.add(info);
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ElementTree[] readTrees(IPath root, DataInputStream input, IProgressMonitor monitor) throws IOException, CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.reading");
            monitor.beginTask(message, 4);
            ElementTreeReader treeReader = new ElementTreeReader(this.workspace.getSaveManager());
            ElementTree[] trees = treeReader.readDeltaChain(input);
            monitor.worked(3);
            if (root.isRoot()) {
                ElementTree newTree = trees[trees.length - 1];
                newTree.setTreeData(this.workspace.tree.getTreeData());
                this.workspace.tree = newTree;
            } else {
                this.workspace.linkTrees(root, trees);
            }
            monitor.worked(1);
            ElementTree[] elementTreeArray = trees;
            return elementTreeArray;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void linkPluginsSavedStateToTrees(List states, ElementTree[] trees, IProgressMonitor monitor) {
        monitor = Policy.monitorFor(monitor);
        try {
            for (int i = 0; i < states.size(); ++i) {
                SavedState state = (SavedState)states.get(i);
                if (this.workspace.getSaveManager().isOldPluginTree(state.pluginId)) continue;
                state.oldTree = trees[i];
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void linkBuildersToTrees(List buildersToBeLinked, ElementTree[] trees, int index, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            HashMap<String, BuilderPersistentInfo> infos = null;
            String projectName = null;
            for (int i = 0; i < buildersToBeLinked.size(); ++i) {
                BuilderPersistentInfo info = (BuilderPersistentInfo)buildersToBeLinked.get(i);
                if (!info.getProjectName().equals(projectName)) {
                    if (infos != null) {
                        IProject project = this.workspace.getRoot().getProject(projectName);
                        this.workspace.getBuildManager().setBuildersPersistentInfo(project, infos);
                    }
                    projectName = info.getProjectName();
                    infos = new HashMap<String, BuilderPersistentInfo>(5);
                }
                info.setLastBuildTree(trees[index++]);
                infos.put(info.getBuilderName(), info);
            }
            if (infos != null) {
                IProject project = this.workspace.getRoot().getProject(projectName);
                this.workspace.getBuildManager().setBuildersPersistentInfo(project, infos);
            }
        }
        finally {
            monitor.done();
        }
    }

    public ElementTree readSnapshotTree(DataInputStream input, ElementTree complete, IProgressMonitor monitor) throws CoreException {
        String message;
        monitor = Policy.monitorFor(monitor);
        try {
            message = Policy.bind("resources.readingSnap");
            monitor.beginTask(message, Policy.totalWork);
            ElementTreeReader reader = new ElementTreeReader(this.workspace.getSaveManager());
            while (input.available() > 0) {
                this.readWorkspaceFields(input, Policy.subMonitorFor(monitor, Policy.totalWork / 2));
                complete = reader.readDelta(complete, input);
                try {
                    int version = input.readInt();
                    if (version == this.getVersion()) continue;
                    ElementTree elementTree = WorkspaceTreeReader.getReader(this.workspace, version).readSnapshotTree(input, complete, monitor);
                    return elementTree;
                }
                catch (EOFException e) {
                    // empty catch block
                    break;
                }
            }
            ElementTree elementTree = complete;
            return elementTree;
        }
        catch (IOException e) {
            message = Policy.bind("resources.readWorkspaceSnap");
            throw new ResourceException(567, null, message, e);
        }
        finally {
            monitor.done();
        }
    }

    public static WorkspaceTreeReader getReader(Workspace workspace, int version) {
        switch (version) {
            case 67305985: {
                return new WorkspaceTreeReader(workspace);
            }
            case 67305986: {
                return new WorkspaceTreeReader_2(workspace);
            }
        }
        return new WorkspaceTreeReader_0(workspace);
    }

    protected int getVersion() {
        return 67305985;
    }

    public void readTree(IProject project, DataInputStream input, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.reading");
            monitor.beginTask(message, 10);
            int numBuilders = input.readInt();
            String[] builderNames = new String[numBuilders];
            for (int i = 0; i < numBuilders; ++i) {
                String builderName;
                builderNames[i] = builderName = input.readUTF();
            }
            monitor.worked(1);
            ElementTree[] trees = this.readTrees(project.getFullPath(), input, Policy.subMonitorFor(monitor, 8));
            if (numBuilders > 0) {
                HashMap<String, BuilderPersistentInfo> infos = new HashMap<String, BuilderPersistentInfo>(trees.length * 2 + 1);
                for (int i = 0; i < numBuilders; ++i) {
                    BuilderPersistentInfo info = new BuilderPersistentInfo();
                    info.setBuilderName(builderNames[i]);
                    info.setProjectName(project.getName());
                    info.setLastBuildTree(trees[i]);
                    infos.put(builderNames[i], info);
                }
                this.workspace.getBuildManager().setBuildersPersistentInfo(project, infos);
            }
            monitor.worked(1);
        }
        catch (IOException e) {
            String message = Policy.bind("readProjectTree");
            throw new ResourceException(567, null, message, e);
        }
        finally {
            monitor.done();
        }
    }
}

