/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IClassFileDisassembler;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.util.ClassFileReader;
import org.eclipse.jdt.internal.core.util.Disassembler;
import org.eclipse.jdt.internal.core.util.PublicScanner;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatter;

public class ToolFactory {
    public static ICodeFormatter createCodeFormatter() {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = jdtCorePlugin.getDescriptor().getExtensionPoint("codeFormatter");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            for (int i = 0; i < extensions.length; ++i) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                for (int j = 0; j < configElements.length; ++j) {
                    try {
                        Object execExt = configElements[j].createExecutableExtension("class");
                        if (!(execExt instanceof ICodeFormatter)) continue;
                        return (ICodeFormatter)execExt;
                    }
                    catch (CoreException e) {
                        // empty catch block
                    }
                }
            }
        }
        return ToolFactory.createDefaultCodeFormatter(null);
    }

    public static CodeFormatter createCodeFormatter(Map options) {
        if (options == null) {
            options = JavaCore.getOptions();
        }
        return new DefaultCodeFormatter(options);
    }

    public static ICodeFormatter createDefaultCodeFormatter(Map options) {
        if (options == null) {
            options = JavaCore.getOptions();
        }
        return new org.eclipse.jdt.internal.formatter.old.CodeFormatter(options);
    }

    public static IClassFileDisassembler createDefaultClassFileDisassembler() {
        class DeprecatedDisassembler
        extends Disassembler
        implements IClassFileDisassembler {
            DeprecatedDisassembler() {
            }
        }
        return new DeprecatedDisassembler();
    }

    public static ClassFileBytesDisassembler createDefaultClassFileBytesDisassembler() {
        return new Disassembler();
    }

    public static IClassFileReader createDefaultClassFileReader(String fileName, int decodingFlag) {
        try {
            return new ClassFileReader(Util.getFileByteContent(new File(fileName)), decodingFlag);
        }
        catch (ClassFormatException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static IClassFileReader createDefaultClassFileReader(IClassFile classfile, int decodingFlag) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)classfile.getAncestor(3);
        if (root != null) {
            try {
                if (root instanceof JarPackageFragmentRoot) {
                    String archiveName = ((JarPackageFragmentRoot)root).getJar().getName();
                    String entryName = classfile.getParent().getElementName();
                    entryName = (entryName = entryName.replace('.', '/')).equals("") ? entryName + classfile.getElementName() : entryName + '/' + classfile.getElementName();
                    return ToolFactory.createDefaultClassFileReader(archiveName, entryName, decodingFlag);
                }
                IPath location = classfile.getResource().getLocation();
                if (location == null) {
                    return null;
                }
                return ToolFactory.createDefaultClassFileReader(location.toOSString(), decodingFlag);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static IClassFileReader createDefaultClassFileReader(String zipFileName, String zipEntryName, int decodingFlag) {
        ClassFileReader classFileReader;
        ZipFile zipFile;
        block20: {
            ZipEntry zipEntry;
            block18: {
                IClassFileReader iClassFileReader;
                block19: {
                    block16: {
                        IClassFileReader iClassFileReader2;
                        block17: {
                            zipFile = null;
                            if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                System.out.println("(" + Thread.currentThread() + ") [ToolFactory.createDefaultClassFileReader()] Creating ZipFile on " + zipFileName);
                            }
                            if ((zipEntry = (zipFile = new ZipFile(zipFileName)).getEntry(zipEntryName)) != null) break block16;
                            iClassFileReader2 = null;
                            Object var8_12 = null;
                            if (zipFile == null) break block17;
                            try {
                                zipFile.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                        }
                        return iClassFileReader2;
                    }
                    if (zipEntryName.toLowerCase().endsWith(".class")) break block18;
                    iClassFileReader = null;
                    Object var8_13 = null;
                    if (zipFile == null) break block19;
                    try {
                        zipFile.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                return iClassFileReader;
            }
            byte[] classFileBytes = Util.getZipEntryByteContent(zipEntry, zipFile);
            classFileReader = new ClassFileReader(classFileBytes, decodingFlag);
            Object var8_14 = null;
            if (zipFile == null) break block20;
            try {
                zipFile.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        return classFileReader;
        catch (ClassFormatException e) {
            IClassFileReader iClassFileReader;
            block21: {
                iClassFileReader = null;
                Object var8_15 = null;
                if (zipFile == null) break block21;
                try {
                    zipFile.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            return iClassFileReader;
        }
        catch (IOException e) {
            IClassFileReader iClassFileReader;
            block22: {
                iClassFileReader = null;
                Object var8_16 = null;
                if (zipFile == null) break block22;
                {
                    catch (Throwable throwable) {
                        block23: {
                            Object var8_17 = null;
                            if (zipFile == null) break block23;
                            try {
                                zipFile.close();
                            }
                            catch (IOException e2) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    zipFile.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            return iClassFileReader;
        }
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean assertMode, boolean recordLineSeparator) {
        PublicScanner scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, assertMode ? 0x300000L : 0x2F0000L, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean recordLineSeparator, String sourceLevel) {
        PublicScanner scanner = null;
        long level = CompilerOptions.versionToJdkLevel(sourceLevel);
        if (level == 0L) {
            level = 0x2F0000L;
        }
        scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, level, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }
}

