/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;

class TypeBinding
implements ITypeBinding {
    private static final String NO_NAME = "";
    private static final ITypeBinding[] NO_TYPE_BINDINGS = new ITypeBinding[0];
    private static final IVariableBinding[] NO_VARIABLE_BINDINGS = new IVariableBinding[0];
    private static final IMethodBinding[] NO_METHOD_BINDINGS = new IMethodBinding[0];
    private org.eclipse.jdt.internal.compiler.lookup.TypeBinding binding;
    private BindingResolver resolver;
    private String key;

    public TypeBinding(BindingResolver resolver, org.eclipse.jdt.internal.compiler.lookup.TypeBinding binding) {
        this.binding = binding;
        this.resolver = resolver;
    }

    public boolean isPrimitive() {
        return !this.isNullType() && this.binding.isBaseType();
    }

    public boolean isArray() {
        return this.binding.isArrayType();
    }

    public ITypeBinding getElementType() {
        if (!this.isArray()) {
            return null;
        }
        ArrayBinding arrayBinding = (ArrayBinding)this.binding;
        return this.resolver.getTypeBinding(arrayBinding.leafComponentType);
    }

    public int getDimensions() {
        if (!this.isArray()) {
            return 0;
        }
        ArrayBinding arrayBinding = (ArrayBinding)this.binding;
        return arrayBinding.dimensions;
    }

    public boolean isClass() {
        return this.binding.isClass();
    }

    public boolean isInterface() {
        return this.binding.isInterface();
    }

    public boolean isTypeVariable() {
        return false;
    }

    public String getName() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            if (referenceBinding.isAnonymousType()) {
                return NO_NAME;
            }
            if (referenceBinding.isMemberType()) {
                char[] name = referenceBinding.compoundName[referenceBinding.compoundName.length - 1];
                return new String(CharOperation.subarray(name, CharOperation.lastIndexOf('$', name) + 1, name.length));
            }
            if (referenceBinding.isLocalType()) {
                char[] name = referenceBinding.compoundName[referenceBinding.compoundName.length - 1];
                return new String(CharOperation.subarray(name, CharOperation.lastIndexOf('$', name) + 1, name.length));
            }
            return new String(referenceBinding.compoundName[referenceBinding.compoundName.length - 1]);
        }
        if (this.binding.isArrayType()) {
            ArrayBinding arrayBinding = (ArrayBinding)this.binding;
            int dimensions = arrayBinding.dimensions;
            char[] brackets = new char[dimensions * 2];
            for (int i = dimensions * 2 - 1; i >= 0; i -= 2) {
                brackets[i] = 93;
                brackets[i - 1] = 91;
            }
            StringBuffer buffer = new StringBuffer();
            org.eclipse.jdt.internal.compiler.lookup.TypeBinding leafComponentTypeBinding = arrayBinding.leafComponentType;
            if (leafComponentTypeBinding.isClass() || leafComponentTypeBinding.isInterface()) {
                ReferenceBinding referenceBinding2 = (ReferenceBinding)leafComponentTypeBinding;
                if (referenceBinding2.isMemberType()) {
                    char[] name = referenceBinding2.compoundName[referenceBinding2.compoundName.length - 1];
                    buffer.append(CharOperation.subarray(name, CharOperation.lastIndexOf('$', name) + 1, name.length));
                } else if (referenceBinding2.isLocalType()) {
                    char[] name = referenceBinding2.compoundName[referenceBinding2.compoundName.length - 1];
                    buffer.append(CharOperation.subarray(name, CharOperation.lastIndexOf('$', name) + 1, name.length));
                } else {
                    buffer.append(referenceBinding2.compoundName[referenceBinding2.compoundName.length - 1]);
                }
            } else {
                buffer.append(leafComponentTypeBinding.readableName());
            }
            buffer.append(brackets);
            return buffer.toString();
        }
        return new String(this.binding.readableName());
    }

    public IPackageBinding getPackage() {
        if (this.binding.isBaseType() || this.binding.isArrayType()) {
            return null;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
        return this.resolver.getPackageBinding(referenceBinding.getPackage());
    }

    public ITypeBinding getDeclaringClass() {
        if (this.binding.isArrayType() || this.binding.isBaseType()) {
            return null;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
        if (referenceBinding.isNestedType()) {
            try {
                return this.resolver.getTypeBinding(referenceBinding.enclosingType());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    public ITypeBinding getSuperclass() {
        if (this.binding == null || this.binding.isArrayType() || this.binding.isBaseType() || this.binding.isInterface()) {
            return null;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
        ReferenceBinding superclass = null;
        try {
            superclass = referenceBinding.superclass();
        }
        catch (RuntimeException e) {
            return this.resolver.resolveWellKnownType("java.lang.Object");
        }
        if (superclass == null) {
            return null;
        }
        return this.resolver.getTypeBinding(superclass);
    }

    public ITypeBinding[] getInterfaces() {
        if (this.binding == null || this.binding.isArrayType() || this.binding.isBaseType()) {
            return NO_TYPE_BINDINGS;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
        ReferenceBinding[] interfaces = null;
        try {
            interfaces = referenceBinding.superInterfaces();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        if (interfaces == null) {
            return NO_TYPE_BINDINGS;
        }
        int length = interfaces.length;
        if (length == 0) {
            return NO_TYPE_BINDINGS;
        }
        ITypeBinding[] newInterfaces = new ITypeBinding[length];
        for (int i = 0; i < length; ++i) {
            newInterfaces[i] = this.resolver.getTypeBinding(interfaces[i]);
        }
        return newInterfaces;
    }

    public int getModifiers() {
        if (this.binding.isClass()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            if (referenceBinding.isAnonymousType()) {
                return referenceBinding.getAccessFlags() & 0xFFFFFFEF;
            }
            return referenceBinding.getAccessFlags();
        }
        if (this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.getAccessFlags() & 0xFFFFF9FF;
        }
        return 0;
    }

    public int getDeclaredModifiers() {
        return this.getModifiers();
    }

    public boolean isTopLevel() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return !referenceBinding.isNestedType();
        }
        return false;
    }

    public boolean isNested() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isNestedType();
        }
        return false;
    }

    public boolean isMember() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isMemberType();
        }
        return false;
    }

    public boolean isLocal() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isLocalType() && !referenceBinding.isMemberType();
        }
        return false;
    }

    public boolean isAnonymous() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isAnonymousType();
        }
        return false;
    }

    public ITypeBinding[] getDeclaredTypes() {
        try {
            if (this.binding.isClass() || this.binding.isInterface()) {
                ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
                ReferenceBinding[] members = referenceBinding.memberTypes();
                int length = members.length;
                ITypeBinding[] newMembers = new ITypeBinding[length];
                for (int i = 0; i < length; ++i) {
                    newMembers[i] = this.resolver.getTypeBinding(members[i]);
                }
                return newMembers;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return NO_TYPE_BINDINGS;
    }

    public String getBinaryName() {
        char[] constantPoolName = this.binding.constantPoolName();
        if (constantPoolName == null) {
            return null;
        }
        int length = constantPoolName.length;
        char[] dotSeparated = new char[length];
        System.arraycopy(constantPoolName, 0, dotSeparated, 0, length);
        CharOperation.replace(dotSeparated, '/', '.');
        return new String(dotSeparated);
    }

    public IVariableBinding[] getDeclaredFields() {
        try {
            if (this.binding.isClass() || this.binding.isInterface()) {
                ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
                FieldBinding[] fields = referenceBinding.fields();
                int length = fields.length;
                IVariableBinding[] newFields = new IVariableBinding[length];
                for (int i = 0; i < length; ++i) {
                    newFields[i] = this.resolver.getVariableBinding(fields[i]);
                }
                return newFields;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return NO_VARIABLE_BINDINGS;
    }

    public IMethodBinding[] getDeclaredMethods() {
        try {
            if (this.binding.isClass() || this.binding.isInterface()) {
                ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
                MethodBinding[] methods = referenceBinding.methods();
                int length = methods.length;
                int removeSyntheticsCounter = 0;
                IMethodBinding[] newMethods = new IMethodBinding[length];
                for (int i = 0; i < length; ++i) {
                    MethodBinding methodBinding = methods[i];
                    if (this.shouldBeRemoved(methodBinding)) continue;
                    newMethods[removeSyntheticsCounter++] = this.resolver.getMethodBinding(methodBinding);
                }
                if (removeSyntheticsCounter != length) {
                    IMethodBinding[] iMethodBindingArray = newMethods;
                    newMethods = new IMethodBinding[removeSyntheticsCounter];
                    System.arraycopy(iMethodBindingArray, 0, newMethods, 0, removeSyntheticsCounter);
                }
                return newMethods;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return NO_METHOD_BINDINGS;
    }

    private boolean shouldBeRemoved(MethodBinding methodBinding) {
        return methodBinding.isDefaultAbstract() || methodBinding.isSynthetic() || methodBinding.isConstructor() && this.isInterface();
    }

    public boolean isFromSource() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return !referenceBinding.isBinaryBinding();
        }
        return false;
    }

    public int getKind() {
        return 2;
    }

    public boolean isDeprecated() {
        if (this.binding.isClass() || this.binding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isDeprecated();
        }
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public String getKey() {
        if (this.key == null) {
            if (this.isLocal()) {
                ITypeBinding typeBinding;
                Binding internalBinding;
                ReferenceContext referenceContext;
                StringBuffer buffer = new StringBuffer();
                SourceTypeBinding sourceBinding = (SourceTypeBinding)this.binding;
                ClassScope scope = sourceBinding.scope;
                if (this.isAnonymous()) {
                    ClassScope classScope = scope.enclosingClassScope();
                    referenceContext = classScope.referenceContext;
                } else {
                    MethodScope methodScope = scope.enclosingMethodScope();
                    referenceContext = methodScope.referenceContext;
                }
                if (referenceContext instanceof AbstractMethodDeclaration) {
                    internalBinding = ((AbstractMethodDeclaration)referenceContext).binding;
                    IMethodBinding methodBinding = this.resolver.getMethodBinding((MethodBinding)internalBinding);
                    if (methodBinding != null) {
                        buffer.append(methodBinding.getKey());
                    }
                } else if (referenceContext instanceof TypeDeclaration && (typeBinding = this.resolver.getTypeBinding((org.eclipse.jdt.internal.compiler.lookup.TypeBinding)(internalBinding = referenceContext.binding))) != null) {
                    buffer.append(typeBinding.getKey());
                }
                if (this.isAnonymous()) {
                    buffer.append('$');
                    CompilationUnitScope compilationUnitScope = scope.compilationUnitScope();
                    CompilationUnitDeclaration compilationUnitDeclaration = compilationUnitScope.referenceContext;
                    LocalTypeBinding[] localTypeBindings = compilationUnitDeclaration.localTypes;
                    int max = compilationUnitDeclaration.localTypeCount;
                    for (int i = 0; i < max; ++i) {
                        if (localTypeBindings[i] != sourceBinding) continue;
                        buffer.append(i + 1);
                        break;
                    }
                } else {
                    buffer.append('/');
                    buffer.append(this.getName());
                }
                this.key = buffer.toString();
            } else if (this.binding.isClass() || this.binding.isInterface()) {
                StringBuffer buffer = new StringBuffer();
                char[] constantPoolName = this.binding.constantPoolName();
                if (constantPoolName != null) {
                    buffer.append(constantPoolName);
                } else {
                    char[] qualifiedSourceName = this.binding.qualifiedSourceName();
                    if (qualifiedSourceName != null) {
                        CharOperation.replace(qualifiedSourceName, '.', '$');
                        buffer.append(this.getPackage().getName()).append('/').append(qualifiedSourceName);
                    } else {
                        buffer.append(this.getPackage().getName()).append('/').append(this.getName());
                    }
                }
                this.key = buffer.toString();
            } else {
                this.key = this.binding.isArrayType() ? (this.getElementType() != null ? this.getElementType().getKey() + this.getDimensions() : Integer.toString(this.getDimensions())) : this.getName();
            }
        }
        return this.key;
    }

    public boolean isNullType() {
        return this.binding == BaseTypes.NullBinding;
    }

    public String getQualifiedName() {
        if (this.isAnonymous() || this.isLocal()) {
            return NO_NAME;
        }
        if (this.isPrimitive() || this.isNullType()) {
            return this.getName();
        }
        if (this.isArray()) {
            ITypeBinding elementType = this.getElementType();
            String elementTypeQualifiedName = elementType.getQualifiedName();
            if (elementTypeQualifiedName.length() != 0) {
                int dimensions = this.getDimensions();
                char[] brackets = new char[dimensions * 2];
                for (int i = dimensions * 2 - 1; i >= 0; i -= 2) {
                    brackets[i] = 93;
                    brackets[i - 1] = 91;
                }
                StringBuffer stringBuffer = new StringBuffer(elementTypeQualifiedName);
                stringBuffer.append(brackets);
                return stringBuffer.toString();
            }
            return NO_NAME;
        }
        if (this.isTopLevel() || this.isMember()) {
            PackageBinding packageBinding = this.binding.getPackage();
            if (packageBinding == null || packageBinding.compoundName == CharOperation.NO_CHAR_CHAR) {
                return new String(this.binding.qualifiedSourceName());
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.binding.qualifiedPackageName()).append('.').append(this.binding.qualifiedSourceName());
            return stringBuffer.toString();
        }
        return NO_NAME;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isAnnotation() {
        return false;
    }

    public ITypeBinding[] getTypeParameters() {
        return NO_TYPE_BINDINGS;
    }

    public ITypeBinding[] getTypeBounds() {
        return NO_TYPE_BINDINGS;
    }

    public boolean isParameterizedType() {
        return false;
    }

    public ITypeBinding[] getTypeArguments() {
        return NO_TYPE_BINDINGS;
    }

    public ITypeBinding getErasure() {
        return this;
    }

    public boolean isRawType() {
        return false;
    }

    public boolean isWildcardType() {
        return false;
    }

    public ITypeBinding getBound() {
        return null;
    }

    public boolean isUpperbound() {
        return false;
    }

    public String toString() {
        return this.binding.toString();
    }
}

