/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.CopyPackageFragmentRootOperation;
import org.eclipse.jdt.internal.core.CreatePackageFragmentOperation;
import org.eclipse.jdt.internal.core.DeletePackageFragmentRootOperation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.MovePackageFragmentRootOperation;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRootInfo;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.jdt.internal.core.util.Util;

public class PackageFragmentRoot
extends Openable
implements IPackageFragmentRoot {
    protected static final char ATTACHMENT_PROPERTY_DELIMITER = '*';
    protected static final String NO_SOURCE_ATTACHMENT = "";
    protected static final SourceMapper NO_SOURCE_MAPPER = new SourceMapper();
    protected Object resource;

    protected PackageFragmentRoot(IResource resource, JavaProject project, String name) {
        super(project, name);
        this.resource = resource;
    }

    public void attachSource(IPath sourcePath, IPath rootPath, IProgressMonitor monitor) throws JavaModelException {
        try {
            this.verifyAttachSource(sourcePath);
            if (monitor != null) {
                monitor.beginTask(Util.bind("element.attachingSource"), 2);
            }
            SourceMapper oldMapper = this.getSourceMapper();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            boolean rootNeedsToBeClosed = false;
            if (sourcePath == null) {
                rootNeedsToBeClosed = true;
                this.setSourceMapper(null);
            } else {
                Object target;
                IPath storedSourcePath = this.getSourceAttachmentPath();
                IPath storedRootPath = this.getSourceAttachmentRootPath();
                if (monitor != null) {
                    monitor.worked(1);
                }
                if (!(storedSourcePath == null || storedSourcePath.equals(sourcePath) && rootPath != null && rootPath.equals(storedRootPath) || storedRootPath == null)) {
                    rootNeedsToBeClosed = true;
                }
                if ((target = JavaModel.getTarget((IContainer)workspace.getRoot(), sourcePath, false)) == null) {
                    if (monitor != null) {
                        monitor.done();
                    }
                    throw new JavaModelException(new JavaModelStatus(979, sourcePath));
                }
                SourceMapper mapper = this.createSourceMapper(sourcePath, rootPath);
                if (rootPath == null && mapper.rootPath != null) {
                    rootPath = new Path(mapper.rootPath);
                }
                this.setSourceMapper(mapper);
            }
            if (sourcePath == null) {
                this.setSourceAttachmentProperty(null);
            } else {
                this.setSourceAttachmentProperty(sourcePath.toString() + (rootPath == null ? NO_SOURCE_ATTACHMENT : '*' + rootPath.toString()));
            }
            if (rootNeedsToBeClosed) {
                if (oldMapper != null) {
                    oldMapper.close();
                }
                BufferManager manager = BufferManager.getDefaultBufferManager();
                Enumeration openBuffers = manager.getOpenBuffers();
                while (openBuffers.hasMoreElements()) {
                    IBuffer buffer = (IBuffer)openBuffers.nextElement();
                    IOpenable possibleMember = buffer.getOwner();
                    if (!this.isAncestorOf((IJavaElement)((Object)possibleMember))) continue;
                    buffer.close();
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
        }
        catch (JavaModelException e) {
            this.setSourceAttachmentProperty(null);
            throw e;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        if (!this.resourceExists() || !this.isOnClasspath()) {
            throw this.newNotPresentException();
        }
        ((PackageFragmentRootInfo)info).setRootKind(this.determineKind(underlyingResource));
        return this.computeChildren(info, newElements);
    }

    SourceMapper createSourceMapper(IPath sourcePath, IPath rootPath) {
        SourceMapper mapper = new SourceMapper(sourcePath, rootPath == null ? null : rootPath.toOSString(), this.isExternal() ? JavaCore.getOptions() : this.getJavaProject().getOptions(true));
        return mapper;
    }

    public void delete(int updateResourceFlags, int updateModelFlags, IProgressMonitor monitor) throws JavaModelException {
        DeletePackageFragmentRootOperation op = new DeletePackageFragmentRootOperation(this, updateResourceFlags, updateModelFlags);
        op.runOperation(monitor);
    }

    protected boolean computeChildren(OpenableElementInfo info, Map newElements) throws JavaModelException {
        try {
            IResource underlyingResource = this.getResource();
            if (underlyingResource.getType() == 2 || underlyingResource.getType() == 4) {
                char[][] exclusionPatterns;
                IContainer rootFolder;
                ArrayList vChildren = new ArrayList(5);
                char[][] inclusionPatterns = this.fullInclusionPatternChars();
                this.computeFolderChildren(rootFolder, !Util.isExcluded((IResource)(rootFolder = (IContainer)underlyingResource), inclusionPatterns, exclusionPatterns = this.fullExclusionPatternChars()), NO_SOURCE_ATTACHMENT, vChildren, inclusionPatterns, exclusionPatterns);
                IJavaElement[] children = new IJavaElement[vChildren.size()];
                vChildren.toArray(children);
                info.setChildren(children);
            }
        }
        catch (JavaModelException e) {
            info.setChildren(new IJavaElement[0]);
            throw e;
        }
        return true;
    }

    protected void computeFolderChildren(IContainer folder, boolean isIncluded, String prefix, ArrayList vChildren, char[][] inclusionPatterns, char[][] exclusionPatterns) throws JavaModelException {
        if (isIncluded) {
            IPackageFragment pkg = this.getPackageFragment(prefix);
            vChildren.add(pkg);
        }
        try {
            JavaProject javaProject = (JavaProject)this.getJavaProject();
            IResource[] members = folder.members();
            boolean hasIncluded = isIncluded;
            int max = members.length;
            block7: for (int i = 0; i < max; ++i) {
                IResource member = members[i];
                String memberName = member.getName();
                switch (member.getType()) {
                    case 2: {
                        boolean isMemberIncluded;
                        if (!Util.isValidFolderNameForPackage(memberName)) continue block7;
                        boolean bl = isMemberIncluded = !Util.isExcluded(member, inclusionPatterns, exclusionPatterns);
                        if (!isMemberIncluded && inclusionPatterns == null || !javaProject.contains(member)) continue block7;
                        String newPrefix = prefix.length() == 0 ? memberName : prefix + "." + memberName;
                        this.computeFolderChildren((IContainer)((IFolder)member), isMemberIncluded, newPrefix, vChildren, inclusionPatterns, exclusionPatterns);
                        continue block7;
                    }
                    case 1: {
                        if (hasIncluded || !Util.isValidCompilationUnitName(memberName) || Util.isExcluded(member, inclusionPatterns, exclusionPatterns)) continue block7;
                        hasIncluded = true;
                        IPackageFragment pkg = this.getPackageFragment(prefix);
                        vChildren.add(pkg);
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new JavaModelException(e, 969);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public void copy(IPath destination, int updateResourceFlags, int updateModelFlags, IClasspathEntry sibling, IProgressMonitor monitor) throws JavaModelException {
        CopyPackageFragmentRootOperation op = new CopyPackageFragmentRootOperation(this, destination, updateResourceFlags, updateModelFlags, sibling);
        op.runOperation(monitor);
    }

    protected Object createElementInfo() {
        return new PackageFragmentRootInfo();
    }

    public IPackageFragment createPackageFragment(String pkgName, boolean force, IProgressMonitor monitor) throws JavaModelException {
        CreatePackageFragmentOperation op = new CreatePackageFragmentOperation(this, pkgName, force);
        op.runOperation(monitor);
        return this.getPackageFragment(pkgName);
    }

    protected int determineKind(IResource underlyingResource) throws JavaModelException {
        IClasspathEntry[] entries = ((JavaProject)this.getJavaProject()).getExpandedClasspath(true);
        for (int i = 0; i < entries.length; ++i) {
            IClasspathEntry entry = entries[i];
            if (!entry.getPath().equals(underlyingResource.getFullPath())) continue;
            return entry.getContentKind();
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageFragmentRoot)) {
            return false;
        }
        PackageFragmentRoot other = (PackageFragmentRoot)o;
        return this.resource.equals(other.resource) && this.occurrenceCount == other.occurrenceCount && this.parent.equals(other.parent);
    }

    public boolean exists() {
        return super.exists() && this.isOnClasspath();
    }

    public IClasspathEntry findSourceAttachmentRecommendation() {
        try {
            IClasspathEntry entry;
            JavaProject parentProject;
            IWorkspaceRoot workspaceRoot;
            IPath rootPath;
            block13: {
                rootPath = this.getPath();
                workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                parentProject = (JavaProject)this.getJavaProject();
                try {
                    Object file;
                    entry = parentProject.getClasspathEntryFor(rootPath);
                    if (entry == null) break block13;
                    Object target = JavaModel.getTarget((IContainer)workspaceRoot, entry.getSourceAttachmentPath(), true);
                    if (target instanceof IResource) {
                        if (target instanceof IFile ? org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName((file = (IFile)target).getName()) : target instanceof IContainer) {
                            return entry;
                        }
                        break block13;
                    }
                    if (!(target instanceof File)) break block13;
                    file = (File)target;
                    if (((File)file).isFile()) {
                        if (org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(((File)file).getName())) {
                            return entry;
                        }
                        break block13;
                    }
                    return entry;
                }
                catch (JavaModelException e) {
                    // empty catch block
                }
            }
            IJavaModel model = this.getJavaModel();
            IJavaProject[] jProjects = model.getJavaProjects();
            int max = jProjects.length;
            for (int i = 0; i < max; ++i) {
                JavaProject jProject = (JavaProject)jProjects[i];
                if (jProject == parentProject) continue;
                try {
                    Object file;
                    entry = jProject.getClasspathEntryFor(rootPath);
                    if (entry == null) continue;
                    Object target = JavaModel.getTarget((IContainer)workspaceRoot, entry.getSourceAttachmentPath(), true);
                    if (target instanceof IResource) {
                        if (!(target instanceof IFile ? org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName((file = (IFile)target).getName()) : target instanceof IContainer)) continue;
                        return entry;
                    }
                    if (!(target instanceof File)) continue;
                    file = (File)target;
                    if (((File)file).isFile()) {
                        if (!org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(((File)file).getName())) continue;
                        return entry;
                    }
                    return entry;
                }
                catch (JavaModelException e) {
                    // empty catch block
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    public char[][] fullExclusionPatternChars() {
        try {
            if (this.isOpen() && this.getKind() != 1) {
                return null;
            }
            ClasspathEntry entry = (ClasspathEntry)this.getRawClasspathEntry();
            if (entry == null) {
                return null;
            }
            return entry.fullExclusionPatternChars();
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    public char[][] fullInclusionPatternChars() {
        try {
            if (this.isOpen() && this.getKind() != 1) {
                return null;
            }
            ClasspathEntry entry = (ClasspathEntry)this.getRawClasspathEntry();
            if (entry == null) {
                return null;
            }
            return entry.fullInclusionPatternChars();
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    public int getElementType() {
        return 3;
    }

    protected char getHandleMementoDelimiter() {
        return '/';
    }

    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, owner);
            }
            case '<': {
                String pkgName;
                if (memento.hasMoreTokens()) {
                    pkgName = memento.nextToken();
                    char firstChar = pkgName.charAt(0);
                    if (firstChar == '(' || firstChar == '{' || firstChar == '!') {
                        token = pkgName;
                        pkgName = NO_SOURCE_ATTACHMENT;
                    } else {
                        token = null;
                    }
                } else {
                    pkgName = NO_SOURCE_ATTACHMENT;
                    token = null;
                }
                JavaElement pkg = (JavaElement)((Object)this.getPackageFragment(pkgName));
                if (token == null) {
                    return pkg.getHandleFromMemento(memento, owner);
                }
                return pkg.getHandleFromMemento(token, memento, owner);
            }
        }
        return null;
    }

    public String getHandleMemento() {
        IResource underlyingResource = this.getResource();
        IPath path = underlyingResource != null ? (this.getResource().getProject().equals(this.getJavaProject().getProject()) ? underlyingResource.getProjectRelativePath() : underlyingResource.getFullPath()) : this.getPath();
        StringBuffer buff = new StringBuffer(((JavaElement)this.getParent()).getHandleMemento());
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, path.toString());
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
        return buff.toString();
    }

    public int getKind() throws JavaModelException {
        return ((PackageFragmentRootInfo)this.getElementInfo()).getRootKind();
    }

    public Object[] getNonJavaResources() throws JavaModelException {
        return ((PackageFragmentRootInfo)this.getElementInfo()).getNonJavaResources(this.getJavaProject(), this.getResource(), this);
    }

    public IPackageFragment getPackageFragment(String packageName) {
        if (packageName.indexOf(32) != -1) {
            char[][] compoundName = Util.toCompoundChars(packageName);
            StringBuffer buffer = new StringBuffer(packageName.length());
            int length = compoundName.length;
            for (int i = 0; i < length; ++i) {
                buffer.append(CharOperation.trim(compoundName[i]));
                if (i == length - 1) continue;
                buffer.append('.');
            }
            packageName = buffer.toString();
        }
        return new PackageFragment(this, packageName);
    }

    protected String getPackageName(IFolder folder) {
        IPath myPath = this.getPath();
        IPath pkgPath = folder.getFullPath();
        int mySegmentCount = myPath.segmentCount();
        int pkgSegmentCount = pkgPath.segmentCount();
        StringBuffer pkgName = new StringBuffer(NO_SOURCE_ATTACHMENT);
        for (int i = mySegmentCount; i < pkgSegmentCount; ++i) {
            if (i > mySegmentCount) {
                pkgName.append('.');
            }
            pkgName.append(pkgPath.segment(i));
        }
        return pkgName.toString();
    }

    public IPath getPath() {
        return this.getResource().getFullPath();
    }

    public IClasspathEntry getRawClasspathEntry() throws JavaModelException {
        IClasspathEntry rawEntry = null;
        JavaProject project = (JavaProject)this.getJavaProject();
        project.getResolvedClasspath(true, false, false);
        JavaModelManager.PerProjectInfo perProjectInfo = project.getPerProjectInfo();
        if (perProjectInfo != null && perProjectInfo.resolvedPathToRawEntries != null) {
            rawEntry = (IClasspathEntry)perProjectInfo.resolvedPathToRawEntries.get(this.getPath());
        }
        return rawEntry;
    }

    public IResource getResource() {
        return (IResource)this.resource;
    }

    public IPath getSourceAttachmentPath() throws JavaModelException {
        if (this.getKind() != 2) {
            return null;
        }
        String serverPathString = this.getSourceAttachmentProperty();
        if (serverPathString == null) {
            return null;
        }
        int index = serverPathString.lastIndexOf(42);
        if (index < 0) {
            return new Path(serverPathString);
        }
        String serverSourcePathString = serverPathString.substring(0, index);
        return new Path(serverSourcePathString);
    }

    protected String getSourceAttachmentProperty() throws JavaModelException {
        String propertyString = null;
        QualifiedName qName = this.getSourceAttachmentPropertyName();
        try {
            propertyString = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(qName);
            if (propertyString == null) {
                IClasspathEntry recommendation = this.findSourceAttachmentRecommendation();
                if (recommendation != null) {
                    IPath rootPath = recommendation.getSourceAttachmentRootPath();
                    propertyString = recommendation.getSourceAttachmentPath().toString() + (rootPath == null ? NO_SOURCE_ATTACHMENT : '*' + rootPath.toString());
                    this.setSourceAttachmentProperty(propertyString);
                } else {
                    this.setSourceAttachmentProperty(NO_SOURCE_ATTACHMENT);
                }
            } else if (NO_SOURCE_ATTACHMENT.equals(propertyString)) {
                return null;
            }
            return propertyString;
        }
        catch (CoreException ce) {
            throw new JavaModelException(ce);
        }
    }

    protected QualifiedName getSourceAttachmentPropertyName() {
        return new QualifiedName("org.eclipse.jdt.core", "sourceattachment: " + this.getPath().toOSString());
    }

    public void setSourceAttachmentProperty(String property) {
        try {
            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(this.getSourceAttachmentPropertyName(), property);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void setSourceMapper(SourceMapper mapper) throws JavaModelException {
        ((PackageFragmentRootInfo)this.getElementInfo()).setSourceMapper(mapper);
    }

    public IPath getSourceAttachmentRootPath() throws JavaModelException {
        if (this.getKind() != 2) {
            return null;
        }
        String serverPathString = this.getSourceAttachmentProperty();
        if (serverPathString == null) {
            return null;
        }
        int index = serverPathString.lastIndexOf(42);
        if (index == -1) {
            return null;
        }
        String serverRootPathString = NO_SOURCE_ATTACHMENT;
        if (index != serverPathString.length() - 1) {
            serverRootPathString = serverPathString.substring(index + 1);
        }
        return new Path(serverRootPathString);
    }

    public SourceMapper getSourceMapper() {
        SourceMapper mapper;
        try {
            PackageFragmentRootInfo rootInfo = (PackageFragmentRootInfo)this.getElementInfo();
            mapper = rootInfo.getSourceMapper();
            if (mapper == null) {
                IPath sourcePath = this.getSourceAttachmentPath();
                if (sourcePath != null) {
                    IPath rootPath = this.getSourceAttachmentRootPath();
                    mapper = this.createSourceMapper(sourcePath, rootPath);
                    if (rootPath == null && mapper.rootPath != null) {
                        rootPath = new Path(mapper.rootPath);
                        this.setSourceAttachmentProperty(sourcePath.toString() + '*' + rootPath.toString());
                    }
                    rootInfo.setSourceMapper(mapper);
                } else {
                    rootInfo.setSourceMapper(NO_SOURCE_MAPPER);
                    mapper = null;
                }
            } else if (mapper == NO_SOURCE_MAPPER) {
                mapper = null;
            }
        }
        catch (JavaModelException e) {
            mapper = null;
        }
        return mapper;
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.getResource();
    }

    public boolean hasChildren() throws JavaModelException {
        return true;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean isArchive() {
        return false;
    }

    public boolean isExternal() {
        return false;
    }

    protected boolean isOnClasspath() {
        IPath path = this.getPath();
        try {
            JavaProject project = (JavaProject)this.getJavaProject();
            IClasspathEntry[] classpath = project.getResolvedClasspath(true, false, false);
            int length = classpath.length;
            for (int i = 0; i < length; ++i) {
                IClasspathEntry entry = classpath[i];
                if (!entry.getPath().equals(path)) continue;
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    public void move(IPath destination, int updateResourceFlags, int updateModelFlags, IClasspathEntry sibling, IProgressMonitor monitor) throws JavaModelException {
        MovePackageFragmentRootOperation op = new MovePackageFragmentRootOperation(this, destination, updateResourceFlags, updateModelFlags, sibling);
        op.runOperation(monitor);
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        IPath path = this.getPath();
        if (this.getJavaProject().getElementName().equals(path.segment(0))) {
            if (path.segmentCount() == 1) {
                buffer.append("<project root>");
            } else {
                buffer.append(path.removeFirstSegments(1).makeRelative());
            }
        } else if (this.isExternal()) {
            buffer.append(path.toOSString());
        } else {
            buffer.append(path);
        }
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    protected void verifyAttachSource(IPath sourcePath) throws JavaModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        if (this.getKind() != 2) {
            throw new JavaModelException(new JavaModelStatus(967, this));
        }
        if (sourcePath != null && !sourcePath.isAbsolute()) {
            throw new JavaModelException(new JavaModelStatus(972, sourcePath));
        }
    }
}

