/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;

public class TypeConverter {
    public static TypeDeclaration buildTypeDeclaration(IType type, CompilationUnitDeclaration compilationUnit, CompilationResult compilationResult) throws JavaModelException {
        char[] packageName = type.getPackageFragment().getElementName().toCharArray();
        if (packageName != null && packageName.length > 0) {
            compilationUnit.currentPackage = new ImportReference(CharOperation.splitOn('.', packageName), new long[]{0L}, false, 0);
        }
        TypeDeclaration typeDeclaration = TypeConverter.convert(type, null, null, compilationResult);
        IType alreadyComputedMember = type;
        TypeDeclaration previousDeclaration = typeDeclaration;
        for (IType parent = type.getDeclaringType(); parent != null; parent = parent.getDeclaringType()) {
            TypeDeclaration declaration = TypeConverter.convert(parent, alreadyComputedMember, previousDeclaration, compilationResult);
            alreadyComputedMember = parent;
            previousDeclaration = declaration;
        }
        compilationUnit.types = new TypeDeclaration[]{previousDeclaration};
        return typeDeclaration;
    }

    private static FieldDeclaration convert(IField field, IType type) throws JavaModelException {
        FieldDeclaration fieldDeclaration = new FieldDeclaration();
        fieldDeclaration.name = field.getElementName().toCharArray();
        fieldDeclaration.type = TypeConverter.createTypeReference(Signature.toString(field.getTypeSignature()).toCharArray(), type);
        fieldDeclaration.modifiers = field.getFlags();
        return fieldDeclaration;
    }

    private static AbstractMethodDeclaration convert(IMethod method, IType type, CompilationResult compilationResult) throws JavaModelException {
        int exceptionCount;
        AbstractMethodDeclaration methodDeclaration;
        AbstractMethodDeclaration decl;
        if (method.isConstructor()) {
            decl = new ConstructorDeclaration(compilationResult);
            decl.isDefaultConstructor = false;
            methodDeclaration = decl;
        } else {
            decl = new MethodDeclaration(compilationResult);
            ((MethodDeclaration)decl).returnType = TypeConverter.createTypeReference(Signature.toString(method.getReturnType()).toCharArray(), type);
            methodDeclaration = decl;
        }
        methodDeclaration.selector = method.getElementName().toCharArray();
        methodDeclaration.modifiers = method.getFlags();
        String[] argumentTypeNames = method.getParameterTypes();
        String[] argumentNames = method.getParameterNames();
        int argumentCount = argumentTypeNames == null ? 0 : argumentTypeNames.length;
        methodDeclaration.arguments = new Argument[argumentCount];
        for (int i = 0; i < argumentCount; ++i) {
            methodDeclaration.arguments[i] = new Argument(argumentNames[i].toCharArray(), 0L, TypeConverter.createTypeReference(Signature.toString(argumentTypeNames[i]).toCharArray(), type), 0);
        }
        String[] exceptionTypeNames = method.getExceptionTypes();
        int n = exceptionCount = exceptionTypeNames == null ? 0 : exceptionTypeNames.length;
        if (exceptionCount > 0) {
            methodDeclaration.thrownExceptions = new TypeReference[exceptionCount];
            for (int i = 0; i < exceptionCount; ++i) {
                methodDeclaration.thrownExceptions[i] = TypeConverter.createTypeReference(Signature.toString(exceptionTypeNames[i]).toCharArray(), type);
            }
        }
        return methodDeclaration;
    }

    private static TypeDeclaration convert(IType type, IType alreadyComputedMember, TypeDeclaration alreadyComputedMemberDeclaration, CompilationResult compilationResult) throws JavaModelException {
        boolean isInterface;
        String[] interfaceNames;
        TypeDeclaration typeDeclaration = new TypeDeclaration(compilationResult);
        if (type.getDeclaringType() != null) {
            typeDeclaration.bits |= 0x400;
        }
        typeDeclaration.name = type.getElementName().toCharArray();
        typeDeclaration.modifiers = type.getFlags();
        if (type.getSuperclassName() != null) {
            typeDeclaration.superclass = TypeConverter.createTypeReference(type.getSuperclassName().toCharArray(), type);
        }
        int interfaceCount = (interfaceNames = type.getSuperInterfaceNames()) == null ? 0 : interfaceNames.length;
        typeDeclaration.superInterfaces = new TypeReference[interfaceCount];
        for (int i = 0; i < interfaceCount; ++i) {
            typeDeclaration.superInterfaces[i] = TypeConverter.createTypeReference(interfaceNames[i].toCharArray(), type);
        }
        IType[] memberTypes = type.getTypes();
        int memberTypeCount = memberTypes == null ? 0 : memberTypes.length;
        typeDeclaration.memberTypes = new TypeDeclaration[memberTypeCount];
        for (int i = 0; i < memberTypeCount; ++i) {
            typeDeclaration.memberTypes[i] = alreadyComputedMember != null && alreadyComputedMember.getFullyQualifiedName().equals(memberTypes[i].getFullyQualifiedName()) ? alreadyComputedMemberDeclaration : TypeConverter.convert(memberTypes[i], null, null, compilationResult);
        }
        IField[] fields = type.getFields();
        int fieldCount = fields == null ? 0 : fields.length;
        typeDeclaration.fields = new FieldDeclaration[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            typeDeclaration.fields[i] = TypeConverter.convert(fields[i], type);
        }
        IMethod[] methods = type.getMethods();
        int methodCount = methods == null ? 0 : methods.length;
        int neededCount = 1;
        for (int i = 0; i < methodCount; ++i) {
            if (!methods[i].isConstructor()) continue;
            neededCount = 0;
            break;
        }
        neededCount = (isInterface = type.isInterface()) ? 0 : neededCount;
        typeDeclaration.methods = new AbstractMethodDeclaration[methodCount + neededCount];
        if (neededCount != 0) {
            typeDeclaration.methods[0] = typeDeclaration.createsInternalConstructor(false, false);
        }
        for (int i = 0; i < methodCount; ++i) {
            AbstractMethodDeclaration method = TypeConverter.convert(methods[i], type, compilationResult);
            if (isInterface || method.isAbstract()) {
                method.modifiers |= 0x1000000;
            }
            typeDeclaration.methods[neededCount + i] = method;
        }
        return typeDeclaration;
    }

    private static TypeReference createTypeReference(char[] type, IType contextType) {
        int max;
        try {
            String[][] resolvedName = contextType.resolveType(new String(type));
            if (resolvedName != null && resolvedName.length == 1) {
                type = CharOperation.concat(resolvedName[0][0].toCharArray(), resolvedName[0][1].toCharArray(), '.');
            }
        }
        catch (JavaModelException e) {
            // empty catch block
        }
        int dimStart = max = type.length;
        int dim = 0;
        int identCount = 1;
        block6: for (int i = 0; i < max; ++i) {
            switch (type[i]) {
                case '[': {
                    if (dim == 0) {
                        dimStart = i;
                    }
                    ++dim;
                    continue block6;
                }
                case '.': {
                    ++identCount;
                }
            }
        }
        if (identCount == 1) {
            if (dim == 0) {
                return new SingleTypeReference(type, 0L);
            }
            char[] identifier = new char[dimStart];
            System.arraycopy(type, 0, identifier, 0, dimStart);
            return new ArrayTypeReference(identifier, dim, 0L);
        }
        char[][] identifiers = CharOperation.splitOn('.', type, 0, dimStart);
        if (dim == 0) {
            return new QualifiedTypeReference(identifiers, new long[]{0L});
        }
        return new ArrayQualifiedTypeReference(identifiers, dim, new long[]{0L});
    }
}

