/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;

public class QualifiedTypeDeclarationPattern
extends TypeDeclarationPattern
implements IIndexConstants {
    protected char[] qualification;

    public QualifiedTypeDeclarationPattern(char[] qualification, char[] simpleName, char classOrInterface, int matchRule) {
        this(matchRule);
        this.qualification = this.isCaseSensitive() ? qualification : CharOperation.toLowerCase(qualification);
        this.simpleName = this.isCaseSensitive() ? simpleName : CharOperation.toLowerCase(simpleName);
        this.classOrInterface = classOrInterface;
        this.mustResolve = this.qualification != null;
    }

    QualifiedTypeDeclarationPattern(int matchRule) {
        super(matchRule);
    }

    public void decodeIndexKey(char[] key) {
        int slash = CharOperation.indexOf('/', key, 0);
        this.simpleName = CharOperation.subarray(key, 0, slash);
        int start = slash + 1;
        int secondSlash = CharOperation.indexOf('/', key, (slash = CharOperation.indexOf('/', key, start)) + 1);
        if (start + 1 == secondSlash) {
            this.qualification = CharOperation.NO_CHAR;
        } else if (slash + 1 == secondSlash) {
            this.qualification = CharOperation.subarray(key, start, slash);
        } else {
            this.qualification = CharOperation.subarray(key, start, secondSlash);
            this.qualification[slash - start] = 46;
        }
        this.classOrInterface = key[key.length - 1];
    }

    public SearchPattern getBlankPattern() {
        return new QualifiedTypeDeclarationPattern(8);
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        QualifiedTypeDeclarationPattern pattern = (QualifiedTypeDeclarationPattern)decodedPattern;
        switch (this.classOrInterface) {
            case 'C': 
            case 'I': {
                if (this.classOrInterface == pattern.classOrInterface) break;
                return false;
            }
        }
        return this.matchesName(this.simpleName, pattern.simpleName) && this.matchesName(this.qualification, pattern.qualification);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        switch (this.classOrInterface) {
            case 'C': {
                buffer.append("ClassDeclarationPattern: qualification<");
                break;
            }
            case 'I': {
                buffer.append("InterfaceDeclarationPattern: qualification<");
                break;
            }
            default: {
                buffer.append("TypeDeclarationPattern: qualification<");
            }
        }
        if (this.qualification != null) {
            buffer.append(this.qualification);
        } else {
            buffer.append("*");
        }
        buffer.append(">, type<");
        if (this.simpleName != null) {
            buffer.append(this.simpleName);
        } else {
            buffer.append("*");
        }
        buffer.append(">, ");
        switch (this.getMatchMode()) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive()) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }
}

