/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.taskdefs.optional.ide.VAJTask;
import org.apache.tools.ant.types.FileSet;

public class VAJImport
extends VAJTask {
    protected Vector filesets = new Vector();
    protected boolean importSources = true;
    protected boolean importResources = true;
    protected boolean importClasses = false;
    protected String importProject = null;
    protected boolean useDefaultExcludes = true;

    public void setProject(String projectName) {
        this.importProject = projectName;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setImportClasses(boolean importClasses) {
        this.importClasses = importClasses;
    }

    public void setImportResources(boolean importResources) {
        this.importResources = importResources;
    }

    public void setImportSources(boolean importSources) {
        this.importSources = importSources;
    }

    public void setDefaultexcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }

    public void execute() throws BuildException {
        if (this.filesets.size() == 0) {
            throw new BuildException("At least one fileset is required!");
        }
        if (this.importProject == null || "".equals(this.importProject)) {
            throw new BuildException("The VisualAge for Java Project name is required!");
        }
        try {
            Enumeration e = this.filesets.elements();
            while (e.hasMoreElements()) {
                this.importFileset((FileSet)e.nextElement());
            }
        }
        catch (BuildException ex) {
            if (this.haltOnError) {
                throw ex;
            }
            this.log(ex.toString());
        }
    }

    protected void importFileset(FileSet fileset) {
        LocalDirectoryScanner ds = new LocalDirectoryScanner();
        fileset.setupDirectoryScanner((FileScanner)ds, this.getProject());
        ds.scan();
        if (ds.getIncludedFiles().length == 0) {
            return;
        }
        String[] includes = ds.getIncludes();
        String[] excludes = ds.getExcludes();
        this.getUtil().importFiles(this.importProject, ds.getBasedir(), includes, excludes, this.importClasses, this.importResources, this.importSources, this.useDefaultExcludes);
    }

    private static class LocalDirectoryScanner
    extends DirectoryScanner {
        private LocalDirectoryScanner() {
        }

        public String[] getIncludes() {
            return this.includes;
        }

        public String[] getExcludes() {
            return this.excludes;
        }
    }
}

