/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.model;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.ant.internal.ui.editor.model.AntElementNode;
import org.eclipse.ant.internal.ui.editor.outline.XMLProblem;
import org.eclipse.ant.internal.ui.model.AntUIImages;
import org.eclipse.jface.resource.ImageDescriptor;

public class AntTaskNode
extends AntElementNode {
    private Task fTask = null;
    private String fLabel = null;
    private String fId = null;
    protected boolean configured = false;

    public AntTaskNode(Task task) {
        super(task.getTaskName());
        this.fTask = task;
    }

    public AntTaskNode(Task task, String label) {
        super(task.getTaskName());
        this.fTask = task;
        this.fLabel = label;
    }

    public String getLabel() {
        StringBuffer label = new StringBuffer();
        if (this.fLabel != null) {
            label.append(this.fLabel);
        } else if (this.fId != null) {
            label.append(this.fId);
        } else {
            label.append(this.fTask.getTaskName());
        }
        if (this.isExternal()) {
            this.appendEntityName(label);
        }
        return label.toString();
    }

    public void setLabel(String label) {
        this.fLabel = label;
    }

    public Task getTask() {
        return this.fTask;
    }

    public void setTask(Task task) {
        this.fTask = task;
    }

    protected ImageDescriptor getBaseImageDescriptor() {
        if (this.fId != null) {
            return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.type");
        }
        return super.getBaseImageDescriptor();
    }

    public void setId(String id) {
        this.fId = id;
    }

    public String getId() {
        return this.fId;
    }

    public boolean configure(boolean validateFully) {
        if (!validateFully || this.getParentNode() instanceof AntTaskNode) {
            return false;
        }
        if (this.configured) {
            return false;
        }
        try {
            this.getTask().maybeConfigure();
            this.nodeSpecificConfigure();
            this.configured = true;
            return true;
        }
        catch (BuildException be) {
            this.handleBuildException(be, "problem_tasks");
            return false;
        }
    }

    protected void nodeSpecificConfigure() {
    }

    protected void handleBuildException(BuildException be, String preferenceKey) {
        int severity = XMLProblem.getSeverity(preferenceKey);
        if (severity != -1) {
            this.getAntModel().handleBuildException(be, this, severity);
        }
    }
}

