/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.texteditor.AnnotationType;
import org.eclipse.ui.internal.texteditor.AnnotationTypeHierarchy;
import org.eclipse.ui.internal.texteditor.DelegatingAnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

public class AnnotationPreferenceLookup {
    private Map fFragments;

    public AnnotationPreference getAnnotationPreference(Annotation annotation) {
        return this.getAnnotationPreference(annotation.getType());
    }

    public AnnotationPreference getAnnotationPreference(String annotationType) {
        if (annotationType == null || annotationType == "org.eclipse.text.annotation.unknown") {
            return null;
        }
        AnnotationTypeHierarchy hierarchy = this.getAnnotationTypeHierarchy();
        AnnotationType type = hierarchy.getAnnotationType(annotationType);
        AnnotationPreference preference = type.getPreference();
        if (preference == null) {
            preference = new DelegatingAnnotationPreference(type, this);
            type.setAnnotationPreference(preference);
        }
        return preference;
    }

    public AnnotationPreference getAnnotationPreferenceFragment(String annotationType) {
        Map fragments = this.getPreferenceFragments();
        return (AnnotationPreference)fragments.get(annotationType);
    }

    private AnnotationTypeHierarchy getAnnotationTypeHierarchy() {
        return EditorsPlugin.getDefault().getAnnotationTypeHierarchy();
    }

    private Map getPreferenceFragments() {
        if (this.fFragments == null) {
            this.fFragments = new HashMap();
            MarkerAnnotationPreferences p = new MarkerAnnotationPreferences();
            Iterator e = p.getAnnotationPreferenceFragments().iterator();
            while (e.hasNext()) {
                AnnotationPreference fragment = (AnnotationPreference)e.next();
                Object annotationType = fragment.getAnnotationType();
                AnnotationPreference preference = (AnnotationPreference)this.fFragments.get(annotationType);
                if (preference == null) {
                    this.fFragments.put(annotationType, fragment);
                    continue;
                }
                preference.merge(fragment);
            }
        }
        return this.fFragments;
    }
}

