/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh2;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IConnectionMethod;
import org.eclipse.team.internal.ccvs.core.IServerConnection;
import org.eclipse.team.internal.ccvs.core.connection.CVSAuthenticationException;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ssh2.JSchSession;
import org.eclipse.team.internal.ccvs.ssh2.Policy;

public class PServerSSH2ServerConnection
implements IServerConnection {
    private ICVSRepositoryLocation location;
    private String password;
    private Session session;
    private static int localport = 2403;
    private IServerConnection psc = null;

    protected PServerSSH2ServerConnection(ICVSRepositoryLocation location, String password) {
        this.location = location;
        this.password = password;
    }

    public void close() throws IOException {
        this.psc.close();
    }

    public InputStream getInputStream() {
        return this.psc.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.psc.getOutputStream();
    }

    public void open(IProgressMonitor monitor) throws IOException, CVSAuthenticationException {
        String cvs_host;
        monitor.subTask("PServerSSH2ServerConnection.open");
        monitor.worked(1);
        String cvs_root = this.location.getRootDirectory();
        int cvs_port = this.location.getPort();
        if (cvs_port == 0) {
            cvs_port = 2401;
        }
        String ssh_host = cvs_host = this.location.getHost();
        String ssh_user = this.location.getUsername();
        String host = cvs_host;
        if (host.indexOf(64) != -1) {
            cvs_host = host.substring(host.lastIndexOf(64) + 1);
            if ((host = host.substring(0, host.lastIndexOf(64))).indexOf(64) != -1) {
                ssh_host = host.substring(host.lastIndexOf(64) + 1);
                if (ssh_host.length() == 0) {
                    ssh_host = cvs_host;
                }
                ssh_user = host.substring(0, host.lastIndexOf(64));
            } else {
                ssh_host = host;
            }
        }
        int ssh_port = 0;
        if (ssh_host.indexOf(35) != -1) {
            try {
                ssh_port = Integer.parseInt(ssh_host.substring(ssh_host.lastIndexOf(35) + 1));
                ssh_host = ssh_host.substring(0, ssh_host.lastIndexOf(35));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int lport = cvs_port;
        String rhost = cvs_host.equals(ssh_host) ? "localhost" : cvs_host;
        int rport = cvs_port;
        int retry = 1;
        while (true) {
            try {
                this.session = JSchSession.getSession(this.location, ssh_user, "", ssh_host, ssh_port, new JSchSession.ResponsiveSocketFacory(monitor));
                String[] list = this.session.getPortForwardingL();
                String name = ":" + rhost + ":" + rport;
                boolean done = false;
                for (int i = 0; i < list.length; ++i) {
                    if (!list[i].endsWith(name)) continue;
                    try {
                        String foo = list[i].substring(0, list[i].indexOf(58));
                        lport = Integer.parseInt(foo);
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                    done = true;
                    break;
                }
                if (done) break;
                lport = localport++;
                this.session.setPortForwardingL(lport, rhost, rport);
            }
            catch (JSchException ee) {
                if (--retry < 0) {
                    throw new CVSAuthenticationException(Policy.bind("CVSSSH2ServerConnection.3"), 2);
                }
                if (!this.session.isConnected()) continue;
                this.session.disconnect();
                continue;
            }
            break;
        }
        ((CVSRepositoryLocation)this.location).setPassword(this.password);
        try {
            Properties prop = new Properties();
            prop.put("connection", "pserver");
            prop.put("user", this.location.getUsername());
            prop.put("password", this.password);
            prop.put("host", "localhost");
            prop.put("port", Integer.toString(lport));
            prop.put("root", cvs_root);
            CVSRepositoryLocation cvsrl = CVSRepositoryLocation.fromProperties((Properties)prop);
            IConnectionMethod method = cvsrl.getMethod();
            this.psc = method.createConnection((ICVSRepositoryLocation)cvsrl, this.password);
        }
        catch (Exception e) {
            throw new CVSAuthenticationException(e.toString(), 2);
        }
        this.psc.open(monitor);
    }
}

