/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class ChooseWorkspaceDialog
extends TitleAreaDialog {
    private ChooseWorkspaceData launchData;
    private Combo text;
    private boolean suppressAskAgain = false;

    public ChooseWorkspaceDialog(Shell parentShell, ChooseWorkspaceData launchData, boolean suppressAskAgain) {
        super(parentShell);
        this.launchData = launchData;
        this.suppressAskAgain = suppressAskAgain;
    }

    public void prompt(boolean force) {
        if (force || this.launchData.getShowDialog()) {
            this.open();
            return;
        }
        String[] recent = this.launchData.getRecentWorkspaces();
        this.launchData.workspaceSelected(recent != null && recent.length > 0 ? recent[0] : this.launchData.getInitialDefault());
    }

    protected Control createDialogArea(Composite parent) {
        String productName = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            productName = product.getName();
        }
        if (productName == null) {
            productName = IDEWorkbenchMessages.getString("ChooseWorkspaceDialog.defaultProductName");
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setTitle(IDEWorkbenchMessages.getString("ChooseWorkspaceDialog.dialogTitle"));
        this.setMessage(IDEWorkbenchMessages.format("ChooseWorkspaceDialog.dialogMessage", new Object[]{productName}));
        if (this.getTitleImageLabel() != null) {
            this.getTitleImageLabel().setVisible(false);
        }
        this.createWorkspaceBrowseRow(composite);
        if (!this.suppressAskAgain) {
            this.createShowDialogButton(composite);
        }
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(IDEWorkbenchMessages.getString("ChooseWorkspaceDialog.dialogName"));
    }

    protected void okPressed() {
        this.launchData.workspaceSelected(this.text.getText());
        super.okPressed();
    }

    protected void cancelPressed() {
        this.launchData.workspaceSelected(null);
        super.cancelPressed();
    }

    private void createWorkspaceBrowseRow(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        panel.setFont(parent.getFont());
        Label label = new Label(panel, 0);
        label.setText(IDEWorkbenchMessages.getString("ChooseWorkspaceDialog.workspaceEntryLabel"));
        this.text = new Combo(panel, 18436);
        this.text.setLayoutData((Object)new GridData(768));
        this.setInitialTextValues(this.text);
        Button browseButton = new Button(panel, 8);
        browseButton.setText(IDEWorkbenchMessages.getString("ChooseWorkspaceDialog.browseLabel"));
        this.setButtonLayoutData(browseButton);
        GridData data = (GridData)browseButton.getLayoutData();
        data.horizontalAlignment = 128;
        browseButton.setLayoutData((Object)data);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ChooseWorkspaceDialog.this.getShell());
                dialog.setText(IDEWorkbenchMessages.getString("ChooseWorkspaceDialog.directoryBrowserTitle"));
                dialog.setMessage(IDEWorkbenchMessages.getString("ChooseWorkspaceDialog.directoryBrowserMessage"));
                dialog.setFilterPath(ChooseWorkspaceDialog.this.text.getText());
                String dir = dialog.open();
                if (dir != null) {
                    ChooseWorkspaceDialog.this.text.setText(dir);
                }
            }
        });
    }

    private void createShowDialogButton(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setFont(parent.getFont());
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        panel.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.verticalAlignment = 3;
        panel.setLayoutData((Object)data);
        Button button = new Button(panel, 32);
        button.setText(IDEWorkbenchMessages.getString("ChooseWorkspaceDialog.useDefaultMessage"));
        button.setSelection(!this.launchData.getShowDialog());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseWorkspaceDialog.this.launchData.toggleShowDialog();
            }
        });
    }

    private void setInitialTextValues(Combo text) {
        String[] recentWorkspaces = this.launchData.getRecentWorkspaces();
        for (int i = 0; i < recentWorkspaces.length; ++i) {
            if (recentWorkspaces[i] == null) continue;
            text.add(recentWorkspaces[i]);
        }
        text.setText(text.getItemCount() > 0 ? text.getItem(0) : this.launchData.getInitialDefault());
    }
}

