/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.MultiStepWizard;
import org.eclipse.ui.internal.ide.dialogs.WizardStep;
import org.eclipse.ui.internal.ide.misc.WizardStepGroup;

public class MultiStepReviewWizardPage
extends WizardPage {
    private Text detailsField;
    private Label instructionLabel;
    private WizardStepGroup stepGroup;
    private MultiStepWizard stepWizard;

    public MultiStepReviewWizardPage(String pageName, MultiStepWizard stepWizard) {
        super(pageName);
        this.stepWizard = stepWizard;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && !this.stepWizard.canFinishOnReviewPage();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.ui.ide.new_project_review_wizard_page_context");
        this.createStepGroup(composite);
        this.createDetailsGroup(composite);
        this.createInstructionsGroup(composite);
        this.setControl((Control)composite);
    }

    private void createDetailsGroup(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 16384);
        label.setText(IDEWorkbenchMessages.getString("MultiStepReviewWizardPage.detailsLabel"));
        GridData data = new GridData();
        data.verticalAlignment = 128;
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.detailsField = new Text(composite, 2626);
        this.detailsField.setText("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
        this.detailsField.setEditable(false);
        this.detailsField.setLayoutData((Object)new GridData(1808));
        this.detailsField.setFont(font);
    }

    private void createInstructionsGroup(Composite parent) {
        this.instructionLabel = new Label(parent, 16384);
        this.instructionLabel.setText(IDEWorkbenchMessages.getString("MultiStepReviewWizardPage.instructionFinishLabel"));
        GridData data = new GridData();
        data.verticalAlignment = 128;
        data.horizontalSpan = 2;
        this.instructionLabel.setLayoutData((Object)data);
        this.instructionLabel.setFont(parent.getFont());
    }

    private void createStepGroup(Composite parent) {
        this.stepGroup = new WizardStepGroup();
        this.stepGroup.createContents(parent);
        this.stepGroup.setSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel;
                WizardStep step;
                if (event.getSelection() instanceof IStructuredSelection && (step = (WizardStep)(sel = (IStructuredSelection)event.getSelection()).getFirstElement()) != null) {
                    MultiStepReviewWizardPage.this.detailsField.setText(step.getDetails());
                }
            }
        });
    }

    WizardStep[] getSteps() {
        if (this.stepGroup != null) {
            return this.stepGroup.getSteps();
        }
        return new WizardStep[0];
    }

    void setSteps(WizardStep[] steps) {
        if (this.stepGroup != null) {
            this.stepGroup.setSteps(steps);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.stepWizard.canFinishOnReviewPage()) {
                this.instructionLabel.setText(IDEWorkbenchMessages.getString("MultiStepReviewWizardPage.instructionFinishLabel"));
            } else {
                this.instructionLabel.setText(IDEWorkbenchMessages.getString("MultiStepReviewWizardPage.instructionNextLabel"));
            }
            ((Composite)this.getControl()).layout(true);
        }
    }
}

