/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ICapabilityUninstallWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class RemoveCapabilityWizard
extends Wizard
implements ICapabilityUninstallWizard {
    private IProject project;
    private String[] natureIds;

    RemoveCapabilityWizard() {
    }

    public void init(IWorkbench workbench, IStructuredSelection selection, IProject project, String[] natureIds) {
        this.project = project;
        this.natureIds = natureIds;
    }

    public boolean performFinish() {
        return this.updateNatures();
    }

    private boolean updateNatures() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    IProjectDescription description = RemoveCapabilityWizard.this.project.getDescription();
                    String[] oldIds = description.getNatureIds();
                    ArrayList<String> newIds = new ArrayList<String>(oldIds.length);
                    for (int i = 0; i < oldIds.length; ++i) {
                        boolean keepNature = true;
                        for (int j = 0; j < RemoveCapabilityWizard.this.natureIds.length; ++j) {
                            if (!RemoveCapabilityWizard.this.natureIds[j].equals(oldIds[i])) continue;
                            keepNature = false;
                            break;
                        }
                        if (!keepNature) continue;
                        newIds.add(oldIds[i]);
                    }
                    String[] results = new String[newIds.size()];
                    newIds.toArray(results);
                    description.setNatureIds(results);
                    RemoveCapabilityWizard.this.project.setDescription(description, monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.getString("RemoveCapabilityWizard.errorMessage"), null, (IStatus)((CoreException)t).getStatus());
            } else {
                Platform.getPlugin((String)"org.eclipse.ui").getLog().log((IStatus)new Status(4, "org.eclipse.ui", 0, t.toString(), t));
                MessageDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.getString("RemoveCapabilityWizard.errorMessage"), (String)IDEWorkbenchMessages.format("RemoveCapabilityWizard.internalError", new Object[]{t.getMessage()}));
            }
            return false;
        }
        return true;
    }
}

