#!/bin/csh
#**********************************************************************
# Copyright (c) 2002, 2004 IBM Corp. and others.  All rights reserved.
# This file is made available under the terms of the Common Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/cpl-v10.html
#   
# Contributors: 
#     Kevin Cornell (Rational Software Corporation)
#********************************************************************** 
#
# Usage: csh build.csh [<optional switches>] [clean]
#
#   where the optional switches are:
#       -output <PROGRAM_OUTPUT>  - executable filename ("eclipse")
#       -name   <PROGRAM_NAME>    - title of launcher   ("Eclipse")
#       -os     <DEFAULT_OS>      - default Eclipse "-os" value (linux) 
#       -arch   <DEFAULT_OS_ARCH> - default Eclipse "-arch" value (x86) 
#       -ws     <DEFAULT_WS>      - default Eclipse "-ws" value (gtk) 
#
#
#    This script can also be invoked with the "clean" argument.

# Make sure the script is executing in the directory where the source
# exists (assume this script file has not been copied elsewhere).
cd `dirname $0`

# Define default values for environment variables used in the makefiles.
set programOutput = "eclipse"
set programName   = "Eclipse"
set defaultOS     = "macosx"
set defaultOSArch = "ppc"
set defaultWS     = "carbon"
set makefile      = "make_carbon.mak"
set OS            = `uname -s`


# Parse the command line arguments and override the default values.
set extraArgs     = ""
while ("$1" != "")
    if ( "$1" == "-os" && "$2" != "" ) then
        set defaultOS = "$2"
        shift
    else if ( "$1" == "-arch" && "$2" != "" ) then
        set defaultOSArch = "$2"
        shift
    else if ( "$1" == "-ws" && "$2" != "" ) then
        set defaultWS = "$2"
        shift
    else if ( "$1" == "-output" && "$2" != "" ) then
        set programOutput = "$2"
        shift
    else if ( "$1" == "-name" && "$2" != "" ) then
        set programName = "$2"
        shift
    else
        set extraArgs = "$extraArgs $1"
    endif
    shift
end

# Set up environment variables needed by the makefiles.
setenv PROGRAM_OUTPUT  "$programOutput"
setenv PROGRAM_NAME    "$programName"
setenv DEFAULT_OS      "$defaultOS"
setenv DEFAULT_OS_ARCH "$defaultOSArch"
setenv DEFAULT_WS      "$defaultWS"

# If the OS is supported (a makefile exists)
if ("$makefile" != "") then
    if ("$extraArgs" != "") then
        make -f $makefile $extraArgs
    else
        echo "Building $OS launcher. Defaults: -os $DEFAULT_OS -arch $DEFAULT_OS_ARCH -ws $DEFAULT_WS"
        make -f $makefile clean
        make -f $makefile all
    endif
else
    echo "Unknown OS ($OS) -- build aborted"
endif
