#*******************************************************************************
# Copyright (c) 2000, 2004 IBM Corporation and others.
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Common Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/cpl-v10.html
# 
# Contributors:
#     IBM Corporation - initial API and implementation
#     Kevin Cornell (Rational Software Corporation)
#*******************************************************************************
 
# Makefile for creating the eclipse launcher program.

# This script expects the following environment variables set:
#
# PROGRAM_OUTPUT - the filename of the output executable
# PROGRAM_NAME - the title of the splash screen

# Define the installation directories for various products.
#    MOTIF_HOME - Motif include and libraries if not the same as X11_HOME
MOTIF_HOME = /usr/include

# Define the object modules to be compiled and flags.
OBJS = eclipse.o eclipseUtil.o eclipseShm.o eclipseMotif.o \
       NgCommon.o NgImage.o NgImageData.o NgWinBMPFileFormat.o
EXEC = $(PROGRAM_OUTPUT)
LIBS = -L$(MOTIF_HOME)/lib -lXm -lXt -lX11
CFLAGS = -O -s \
	-DPROGRAM_NAME="\"$(PROGRAM_NAME)\"" \
	-DDEFAULT_OS="\"$(DEFAULT_OS)\"" \
	-DDEFAULT_OS_ARCH="\"$(DEFAULT_OS_ARCH)\"" \
	-DDEFAULT_WS="\"$(DEFAULT_WS)\"" \
    -DAIX \
	-I./ \
	-I../ \
	-I$(MOTIF_HOME)/include

all: $(EXEC)

.c.o:
	$(CC) $(CFLAGS) -c $< -o $@

eclipse.o: ../eclipse.c
	$(CC) $(CFLAGS) -c $< -o $@

eclipseUtil.o: ../eclipseUtil.c
	$(CC) $(CFLAGS) -c $< -o $@

eclipseShm.o: ../eclipseShm.c
	$(CC) $(CFLAGS) -c $< -o $@

$(EXEC): $(OBJS)
	$(CC) -o $(EXEC) $(OBJS) $(LIBS)

clean:
	rm -f $(EXEC) $(OBJS)
