/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.Rule;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

public class TaskReportRenderer
extends TextReportRenderer {
    private boolean currentProjectHasTasks;
    private boolean currentProjectHasRules;
    private boolean hasContent;
    private boolean detail;

    @Override
    public void startProject(Project project) {
        this.currentProjectHasTasks = false;
        this.currentProjectHasRules = false;
        this.hasContent = false;
        this.detail = false;
        super.startProject(project);
    }

    @Override
    protected String createHeader(Project project) {
        String header = super.createHeader(project);
        return "All tasks runnable from " + StringUtils.uncapitalize((String)header);
    }

    public void showDetail(boolean detail) {
        this.detail = detail;
    }

    public void addDefaultTasks(List<String> defaultTaskNames) {
        if (defaultTaskNames.size() > 0) {
            this.getTextOutput().formatln("Default tasks: %s", new Object[]{CollectionUtils.join((String)", ", defaultTaskNames)});
            this.hasContent = true;
        }
    }

    public void startTaskGroup(String taskGroup) {
        if (!GUtil.isTrue((Object)taskGroup)) {
            this.addSubheading("Tasks");
        } else {
            this.addSubheading(StringUtils.capitalize((String)taskGroup) + " tasks");
        }
        this.currentProjectHasTasks = true;
    }

    public void addTask(TaskDetails task) {
        this.writeTask(task, "");
    }

    private void writeTask(TaskDetails task, String prefix) {
        this.getTextOutput().text((Object)prefix);
        this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)task.getPath());
        if (GUtil.isTrue((Object)task.getDescription())) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Description).format(" - %s", new Object[]{task.getDescription()});
        }
        this.getTextOutput().println();
    }

    private void addSubheading(String header) {
        if (this.hasContent) {
            this.getTextOutput().println();
        }
        this.hasContent = true;
        this.getBuilder().subheading(header);
    }

    public void completeTasks() {
        if (!this.currentProjectHasTasks) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"No tasks");
            this.hasContent = true;
        }
    }

    public void addRule(Rule rule) {
        if (!this.currentProjectHasRules) {
            this.addSubheading("Rules");
        }
        this.getTextOutput().println(GUtil.elvis((Object)rule.getDescription(), (Object)""));
        this.currentProjectHasRules = true;
    }

    @Override
    public void complete() {
        if (!this.detail) {
            StyledTextOutput output = this.getTextOutput();
            BuildClientMetaData clientMetaData = this.getClientMetaData();
            output.println();
            output.text((Object)"To see all tasks and more detail, run ");
            clientMetaData.describeCommand((Appendable)output.withStyle(StyledTextOutput.Style.UserInput), new String[]{"tasks --all"});
            output.println();
            output.println();
            output.text((Object)"To see more detail about a task, run ");
            clientMetaData.describeCommand((Appendable)output.withStyle(StyledTextOutput.Style.UserInput), new String[]{"help --task <task>"});
            output.println();
        }
        super.complete();
    }
}

