/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.navigation;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.components.JGTextField;
import com.jgoodies.fluent.FluentLayouts;
import com.jgoodies.fluent.Theme;
import com.jgoodies.fluent.internal.FluentButtonFactory;
import com.jgoodies.fluent.internal.FluentResources;
import com.jgoodies.fluent.internal.IFluentResources;
import com.jgoodies.fluent.internal.ILeftPad;
import com.jgoodies.fluent.internal.UnmodifiablePanel;
import com.jgoodies.fluent.navigation.BackButton;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.factories.Forms;
import com.jgoodies.navigation.IAppBar;
import com.jgoodies.navigation.Page;
import com.jgoodies.navigation.PageModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JTextField;

public final class NavigationBar
extends UnmodifiablePanel
implements IAppBar,
ILeftPad {
    public static final String PROPERTY_LEFT_PAD = "leftPad";
    private final IFluentResources fluentResources;
    private final FluentButtonFactory buttonFactory;
    private final PageModel pageModel;
    private final PropertyChangeListener pageDisplayStringListener;
    private final BackButton backButton;
    private boolean initialDisplayStringHidden = false;
    private int leftPad = FluentLayouts.LEFT_PAD_DEFAULT;
    private JTextField displayStringField;
    private JMenu menu;
    private JButton menuButton;

    public NavigationBar(PageModel pageModel) {
        this(pageModel, null);
    }

    public NavigationBar(PageModel pageModel, Theme theme) {
        this.fluentResources = FluentResources.getInstance();
        this.buttonFactory = new FluentButtonFactory(theme);
        this.pageModel = Preconditions.checkNotNull(pageModel, "The %s must not be null.", "page model");
        this.backButton = new BackButton(pageModel);
        this.backButton.setVisible(false);
        this.pageDisplayStringListener = this::onCurrentPageDisplayStringChanged;
        this.setBackground(this.getTheme().background());
        this.initComponents();
        this.initEventHandling();
    }

    private void initComponents() {
        this.displayStringField = this.createDisplayStringField();
    }

    private void initEventHandling() {
        this.pageModel.addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "canGoBack": {
                    this.onCanGoBackChanged(evt);
                    break;
                }
                case "currentPage": {
                    this.onCurrentPageChanged(evt);
                    break;
                }
            }
        });
        this.updateBackVisibility();
        this.updateCurrentPageVisibility();
        this.updateCurrentPageText();
        Page currentPage = this.pageModel.getCurrentPage();
        if (currentPage instanceof Bean) {
            ((Bean)((Object)currentPage)).addPropertyChangeListener(this.pageDisplayStringListener);
        }
    }

    public Theme getTheme() {
        return this.buttonFactory.getTheme();
    }

    public boolean isBackButtonVisible() {
        return this.backButton.isVisible();
    }

    public void setBackButtonVisible(boolean b) {
        this.backButton.setVisible(b);
        this.updateBackVisibility();
    }

    public boolean isInitialDisplayStringHidden() {
        return this.initialDisplayStringHidden;
    }

    public void setInitialDisplayStringHidden(boolean b) {
        this.initialDisplayStringHidden = b;
        this.updateCurrentPageVisibility();
    }

    @Override
    public int getLeftPad() {
        return this.leftPad;
    }

    @Override
    public void setLeftPad(int padEpx) {
        Preconditions.checkArgument(padEpx >= 0, "The left pad must not be negative.");
        this.leftPad = padEpx;
        this.firePropertyChange(PROPERTY_LEFT_PAD, this.leftPad, this.leftPad);
    }

    @Override
    public void setLocation(IAppBar.Location location) {
    }

    public JMenu getMenu() {
        return this.menu;
    }

    public void setMenu(JMenu menu) {
        this.menu = menu;
        this.menuButton = menu == null ? null : this.createMenuButton();
    }

    @Override
    public JComponent buildPanel() {
        JComponent paddedDisplayString = Forms.paddedGrow(this.displayStringField, "0, 0, 1epx, 0", new Object[0]);
        JComponent paddedMenuButton = this.menuButton == null ? null : Forms.paddedGrow(this.menuButton, "0, 0, 1epx, 0", new Object[0]);
        FormBuilder builder = (FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("[%sepx, pref], 0, pref, 0, pref", this.getLeftPad())).rows("f:48epx", new Object[0])).background(this.getTheme().background())).add(this.backButton.getComponent()).xy(1, 1)).add(paddedDisplayString).xy(3, 1)).add(paddedMenuButton).xy(5, 1);
        return builder.build();
    }

    private JTextField createDisplayStringField() {
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        JGTextField field = factory.createReadOnlyTextField();
        field.setFont(this.fluentResources.getAppBarTitleFont());
        field.setForeground(this.getTheme().selectedForeground());
        return field;
    }

    private JButton createMenuButton() {
        JButton button = this.buttonFactory.createMenuButton(this.menu);
        button.setName("menu_button");
        button.setFont(this.fluentResources.getAppBarTitleFont());
        return button;
    }

    private void onCurrentPageChanged(PropertyChangeEvent evt) {
        Page newPage;
        Page oldPage = (Page)evt.getOldValue();
        if (oldPage instanceof Bean) {
            ((Bean)((Object)oldPage)).removePropertyChangeListener(this.pageDisplayStringListener);
        }
        if ((newPage = (Page)evt.getNewValue()) instanceof Bean) {
            ((Bean)((Object)newPage)).addPropertyChangeListener(this.pageDisplayStringListener);
        }
        this.updateCurrentPageText();
    }

    private void onCurrentPageDisplayStringChanged(PropertyChangeEvent evt) {
        this.updateCurrentPageText();
    }

    private void onCanGoBackChanged(PropertyChangeEvent evt) {
        this.updateBackVisibility();
        this.updateCurrentPageVisibility();
    }

    private void updateBackVisibility() {
        this.backButton.setVisible(this.isBackButtonVisible() && this.pageModel.canGoBack());
    }

    private void updateCurrentPageText() {
        this.displayStringField.setText(NavigationBar.getCurrentPageText(this.pageModel));
    }

    private void updateCurrentPageVisibility() {
        this.displayStringField.setVisible(!this.initialDisplayStringHidden || this.pageModel.canGoBack());
    }

    private static String getCurrentPageText(PageModel pageModel) {
        Page page = pageModel.getCurrentPage();
        if (page == null) {
            return null;
        }
        String pageName = page.getDisplayString();
        if (Strings.isNotBlank(pageName)) {
            return pageName;
        }
        return null;
    }

    public static final class Builder {
        private PageModel pageModel;
        private Theme theme;
        private JMenu menu;
        private boolean backButtonVisible = false;
        private boolean initialDisplayStringHidden = false;
        private int leftPad = -1;

        public Builder pageModel(PageModel pageModel) {
            this.pageModel = pageModel;
            return this;
        }

        public Builder theme(Theme theme) {
            this.theme = theme;
            return this;
        }

        public Builder backButtonVisible(boolean visible) {
            this.backButtonVisible = visible;
            return this;
        }

        public Builder backButtonVisible() {
            return this.backButtonVisible(true);
        }

        public Builder backButtonHidden() {
            return this.backButtonVisible(false);
        }

        public Builder initialDisplayStringHidden(boolean hidden) {
            this.initialDisplayStringHidden = hidden;
            return this;
        }

        public Builder leftPad(int padEpx) {
            this.leftPad = padEpx;
            return this;
        }

        public Builder menu(JMenu menu) {
            this.menu = menu;
            return this;
        }

        public NavigationBar build() {
            NavigationBar bar = new NavigationBar(this.pageModel, this.theme);
            bar.setMenu(this.menu);
            bar.setBackButtonVisible(this.backButtonVisible);
            bar.setInitialDisplayStringHidden(this.initialDisplayStringHidden);
            if (this.leftPad != -1) {
                bar.setLeftPad(this.leftPad);
            }
            return bar;
        }

        public JComponent buildPanel() {
            return this.build().buildPanel();
        }
    }
}

