/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.components.TextComponent;
import net.yura.mobile.logging.Logger;

public class TextField
extends TextComponent {
    private int offset;
    private ActionListener al;
    private String action;

    public TextField() {
        this(0);
    }

    public TextField(int constraints) {
        super("", 100, constraints);
        this.offset = this.padding;
        this.workoutPreferredSize();
    }

    public void paintComponent(Graphics2D g) {
        int f = this.getForeground();
        if (!Graphics2D.isTransparent(f)) {
            String textString = this.getDisplayString();
            int[] oldClip = g.getClip();
            g.clipRect(0, 0, this.width, this.height);
            g.setColor(f);
            g.setFont(this.font);
            g.drawString(textString, this.offset, (this.height - this.font.getHeight()) / 2);
            if (this.showCaret) {
                int x = this.font.getWidth(textString.substring(0, this.caretPosition));
                g.drawLine(this.offset + x, this.padding, this.offset + x, this.height - this.padding - 1);
            }
            g.setClip(oldClip);
        }
    }

    public void processMouseEvent(int type, int x, int y, KeyEvent keys) {
        super.processMouseEvent(type, x, y, keys);
        if (this.focusable) {
            String txt = this.getDisplayString() + " ";
            int mid = TextField.searchStringCharOffset(txt, this.font, x - this.offset);
            this.setCaretPosition(mid);
        }
    }

    public void focusGained() {
        super.focusGained();
        this.setCaretPosition(this.getCaretPosition());
    }

    public void setCaretPosition(int a) {
        super.setCaretPosition(a);
        if (this.isFocusOwner()) {
            int extraSpace = 10;
            String s = this.getDisplayString();
            int x = this.font.getWidth(s.substring(0, this.caretPosition));
            int fw = this.font.getWidth(s) + extraSpace;
            if (x > -this.offset + this.width - this.padding - extraSpace) {
                this.offset = -x + this.width * 2 / 3;
            } else if (x < -this.offset + this.padding) {
                this.offset = -x + this.width / 3;
            }
            if (-this.offset + this.width - this.padding > fw) {
                this.offset = this.width - this.padding - fw;
            }
            if (this.offset > this.padding) {
                this.offset = this.padding;
            }
            this.repaint();
        }
    }

    protected void workoutMinimumSize() {
        this.width = 10;
        this.height = this.font.getHeight() + this.padding * 2;
    }

    public String getDefaultName() {
        return "TextField";
    }

    public boolean allowChar(char keyCode) {
        if (keyCode == '\t') {
            return false;
        }
        if (keyCode == '\n') {
            if (this.al != null) {
                this.al.actionPerformed(this.action);
            } else {
                this.transferFocus(6);
            }
            return false;
        }
        return super.allowChar(keyCode);
    }

    public void addActionListener(ActionListener al) {
        if (this.al != null) {
            Logger.warn("trying to add a ActionListener when there is already one registered " + this);
            Logger.dumpStack();
        }
        if (al == null) {
            Logger.warn("trying to add a null ActionListener " + this);
            Logger.dumpStack();
        }
        this.al = al;
    }

    public void setActionCommand(String action) {
        this.action = action;
    }

    public String getActionCommand() {
        return this.action;
    }

    public ActionListener[] getActionListeners() {
        ActionListener[] actionListenerArray;
        if (this.al == null) {
            actionListenerArray = new ActionListener[]{};
        } else {
            ActionListener[] actionListenerArray2 = new ActionListener[1];
            actionListenerArray = actionListenerArray2;
            actionListenerArray2[0] = this.al;
        }
        return actionListenerArray;
    }
}

