/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.net.MalformedURLException;
import java.net.URL;
import tim.prune.I18nManager;
import tim.prune.gui.map.MapLayer;

public abstract class MapSource {
    private final String _name;
    private final MapLayer[] _layers = new MapLayer[2];

    protected MapSource(String string) {
        String string2 = string;
        if (string2 == null || string2.trim().equals("")) {
            string2 = I18nManager.getText("mapsource.unknown");
        }
        this._name = string2;
    }

    public String getName() {
        return this._name;
    }

    public int getNumLayers() {
        return (this._layers[0] == null ? 0 : 1) + (this._layers[1] == null ? 0 : 1);
    }

    public String getBaseUrl(int n) {
        if (n < 0 || n >= this.getNumLayers()) {
            return "";
        }
        return this._layers[n].getBaseUrl();
    }

    public String getSiteName(int n) {
        if (n < 0 || n >= this.getNumLayers()) {
            return "";
        }
        return this._layers[n].getSiteName();
    }

    public final String getFileExtension(int n) {
        if (n < 0 || n >= this.getNumLayers()) {
            return "";
        }
        return this._layers[n].getExtension();
    }

    protected void addLayer(String string, String string2) {
        if (string != null) {
            this._layers[this.getNumLayers()] = new MapLayer(string, string2);
        }
    }

    public abstract String makeURL(int var1, int var2, int var3, int var4);

    public abstract int getMaxZoomLevel();

    public String makeFilePath(int n, int n2, int n3, int n4) {
        return String.valueOf(this.getSiteName(n)) + n2 + "/" + n3 + "/" + n4 + "." + this.getFileExtension(n);
    }

    public static String fixBaseUrl(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        String string2 = string;
        URL uRL = null;
        try {
            uRL = new URL(string2.replace('[', 'w').replace(']', 'w'));
        }
        catch (MalformedURLException malformedURLException) {
            if (string2.contains("://")) {
                return null;
            }
            string2 = "http://" + string2;
            try {
                uRL = new URL(string2.replace('[', 'w').replace(']', 'w'));
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
        if (uRL.getHost().indexOf(46) < 0 || uRL.getHost().contains("..") || !MapSource.placeHoldersOk(uRL.getPath())) {
            return null;
        }
        if (string2.indexOf(123) < 0 && !string2.endsWith("/")) {
            string2 = String.valueOf(string2) + "/";
        }
        return string2;
    }

    private static boolean placeHoldersOk(String string) {
        if (string.indexOf(123) < 0 && string.indexOf(125) < 0) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (bl2) {
                if (c != '}') {
                    return false;
                }
                bl2 = false;
            } else if (bl) {
                switch (c) {
                    case 'x': {
                        bl3 = true;
                        break;
                    }
                    case 'y': {
                        bl4 = true;
                        break;
                    }
                    case 'z': {
                        bl5 = true;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                bl = false;
                bl2 = true;
            } else if (c == '{') {
                bl = true;
            } else if (c == '}') {
                return false;
            }
            ++n2;
        }
        return bl3 && bl4 && bl5;
    }

    public abstract String getConfigString();

    public String getSiteStrings() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.getNumLayers()) {
            String string = this.getBaseUrl(n);
            if (string != null) {
                stringBuilder.append(string);
                stringBuilder.append(';');
                stringBuilder.append(this.getFileExtension(n));
                stringBuilder.append(';');
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public void setDoubleRes(int n) {
        if (n < 0 || n >= this.getNumLayers()) {
            return;
        }
        this._layers[n].setDoubleRes();
    }

    public boolean isDoubleRes(int n) {
        return n >= 0 && n < this.getNumLayers() && this._layers[n].isDoubleRes();
    }
}

