/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.lang.ref.WeakReference;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import moulserver.Comm;
import moulserver.ConnectionState;
import moulserver.GameServer;
import moulserver.Manager;
import moulserver.Server;
import prpobjects.Guid;
import prpobjects.PrpTaggedObject;
import prpobjects.Typeid;
import prpobjects.uruobj;
import shared.ByteArrayBytestream;
import shared.Concurrent;
import shared.Format;
import shared.IBytedeque;
import shared.IBytestream;
import shared.b;
import shared.m;
import shared.uncaughtexception;
import uru.Bytedeque;
import uru.context;

public class GameMainServer
extends Thread {
    public static final int kCli2Game_PingRequest = 0;
    public static final int kCli2Game_JoinAgeRequest = 1;
    public static final int kCli2Game_PropagateBuffer = 2;
    public static final int kCli2Game_GameMgrMsg = 3;
    public static final int kCli2Game_LastMessage = 4;
    public static final int kGame2Cli_PingReply = 0;
    public static final int kGame2Cli_JoinAgeReply = 1;
    public static final int kGame2Cli_PropagateBuffer = 2;
    public static final int kGame2Cli_GameMgrMsg = 3;
    public static final int kGame2Cli_LastMessage = 4;
    Manager manager;
    Queue<Comm.CommItem> items = Concurrent.getConcurrentQueue();
    private AtomicInteger nextGameServerNum = new AtomicInteger();
    ConcurrentHashMap<Guid, GameServer> gameservers = Concurrent.getConcurrentHashMap();
    ConcurrentHashMap<Integer, GameServer> players = Concurrent.getConcurrentHashMap();

    public GameMainServer(Manager manager) {
        this.manager = manager;
    }

    public void run() {
        m.msg("Starting GameMainServer...");
        while (true) {
            Comm.CommItem item;
            if ((item = this.items.poll()) != null) {
                if (item.type == Comm.CommItemType.HandleMessage) {
                    this.HandleMessage(item);
                    continue;
                }
                m.throwUncaughtException("unhandled");
                continue;
            }
            try {
                Thread.sleep(4L);
            }
            catch (Exception exception) {
            }
        }
    }

    public synchronized GameServer requestGameserverFromGuid(Guid instanceGuid, String ageFilename, int playerIdx) {
        GameServer gameserver = this.gameservers.get(instanceGuid);
        if (gameserver == null) {
            int nextnum = this.nextGameServerNum.incrementAndGet();
            gameserver = new GameServer(nextnum, ageFilename, instanceGuid, this.manager);
            gameserver.start();
            this.gameservers.put(instanceGuid, gameserver);
        }
        gameserver.expectPlayer(playerIdx);
        this.players.put(playerIdx, gameserver);
        return gameserver;
    }

    public static GameMsg ReadMessage(IBytestream c, boolean isServer) {
        short msgId = c.readShort();
        if (isServer) {
            switch (msgId) {
                case 1: {
                    return new JoinAgeRequest(c);
                }
                case 2: {
                    return new PropagateBuffer(c);
                }
            }
            throw new uncaughtexception("Unread GameMainServer packet: " + Short.toString(msgId));
        }
        switch (msgId) {
            case 1: {
                return new JoinAgeReply(c);
            }
            case 2: {
                return new PropagateBuffer(c);
            }
        }
        throw new uncaughtexception("Unread GameMainServer packet: " + Short.toString(msgId));
    }

    public void HandleMessageDirect(Comm.CommItem item) {
        this.HandleMessage(item);
    }

    private void HandleMessage(Comm.CommItem item) {
        GameServer gameserver;
        Server.ServerMsg msg = item.msg;
        Class<?> klass = msg.getClass();
        ConnectionState cs = item.connstate;
        if (klass == JoinAgeRequest.class) {
            m.msg("GameMainServer JoinAgeRequest");
            JoinAgeRequest request = (JoinAgeRequest)msg;
            cs.playerId = request.playerIdx;
        }
        if (item.connstate.currentGameServer == null) {
            if (cs.playerId == null) {
                m.err("Player doesn't have a GameServer assigned, because they haven't done a JoinAgeRequest.");
                return;
            }
            gameserver = this.players.get(item.connstate.playerId);
            item.connstate.currentGameServer = new WeakReference<GameServer>(gameserver);
        }
        if ((gameserver = (GameServer)item.connstate.currentGameServer.get()) == null) {
            m.err("GameServer seems to have died.");
        } else {
            gameserver.items.add(item);
        }
    }

    static void SendMsg(ConnectionState cs, GameMsg msg) {
        Bytedeque c = new Bytedeque(Format.moul);
        c.writeShort(msg.type());
        msg.write(c);
        byte[] data = c.getAllBytes();
        cs.sendMsgBytes(data);
    }

    public static abstract class GameMsg
    extends Server.ServerMsg {
        public abstract short type();

        public byte[] GetMsgBytes() {
            Bytedeque c = new Bytedeque(Format.moul);
            ((IBytedeque)c).writeShort(this.type());
            this.write(c);
            byte[] data = ((IBytedeque)c).getAllBytes();
            return data;
        }
    }

    public static class JoinAgeRequest
    extends GameMsg {
        int transId;
        int ageMcpId;
        Guid accountGuid;
        int playerIdx;

        public JoinAgeRequest(IBytestream c) {
            this.transId = c.readInt();
            this.ageMcpId = c.readInt();
            this.accountGuid = new Guid(c);
            this.playerIdx = c.readInt();
        }

        public JoinAgeRequest() {
        }

        public short type() {
            return 1;
        }

        public Integer transid() {
            return this.transId;
        }

        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.ageMcpId);
            this.accountGuid.write(c);
            c.writeInt(this.playerIdx);
        }
    }

    public static class JoinAgeReply
    extends GameMsg {
        int transId;
        int result;

        public JoinAgeReply() {
        }

        public JoinAgeReply(IBytestream c) {
            this.transId = c.readInt();
            this.result = c.readInt();
        }

        public short type() {
            return 1;
        }

        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.result);
        }
    }

    public static class PropagateBuffer
    extends GameMsg {
        int messageType;
        int size;
        byte[] data;
        PrpTaggedObject obj;

        public PropagateBuffer(IBytestream c) {
            this.messageType = c.readInt();
            this.size = c.readInt();
            this.data = c.readBytes(this.size);
            this.parse();
        }

        public PropagateBuffer() {
        }

        public short type() {
            return 2;
        }

        public void write(IBytedeque c) {
            c.writeInt(this.messageType);
            c.writeInt(this.data.length);
            c.writeBytes(this.data);
        }

        public void parse() {
            ByteArrayBytestream stream = ByteArrayBytestream.createFromByteArray(this.data);
            context ctxt = context.createFromBytestream(stream);
            ctxt.readversion = 6;
            try {
                this.obj = new PrpTaggedObject(ctxt);
                if (ctxt.in.getBytesRemaining() != 0) {
                    m.throwUncaughtException("did not read all");
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                m.throwUncaughtException("error reading object.");
            }
        }

        public static PropagateBuffer createWithObj(PrpTaggedObject obj) {
            PropagateBuffer r = new PropagateBuffer();
            r.messageType = b.Int16ToInt32(obj.type.getAsShort(Format.moul));
            r.data = obj.compileAlone(Format.moul);
            return r;
        }

        public static PropagateBuffer createWithObj(Typeid type, uruobj obj2) {
            PrpTaggedObject obj = PrpTaggedObject.createWithTypeidUruobj(type, obj2);
            return PropagateBuffer.createWithObj(obj);
        }

        public String dump() {
            return super.dump() + " : " + this.obj.dump();
        }
    }
}

