/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.nio.ChannelEndPoint;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.nio.AbstractNIOConnector;
import org.eclipse.jetty.util.log.Log;

public class BlockingChannelConnector
extends AbstractNIOConnector {
    private transient ServerSocketChannel _acceptChannel;

    public Object getConnection() {
        return this._acceptChannel;
    }

    public void open() throws IOException {
        this._acceptChannel = ServerSocketChannel.open();
        this._acceptChannel.configureBlocking(true);
        InetSocketAddress addr = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
        this._acceptChannel.socket().bind(addr, this.getAcceptQueueSize());
    }

    public void close() throws IOException {
        if (this._acceptChannel != null) {
            this._acceptChannel.close();
        }
        this._acceptChannel = null;
    }

    public void accept(int acceptorID) throws IOException, InterruptedException {
        SocketChannel channel = this._acceptChannel.accept();
        channel.configureBlocking(true);
        Socket socket = channel.socket();
        this.configure(socket);
        ConnectorEndPoint connection = new ConnectorEndPoint(channel);
        connection.dispatch();
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        endpoint.setMaxIdleTime(this._maxIdleTime);
        this.configure(((SocketChannel)endpoint.getTransport()).socket());
    }

    public int getLocalPort() {
        if (this._acceptChannel == null || !this._acceptChannel.isOpen()) {
            return -1;
        }
        return this._acceptChannel.socket().getLocalPort();
    }

    private class ConnectorEndPoint
    extends ChannelEndPoint
    implements Runnable,
    ConnectedEndPoint {
        Connection _connection;
        boolean _dispatched;
        int _sotimeout;

        ConnectorEndPoint(ByteChannel channel) throws IOException {
            super(channel, BlockingChannelConnector.this._maxIdleTime);
            this._dispatched = false;
            this._connection = new HttpConnection(BlockingChannelConnector.this, this, BlockingChannelConnector.this.getServer());
        }

        public Connection getConnection() {
            return this._connection;
        }

        public void setConnection(Connection connection) {
            this._connection = connection;
        }

        void dispatch() throws IOException {
            if (!BlockingChannelConnector.this.getThreadPool().dispatch(this)) {
                Log.warn("dispatch failed for  {}", this._connection);
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    BlockingChannelConnector.this.connectionOpened(this._connection);
                    while (this.isOpen()) {
                        int lrmit;
                        if (this._connection.isIdle() && BlockingChannelConnector.this.getServer().getThreadPool().isLowOnThreads() && (lrmit = BlockingChannelConnector.this.getLowResourcesMaxIdleTime()) >= 0 && this._sotimeout != lrmit) {
                            this._sotimeout = lrmit;
                            ((SocketChannel)this.getTransport()).socket().setSoTimeout(this._sotimeout);
                        }
                        this._connection = this._connection.handle();
                    }
                    Object var4_5 = null;
                }
                catch (EofException e2) {
                    Log.debug("EOF", e2);
                    try {
                        this.close();
                    }
                    catch (IOException e22) {
                        Log.ignore(e22);
                    }
                    Object var4_6 = null;
                    BlockingChannelConnector.this.connectionClosed(this._connection);
                    return;
                }
                catch (HttpException e3) {
                    Log.debug("BAD", e3);
                    try {
                        this.close();
                    }
                    catch (IOException e2) {
                        Log.ignore(e2);
                    }
                    Object var4_7 = null;
                    BlockingChannelConnector.this.connectionClosed(this._connection);
                    return;
                }
                catch (Throwable e4) {
                    Log.warn("handle failed", e4);
                    try {
                        this.close();
                    }
                    catch (IOException e2) {
                        Log.ignore(e2);
                    }
                    Object var4_8 = null;
                    BlockingChannelConnector.this.connectionClosed(this._connection);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                BlockingChannelConnector.this.connectionClosed(this._connection);
                throw throwable;
            }
            BlockingChannelConnector.this.connectionClosed(this._connection);
        }
    }
}

