/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import prpobjects.uruobj;
import shared.Flt;
import shared.Vertex;
import shared.readexception;
import uru.Bytedeque;
import uru.context;

public class plMorphDataSet
extends uruobj {
    int morphArrayCount;
    PlMorphArray[] morphs;

    public plMorphDataSet(context c) throws readexception {
        this.morphArrayCount = c.readInt();
        this.morphs = (PlMorphArray[])c.readArray(PlMorphArray.class, this.morphArrayCount);
    }

    public void compile(Bytedeque c) {
        c.writeInt(this.morphArrayCount);
        c.writeArray2(this.morphs);
    }

    public static class PlMorphArray
    extends uruobj {
        int deltaCount;
        PlMorphDelta[] deltas;

        public PlMorphArray(context c) throws readexception {
            this.deltaCount = c.readInt();
            this.deltas = (PlMorphDelta[])c.readArray(PlMorphDelta.class, this.deltaCount);
        }

        public void compile(Bytedeque c) {
            c.writeInt(this.deltaCount);
            c.writeArray2(this.deltas);
        }

        public static class PlMorphDelta
        extends uruobj {
            Flt weight;
            int spanCount;
            PlMorphSpan[] spans;

            public PlMorphDelta(context c) throws readexception {
                this.weight = new Flt(c);
                if (!this.weight.approxequals(0.0f)) {
                    boolean bl = false;
                }
                this.spanCount = c.readInt();
                this.spans = (PlMorphSpan[])c.readArray(PlMorphSpan.class, this.spanCount);
            }

            public void compile(Bytedeque c) {
                this.weight.compile(c);
                c.writeInt(this.spanCount);
                c.writeArray2(this.spans);
            }

            public static class PlMorphSpan
            extends uruobj {
                int deltaCount;
                int numUVWChans;
                PlVertDelta[] deltas;
                Vertex[] UVWs;

                public PlMorphSpan(context c) throws readexception {
                    this.deltaCount = c.readInt();
                    this.numUVWChans = c.readInt();
                    this.deltas = (PlVertDelta[])c.readArray(PlVertDelta.class, this.deltaCount);
                    for (Vertex v : this.UVWs = (Vertex[])c.readArray(Vertex.class, this.deltaCount * this.numUVWChans)) {
                        if (v.x.approxequals(0.0f)) continue;
                        boolean dummy = false;
                    }
                }

                public void compile(Bytedeque c) {
                    c.writeInt(this.deltaCount);
                    c.writeInt(this.numUVWChans);
                    c.writeArray2(this.deltas);
                    c.writeArray(this.UVWs);
                }

                public static class PlVertDelta
                extends uruobj {
                    short idx;
                    short padding;
                    Vertex pos;
                    Vertex norm;

                    public PlVertDelta(context c) throws readexception {
                        this.idx = c.readShort();
                        this.padding = c.readShort();
                        if (this.padding != 0) {
                            boolean dummy = false;
                        }
                        this.pos = new Vertex(c);
                        this.norm = new Vertex(c);
                        float dot = this.pos.dot(this.norm);
                        float normdot = this.norm.dot(this.norm);
                        if (!this.norm.x.approxequals(0.0f)) {
                            boolean dummy = false;
                        }
                    }

                    public void compile(Bytedeque c) {
                        c.writeShort(this.idx);
                        c.writeShort(this.padding);
                        this.pos.compile(c);
                        this.norm.compile(c);
                    }
                }
            }
        }
    }
}

