/*
 * Decompiled with CFR 0.152.
 */
package pythondec3;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import pythondec.PyCode;
import pythondec.PyInt;
import pythondec.op;
import pythondec3.ast.Tok;
import shared.m;
import shared.uncaughtexception;

public class regenerator {
    private ArrayList<Tok> oldtokens;
    private PyCode code;
    private LinkedList<Tok> ts = new LinkedList();
    private ArrayList<LandMoveInfo> moves = new ArrayList();
    private ArrayDeque<Status> fullstack = new ArrayDeque();
    private int dontmove = 0;

    public Status current() {
        Status r = this.fullstack.peekFirst();
        return r;
    }

    public boolean hasParentOfType(blocktype type) {
        Iterator<Status> i = this.fullstack.descendingIterator();
        while (i.hasNext()) {
            Status s = i.next();
            if (s.type != type) continue;
            return true;
        }
        return false;
    }

    public void updateStatus(blocktype type, Tok first, Tok last) {
        Status parent = this.current();
        if (parent != null && (this.before(first, parent.first) || this.after(last, parent.last))) {
            m.throwUncaughtException("child should not be outside of parent");
        }
        Status s = new Status();
        s.type = type;
        s.first = first;
        s.last = last;
        this.fullstack.push(s);
    }

    public void popStatus() {
        this.fullstack.pop();
    }

    public void addLandMove(Tok jump, Tok dest) {
        Tok land;
        if (this.dontmove != 0) {
            return;
        }
        boolean usequeue = false;
        Tok f = this.current().first;
        Tok l = this.current().last;
        int find = f.getTokenIndex();
        int lind = l.getTokenIndex();
        int dind = dest.getTokenIndex();
        int jumpoffset = jump.oi.offset;
        if (dind <= find || dind >= lind) {
            dest = l;
        }
        if ((land = this.tryToFindLand(jump)) == null) {
            m.throwUncaughtException("unexpected");
        }
        this.moveToken(land, dest);
    }

    public Tok tryToFindLand(Tok jump) {
        int jumpoffset = jump.oi.offset;
        Tok land = null;
        for (Tok t : this.ts) {
            int curLandOffset;
            if (t.oi.o != op.LAND || jumpoffset != (curLandOffset = ((Integer)t.oi.pattr).intValue())) continue;
            land = t;
            break;
        }
        return land;
    }

    public void replaceToken(Tok oldtok, Tok newtok) {
        int curpos = this.ts.indexOf(oldtok);
        this.ts.set(curpos, newtok);
        this.renumber();
    }

    public regenerator(PyCode code) {
        this.code = code;
        this.ts.addAll(this.code.tokens);
    }

    public void regenerateStructure() {
        try {
            Tok first = this.ts.getFirst();
            Tok last = this.ts.getLast();
            this.regen(blocktype.ROOT, first, last);
        }
        catch (FoundException e2) {
            e2.printStackTrace();
            m.throwUncaughtException("Token was found but nothing caught it.");
        }
        catch (RuntimeException e3) {
            m.msg("************* orig disassembly ******************");
            m.msg("function/class name: " + this.code.name.toString());
            for (Tok tok : this.code.tokens) {
                m.msg(tok.toString());
            }
            m.msg("************* end of orig disassembly ***********");
            m.msg("************* current disassembly ******************");
            m.msg("function/class name: " + this.code.name.toString());
            for (Tok tok : this.ts) {
                m.msg(tok.toString());
            }
            m.msg("************* end of current disassembly ***********");
            throw e3;
        }
        this.oldtokens = this.code.tokens;
        this.code.tokens = new ArrayList();
        int i = 0;
        for (Tok tok : this.ts) {
            tok.setTokenIndex(i);
            this.code.tokens.add(tok);
            ++i;
        }
        boolean dummy = false;
    }

    private Tok regen(blocktype type, Tok first, Tok last) throws FoundException {
        this.updateStatus(type, first, last);
        Tok result = null;
        try {
            result = this.regen2(type, first, last);
        }
        catch (FoundException e2) {
            this.popStatus();
            throw e2;
        }
        this.popStatus();
        return result;
    }

    private Tok regen2(blocktype type, Tok first, Tok last) throws FoundException {
        Status parent = this.current();
        Tok curt = this.getTokAtRelativePos(first, 1);
        do {
            Tok newcurt;
            Tok jump;
            Tok tester;
            if (curt.getTokenIndex() > 1485) {
                boolean d4 = false;
            }
            if (curt.oi.o == op.JUMP_IF_TRUE || curt.oi.o == op.JUMP_IF_FALSE) {
                PyCode dummy2 = this.code;
                Tok elsestart = this.getTokPointedToByTok(curt);
                if (elsestart.oi.o == op.POP_TOP) {
                    Tok jump2 = this.getTokAtRelativePos(elsestart, -2);
                    if (jump2.oi.o == op.JUMP_ABSOLUTE || jump2.oi.o == op.JUMP_FORWARD) {
                        Tok jumpdest = this.getTokPointedToByTok(jump2);
                        if (parent.type == blocktype.LOOP) {
                            boolean dummy;
                            Tok tester2 = this.getTokAtRelativePos(elsestart, 1);
                            if (tester2.oi.o == op.POP_BLOCK) {
                                dummy = false;
                                this.regen(blocktype.WHILEIF, curt, jump2);
                                curt = this.getTokAtRelativePos(jump2, 1);
                                continue;
                            }
                            dummy = false;
                            this.addLandMove(jump2, jumpdest);
                            this.regen(blocktype.IF, curt, jump2);
                            curt = this.getTokAtRelativePos(jump2, 1);
                            continue;
                        }
                        if (parent.type == blocktype.EXCEPT_CATCH) {
                            boolean dummy = false;
                            this.regen(blocktype.EXCEPT_COND, curt, jump2);
                            throw new FoundException(jump2);
                        }
                        this.addLandMove(jump2, jumpdest);
                        this.regen(blocktype.IF, curt, jump2);
                        curt = this.getTokAtRelativePos(jump2, 1);
                        continue;
                    }
                    curt = this.getTokAtRelativePos(curt, 1);
                    continue;
                }
                if (elsestart.oi.o == op.ROT_TWO) {
                    curt = elsestart;
                    continue;
                }
                curt = this.getTokAtRelativePos(curt, 1);
                continue;
            }
            if (curt.oi.o == op.SETUP_LOOP) {
                Tok nextStmtAfterLoop = this.getTokPointedToByTok(curt);
                tester = this.getTokAtRelativePosIgnoringLands(curt, 1);
                if (tester.oi.o == op.JUMP_FORWARD) {
                    this.addLandMove(curt, nextStmtAfterLoop);
                    this.regen(blocktype.LOOP, tester, last);
                    curt = last;
                    continue;
                }
                this.addLandMove(curt, nextStmtAfterLoop);
                this.regen(blocktype.LOOP, curt, last);
                curt = last;
                continue;
            }
            if (curt.oi.o == op.FOR_ITER) {
                if (parent.type == blocktype.LOOP) {
                    Tok poptop = this.getTokPointedToByTok(curt);
                    jump = this.getTokAtRelativePos(poptop, -2);
                    this.regen(blocktype.FOR, curt, jump);
                    curt = this.getTokAtRelativePos(jump, 1);
                    continue;
                }
                Tok outofloop = this.getTokPointedToByTok(curt);
                jump = this.getTokAtRelativePos(outofloop, -2);
                this.regen(blocktype.LISTCOMP_FOR, curt, jump);
                curt = this.getTokAtRelativePos(jump, 1);
                continue;
            }
            if (curt.oi.o == op.SETUP_FINALLY) {
                curt = this.getTokAtRelativePos(curt, 1);
                continue;
            }
            if (curt.oi.o == op.SETUP_EXCEPT) {
                Tok poptop = this.getTokPointedToByTok(curt);
                jump = this.getTokAtRelativePos(poptop, -2);
                this.regen(blocktype.EXCEPT_MAIN, curt, jump);
                Tok startOfElse = this.getTokPointedToByTok(jump);
                ArrayList<Tok> jumps = new ArrayList<Tok>();
                Tok starter = this.getTokAtRelativePosIgnoringLands(jump, 1);
                while (true) {
                    Tok tryend;
                    if (starter.oi.o == op.DUP_TOP) {
                        tryend = last;
                        ++this.dontmove;
                        Tok curend = null;
                        try {
                            this.regen(blocktype.EXCEPT_CATCH, starter, tryend);
                        }
                        catch (FoundException e2) {
                            curend = e2.token;
                        }
                        if (curend == null) {
                            m.throwUncaughtException("unexpected");
                        }
                        if (curend.oi.o != op.JUMP_ABSOLUTE && curend.oi.o != op.JUMP_FORWARD) {
                            m.throwUncaughtException("unexpected");
                        }
                        --this.dontmove;
                        tryend = curend;
                        try {
                            this.regen(blocktype.EXCEPT_CATCH, starter, tryend);
                        }
                        catch (FoundException e3) {
                            curend = e3.token;
                        }
                        if (curend != tryend) {
                            m.throwUncaughtException("unexpected");
                        }
                        if (curend.oi.o != op.JUMP_ABSOLUTE && curend.oi.o != op.JUMP_FORWARD) {
                            m.throwUncaughtException("unexpected");
                        }
                        jumps.add(curend);
                        starter = this.getTokAtRelativePos(curend, 3);
                        continue;
                    }
                    if (starter.oi.o == op.POP_TOP) {
                        if (curt.getTokenIndex() == 753) {
                            boolean dummy = false;
                        }
                        tryend = last;
                        ++this.dontmove;
                        Tok curend = null;
                        try {
                            this.regen(blocktype.EXCEPT_CATCHALL, starter, tryend);
                        }
                        catch (FoundException e4) {
                            curend = e4.token;
                        }
                        if (curend == null) {
                            m.throwUncaughtException("unexpected");
                        }
                        if (curend.oi.o != op.JUMP_ABSOLUTE && curend.oi.o != op.JUMP_FORWARD) {
                            m.throwUncaughtException("unexpected");
                        }
                        --this.dontmove;
                        tryend = curend;
                        try {
                            this.regen(blocktype.EXCEPT_CATCHALL, starter, tryend);
                        }
                        catch (FoundException e5) {
                            curend = e5.token;
                        }
                        if (curend != tryend) {
                            m.throwUncaughtException("unexpected");
                        }
                        if (curend.oi.o != op.JUMP_ABSOLUTE && curend.oi.o != op.JUMP_FORWARD) {
                            m.throwUncaughtException("unexpected");
                        }
                        jumps.add(curend);
                        starter = this.getTokAtRelativePosIgnoringLands(curend, 1);
                        continue;
                    }
                    if (starter.oi.o == op.END_FINALLY) break;
                    m.throwUncaughtException("unexpected");
                }
                Tok elsestart = this.getTokAtRelativePos(starter, 1);
                Tok jumpdest = this.getTokPointedToByTok(jump);
                if (elsestart != jumpdest) {
                    boolean dummy = false;
                }
                this.addLandMove(jump, jumpdest);
                for (Tok j : jumps) {
                    Tok jdest = this.getTokPointedToByTok(j);
                    this.addLandMove(j, jdest);
                }
                curt = elsestart;
                continue;
            }
            if (curt.oi.o == op.JUMP_ABSOLUTE || curt.oi.o == op.JUMP_FORWARD) {
                Tok dest = this.getTokPointedToByTok(curt);
                tester = this.getTokAtRelativePosIgnoringLands(curt, 1);
                if (tester.oi.o == op.END_FINALLY) {
                    if (!this.hasParentOfType(blocktype.EXCEPT_CATCHALL)) {
                        m.throwUncaughtException("unexpected");
                    }
                    throw new FoundException(curt);
                }
                if (curt.oi.o != op.JUMP_ABSOLUTE) {
                    Tok land = this.tryToFindLand(curt);
                    boolean successfullyremoved = this.ts.remove(land);
                    if (!successfullyremoved) {
                        m.throwUncaughtException("unexpected");
                    }
                    Tok newt = Tok.fakeToken(op.LOAD_CONST, curt.getPrsStream(), curt.oi.offset, PyInt.create(1));
                    this.replaceToken(curt, newt);
                    curt = newt;
                }
                curt = this.getTokAtRelativePos(curt, 1);
                continue;
            }
            curt = curt.oi.o == op.END_FINALLY ? this.getTokAtRelativePos(curt, 1) : (newcurt = this.getTokAtRelativePos(curt, 1));
        } while (this.before(curt, last));
        return null;
    }

    private Tok min(Tok t1, Tok t2) {
        int i2;
        int i1 = t1.getTokenIndex();
        if (i1 < (i2 = t2.getTokenIndex())) {
            return t1;
        }
        return t2;
    }

    private Tok max(Tok t1, Tok t2) {
        int i2;
        int i1 = t1.getTokenIndex();
        if (i1 > (i2 = t2.getTokenIndex())) {
            return t1;
        }
        return t2;
    }

    private boolean before(Tok shouldbebefore, Tok shouldbeafter) {
        int aftind;
        int befind = shouldbebefore.getTokenIndex();
        boolean r = befind < (aftind = shouldbeafter.getTokenIndex());
        return r;
    }

    private boolean after(Tok shouldbeafter, Tok shouldbebefore) {
        int aftind;
        int befind = shouldbebefore.getTokenIndex();
        boolean r = befind < (aftind = shouldbeafter.getTokenIndex());
        return r;
    }

    private void moveLands(int num, Tok from, Tok to) {
        int toind;
        if (num == 0) {
            return;
        }
        int fromind = from.getTokenIndex();
        if (fromind > (toind = to.getTokenIndex())) {
            for (int i = 0; i < num; ++i) {
                Tok l = this.ts.remove(fromind - 1 - i);
                l.debugstr = "(moved)";
                this.ts.add(toind, l);
            }
        } else {
            for (int i = 0; i < num; ++i) {
                Tok l = this.ts.remove(fromind - 1 - i);
                l.debugstr = "(moved)";
                this.ts.add(toind - 1, l);
            }
        }
        this.renumber();
    }

    private void moveToken(Tok from, Tok to) {
        int toind;
        int fromind = from.getTokenIndex();
        if (fromind > (toind = to.getTokenIndex())) {
            Tok l = this.ts.remove(fromind);
            l.debugstr = "(moved)";
            this.ts.add(toind, l);
        } else if (fromind < toind) {
            Tok l = this.ts.remove(fromind);
            l.debugstr = "(moved)";
            this.ts.add(toind - 1, l);
        }
        this.renumber();
    }

    private void renumber() {
        int i = 0;
        for (Tok t : this.ts) {
            t.setTokenIndex(i);
            ++i;
        }
    }

    private Tok getTokPointedToByTok(Tok pointer) {
        if (pointer.oi == null || pointer.oi.pointerDest == null) {
            boolean dummy = false;
        }
        int offset = pointer.oi.pointerDest;
        for (Tok t : this.ts) {
            int to = t.oi.offset;
            if (to < offset) continue;
            if (to == offset) {
                return t;
            }
            m.throwUncaughtException("unexpected");
            if (t.oi.o != op.EXPR_LIST) {
                m.throwUncaughtException("unexpected");
            }
            List list = (List)t.oi.pattr;
            Tok first = (Tok)list.get(0);
            if (first.oi.offset != offset) {
                m.throwUncaughtException("unexpected");
            }
            return t;
        }
        throw new uncaughtexception("unexpected");
    }

    private int getLandsAttachedToTok(Tok token) {
        int pos = this.ts.indexOf(token);
        int numlands = 0;
        while (true) {
            Tok t = this.ts.get(--pos);
            if (t.oi.o != op.LAND) break;
            ++numlands;
        }
        return numlands;
    }

    private Tok getTokAtRelativePos(Tok starttok, int relpos) {
        int ind = this.ts.indexOf(starttok);
        if ((ind += relpos) < 0 || ind >= this.ts.size()) {
            boolean dummy = false;
        }
        Tok r = this.ts.get(ind);
        return r;
    }

    private Tok getTokAtRelativePosIgnoringLands(Tok starttok, int relpos) {
        Tok r;
        int ind = this.ts.indexOf(starttok);
        int count = 0;
        if (relpos > 0) {
            Tok r2;
            do {
                r2 = this.ts.get(++ind);
                if (r2.oi.o == op.LAND) continue;
                ++count;
            } while (count != relpos);
            return r2;
        }
        do {
            r = this.ts.get(--ind);
            if (r.oi.o == op.LAND) continue;
            --count;
        } while (count != relpos);
        return r;
    }

    private class FoundException
    extends Exception {
        Tok token;

        public FoundException(Tok token) {
            this.token = token;
        }
    }

    public static class Status {
        Tok first;
        Tok last;
        blocktype type;
    }

    public static class LandMoveInfo {
        Tok jumptoken;
        Tok desttoken;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum blocktype {
        ROOT,
        IF,
        LOOP,
        WHILEIF,
        FOR,
        EXCEPT_MAIN,
        EXCEPT_CATCH,
        EXCEPT_COND,
        EXCEPT_CATCHALL,
        LISTCOMP_FOR,
        LISTCOMP_IF,
        FINALLY;

    }
}

