/*
 * Decompiled with CFR 0.152.
 */
package uru.server;

import java.util.ArrayList;
import shared.uncaughtexception;

public class TextMapFile {
    private static final String sep = "{->}";
    private static final String comment = "//";
    public final ArrayList<Item> entries = new ArrayList();

    public TextMapFile(String text) {
        text = text.replace("\r", "");
        String[] lines = text.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.equals("") || line.startsWith(comment)) continue;
            int index = line.indexOf(sep);
            if (index == -1) {
                throw new uncaughtexception("TextMapFile contains an invalid line at line: " + Integer.toString(i));
            }
            String left = line.substring(0, index);
            String right = line.substring(index + sep.length());
            if (left.length() == 0 || right.length() == 0) {
                throw new uncaughtexception("Invalid language file at line " + Integer.toString(i + 1));
            }
            this.entries.add(new Item(left, right));
        }
    }

    public static class Item {
        String left;
        String right;

        public Item(String left, String right) {
            this.left = left;
            this.right = right;
        }
    }
}

