/*
 * Decompiled with CFR 0.152.
 */
package deepview;

import deepview.dvAllObjectTypes;
import deepview.dvAllObjects;
import deepview.dvAllObjectsOfType;
import deepview.dvBstr;
import deepview.dvFlt;
import deepview.dvPanel;
import deepview.dvPrpRootObject;
import deepview.dvTransmatrix;
import deepview.dvUruobjectref;
import deepview.dvUrustring;
import deepview.dvWidgets;
import deepview.dvWindow;
import deepview.dvWpstr;
import deepview.refLinks;
import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import prpobjects.Bstr;
import prpobjects.PrpRootObject;
import prpobjects.Transmatrix;
import prpobjects.Typeid;
import prpobjects.Uruobjectdesc;
import prpobjects.Uruobjectref;
import prpobjects.Urustring;
import prpobjects.Wpstr;
import prpobjects.prpfile;
import prpobjects.prpprocess;
import prpobjects.uruobj;
import shared.FileUtils;
import shared.FindAllDescendants;
import shared.Flt;
import shared.m;
import uru.Bytestream;
import uru.context;

public class deepview {
    public Vector<Uruobjectref> allrefs = new Vector();
    public Set<Typeid> alltypes = EnumSet.noneOf(Typeid.class);
    public refLinks allreflinks = new refLinks();
    public Vector<prpfile> prps = new Vector();
    public JDesktopPane desktop;
    public prpfile curprp;
    public PrpRootObject curobj;

    public deepview(JDesktopPane desktop2) {
        this.desktop = desktop2;
    }

    public void reportStrings() {
        Vector<Urustring> urustrings = FindAllDescendants.FindAllDescendantsByClass(Urustring.class, this.prps);
        Vector<Bstr> bstrings = FindAllDescendants.FindAllDescendantsByClass(Bstr.class, this.prps);
        Vector<Wpstr> wpstrings = FindAllDescendants.FindAllDescendantsByClass(Wpstr.class, this.prps);
        for (Urustring urustring : urustrings) {
            m.msg(urustring.toString());
        }
        for (Bstr bstr : bstrings) {
            m.msg(bstr.toString());
        }
        for (Wpstr wpstr : wpstrings) {
            m.msg(wpstr.toString());
        }
    }

    public void reportRefs() {
        for (Uruobjectref ref : this.allrefs) {
            m.msg(ref.toString());
        }
    }

    public prpfile addPrp(String filename) {
        byte[] filedata = FileUtils.ReadFile(filename);
        context c = context.createFromBytestream(new Bytestream(filedata));
        c.curFile = filename;
        this.allreflinks.startListening();
        prpprocess.ProcessAllObjects(c.Fork(), false);
        this.allreflinks.stopListening();
        prpfile prp = prpprocess.ProcessAllObjects(c, true);
        prp.filename = filename;
        this.prps.add(prp);
        for (PrpRootObject curRootObject : prp.objects2) {
            boolean bl;
            if (curRootObject == null) continue;
            if (curRootObject.header == null) {
                bl = false;
            }
            if (curRootObject.header.desc == null) {
                bl = false;
            }
            this.allrefs.add(Uruobjectref.createFromUruobjectdesc(curRootObject.header.desc));
            this.alltypes.add(curRootObject.header.desc.objecttype);
        }
        return prp;
    }

    public void clearAll() {
        for (JInternalFrame frame : this.desktop.getAllFrames()) {
            frame.doDefaultCloseAction();
        }
        this.prps = new Vector();
        this.allreflinks = new refLinks();
        this.allrefs = new Vector();
        this.alltypes.clear();
    }

    public void openType(Typeid typeid) {
        dvWindow newwindow = new dvWindow();
        this.desktop.add(newwindow);
        newwindow.moveToFrontAndSelect();
        newwindow.mainPanel.add(new dvAllObjectsOfType(this, typeid));
    }

    public void openRef(Uruobjectdesc desc) {
        dvWindow newwindow = new dvWindow();
        this.desktop.add(newwindow);
        newwindow.moveToFrontAndSelect();
        Iterator<prpfile> iterator = this.prps.iterator();
        while (iterator.hasNext()) {
            prpfile prp;
            this.curprp = prp = iterator.next();
            Iterator<PrpRootObject> iterator2 = prp.objects2.iterator();
            while (iterator2.hasNext()) {
                PrpRootObject curRootObject;
                this.curobj = curRootObject = iterator2.next();
                if (curRootObject == null || !curRootObject.header.desc.equals(desc)) continue;
                try {
                    curRootObject.parseRawDataNow();
                    this.reflect(curRootObject, newwindow.mainPanel);
                }
                catch (Exception e2) {
                    m.err("Error during reflection.");
                    e2.printStackTrace();
                }
            }
        }
    }

    public void openAllTypes() {
        dvWindow newwindow = new dvWindow();
        this.desktop.add(newwindow);
        newwindow.moveToFrontAndSelect();
        newwindow.mainPanel.add(new dvAllObjectTypes(this));
    }

    public void openAllObjects() {
        dvWindow newwindow = new dvWindow();
        this.desktop.add(newwindow);
        newwindow.moveToFrontAndSelect();
        newwindow.mainPanel.add(new dvAllObjects(this));
    }

    public void saveChanges(String foldername) {
        for (prpfile prp : this.prps) {
            boolean hasChanged = false;
            for (PrpRootObject curRootObject : prp.objects2) {
                if (!curRootObject.hasChanged) continue;
                hasChanged = true;
                break;
            }
            if (!hasChanged) continue;
            String filename2 = prp.filename;
            String filename = foldername + "/" + new File(filename2).getName();
            prp.saveAsFile(filename);
        }
    }

    public void read(String filename) {
        File f = new File(filename);
        if (filename.endsWith("*")) {
            String name = f.getName();
            name = name.substring(0, name.length() - 1).toLowerCase();
            File folder = f.getParentFile();
            for (File curfile : folder.listFiles()) {
                if (!curfile.getName().toLowerCase().startsWith(name) || !curfile.getName().toLowerCase().endsWith(".prp")) continue;
                prpfile prpfile2 = this.addPrp(curfile.getPath());
            }
        } else {
            prpfile prpfile3 = this.addPrp(filename);
        }
    }

    public void reflect(PrpRootObject obj, JPanel panel) throws Exception {
        uruobj uo = obj.getObject();
        panel.setLayout(new BoxLayout(panel, 1));
        dvPanel panel2 = new dvPanel();
        panel.add(panel2);
        this.reflect2(panel2, obj, obj.getClass(), "putnamehere");
        panel.revalidate();
    }

    public void reflect2(JPanel panel, Object obj, Class objclass, String name) throws Exception {
        if (objclass == null) {
            m.msg("null class encountered.");
            return;
        }
        if (obj == null) {
            panel.add(new JLabel("name:" + name + " type:" + objclass.getName() + " null-value"));
            return;
        }
        m.msg("doing " + obj.toString() + " of class " + objclass.getName());
        if (objclass == Uruobjectref.class) {
            panel.add(new dvUruobjectref((Uruobjectref)obj, name, this, true));
            return;
        }
        if (objclass == Urustring.class) {
            panel.add(new dvUrustring((Urustring)obj, name, this, true));
            return;
        }
        if (objclass == Wpstr.class) {
            panel.add(new dvWpstr((Wpstr)obj, name, this));
            return;
        }
        if (objclass == Bstr.class) {
            panel.add(new dvBstr((Bstr)obj, name, this));
            return;
        }
        if (objclass == Transmatrix.class) {
            panel.add(new dvTransmatrix((Transmatrix)obj, name, this));
            return;
        }
        if (objclass == Flt.class) {
            panel.add(new dvFlt((Flt)obj, name, this));
            return;
        }
        if (objclass == PrpRootObject.class) {
            panel.add(new dvPrpRootObject((PrpRootObject)obj, this));
        }
        if (objclass.isPrimitive() || objclass == String.class || objclass.isEnum() || objclass == Byte.class || objclass == Integer.class || objclass == Short.class || objclass == Boolean.class || objclass == Long.class || objclass == Float.class || objclass == Double.class || objclass == Character.class) {
            panel.add(new JLabel("name:" + name + " type:" + objclass.getName() + " value:" + obj.toString()));
        } else if (objclass.isArray()) {
            dvPanel subpanel = new dvPanel();
            panel.add(subpanel);
            subpanel.add(new JLabel("name:" + name + " type:" + objclass.getName() + " array elements:"));
            int length = Array.getLength(obj);
            if (length > 100) {
                subpanel.add(new JLabel("Not displaying elements of array with more than 100 elements."));
                return;
            }
            for (int i = 0; i < length; ++i) {
                Object arrayitem = Array.get(obj, i);
                Class<?> arrayclass = arrayitem != null ? arrayitem.getClass() : objclass.getComponentType();
                this.reflect2(subpanel, arrayitem, arrayclass, Integer.toString(i));
            }
        } else {
            if (objclass == Class.class) {
                return;
            }
            dvPanel subpanel = new dvPanel();
            panel.add(subpanel);
            subpanel.add(dvWidgets.jlabel("name:" + name + " type:" + objclass.getName() + " class members:"));
            Class superclass = objclass.getSuperclass();
            if (superclass != Object.class && superclass != uruobj.class) {
                m.msg("unhandled inheritance");
            }
            AccessibleObject[] fields = objclass.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            for (int i = 0; i < fields.length; ++i) {
                Object curfield = ((Field)fields[i]).get(obj);
                Class<?> curclass = curfield != null ? curfield.getClass() : ((Field)fields[i]).getType();
                String curname = ((Field)fields[i]).getName();
                this.reflect2(subpanel, curfield, curclass, curname);
            }
        }
    }
}

