/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.control.group.GroupAttrName;
import org.apache.commons.jcs3.engine.control.group.GroupId;
import org.apache.commons.jcs3.engine.memory.behavior.IMemoryCache;
import org.apache.commons.jcs3.engine.memory.util.MemoryElementDescriptor;
import org.apache.commons.jcs3.engine.stats.StatElement;
import org.apache.commons.jcs3.engine.stats.Stats;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public abstract class AbstractMemoryCache<K, V>
implements IMemoryCache<K, V> {
    private static final Log log = LogManager.getLog(AbstractMemoryCache.class);
    private ICompositeCacheAttributes cacheAttributes;
    private CompositeCache<K, V> cache;
    protected int chunkSize;
    protected final Lock lock = new ReentrantLock();
    protected Map<K, MemoryElementDescriptor<K, V>> map;
    protected AtomicLong hitCnt;
    protected AtomicLong missCnt;
    protected AtomicLong putCnt;

    @Override
    public void initialize(CompositeCache<K, V> hub) {
        this.hitCnt = new AtomicLong(0L);
        this.missCnt = new AtomicLong(0L);
        this.putCnt = new AtomicLong(0L);
        this.cacheAttributes = hub.getCacheAttributes();
        this.chunkSize = this.cacheAttributes.getSpoolChunkSize();
        this.cache = hub;
        this.map = this.createMap();
    }

    public abstract Map<K, MemoryElementDescriptor<K, V>> createMap();

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys) throws IOException {
        if (keys != null) {
            return keys.stream().map(key -> {
                try {
                    return this.get(key);
                }
                catch (IOException e) {
                    return null;
                }
            }).filter(element -> element != null).collect(Collectors.toMap(element -> element.getKey(), element -> element));
        }
        return new HashMap();
    }

    @Override
    public ICacheElement<K, V> getQuiet(K key) throws IOException {
        ICacheElement<K, V> ce = null;
        MemoryElementDescriptor<K, V> me = this.map.get(key);
        if (me != null) {
            log.debug("{0}: MemoryCache quiet hit for {1}", () -> this.getCacheName(), () -> key);
            ce = me.getCacheElement();
        } else {
            log.debug("{0}: MemoryCache quiet miss for {1}", () -> this.getCacheName(), () -> key);
        }
        return ce;
    }

    @Override
    public abstract void update(ICacheElement<K, V> var1) throws IOException;

    @Override
    public void removeAll() throws IOException {
        this.lock.lock();
        try {
            this.lockedRemoveAll();
            this.map.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void lockedRemoveAll();

    @Override
    public void dispose() throws IOException {
        this.removeAll();
        this.hitCnt.set(0L);
        this.missCnt.set(0L);
        this.putCnt.set(0L);
        log.info("Memory Cache dispose called.");
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Abstract Memory Cache");
        ArrayList elems = new ArrayList();
        stats.setStatElements(elems);
        elems.add(new StatElement<AtomicLong>("Put Count", this.putCnt));
        elems.add(new StatElement<AtomicLong>("Hit Count", this.hitCnt));
        elems.add(new StatElement<AtomicLong>("Miss Count", this.missCnt));
        elems.add(new StatElement<Integer>("Map Size", this.getSize()));
        return stats;
    }

    @Override
    public int getSize() {
        return this.map.size();
    }

    public String getCacheName() {
        String attributeCacheName = this.cacheAttributes.getCacheName();
        if (attributeCacheName != null) {
            return attributeCacheName;
        }
        return this.cache.getCacheName();
    }

    @Override
    public void waterfal(ICacheElement<K, V> ce) {
        this.cache.spoolToDisk(ce);
    }

    public void dumpMap() {
        if (log.isTraceEnabled()) {
            log.trace("dumpingMap");
            this.map.entrySet().forEach(e -> log.trace("dumpMap> key={0}, val={1}", e.getKey(), ((MemoryElementDescriptor)e.getValue()).getCacheElement().getVal()));
        }
    }

    @Override
    public ICompositeCacheAttributes getCacheAttributes() {
        return this.cacheAttributes;
    }

    @Override
    public void setCacheAttributes(ICompositeCacheAttributes cattr) {
        this.cacheAttributes = cattr;
    }

    @Override
    public CompositeCache<K, V> getCompositeCache() {
        return this.cache;
    }

    protected boolean removeByGroup(K key) {
        GroupId groupId = ((GroupAttrName)key).groupId;
        return this.map.entrySet().removeIf(entry -> {
            Object k = entry.getKey();
            if (k instanceof GroupAttrName && ((GroupAttrName)k).groupId.equals(groupId)) {
                this.lock.lock();
                try {
                    this.lockedRemoveElement((MemoryElementDescriptor)entry.getValue());
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return false;
        });
    }

    protected boolean removeByHierarchy(K key) {
        String keyString = key.toString();
        return this.map.entrySet().removeIf(entry -> {
            Object k = entry.getKey();
            if (k instanceof String && ((String)k).startsWith(keyString)) {
                this.lock.lock();
                try {
                    this.lockedRemoveElement((MemoryElementDescriptor)entry.getValue());
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return false;
        });
    }

    protected abstract void lockedRemoveElement(MemoryElementDescriptor<K, V> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key) throws IOException {
        log.debug("removing item for key: {0}", key);
        boolean removed = false;
        if (key instanceof String && ((String)key).endsWith(":")) {
            removed = this.removeByHierarchy(key);
        } else if (key instanceof GroupAttrName && ((GroupAttrName)key).attrName == null) {
            removed = this.removeByGroup(key);
        } else {
            this.lock.lock();
            try {
                MemoryElementDescriptor<K, V> me = this.map.remove(key);
                if (me != null) {
                    this.lockedRemoveElement(me);
                    removed = true;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return removed;
    }

    @Override
    public Set<K> getKeySet() {
        return new LinkedHashSet<K>(this.map.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICacheElement<K, V> get(K key) throws IOException {
        ICacheElement<K, V> ce = null;
        log.debug("{0}: getting item for key {1}", () -> this.getCacheName(), () -> key);
        MemoryElementDescriptor<K, V> me = this.map.get(key);
        if (me != null) {
            this.hitCnt.incrementAndGet();
            ce = me.getCacheElement();
            this.lock.lock();
            try {
                this.lockedGetElement(me);
            }
            finally {
                this.lock.unlock();
            }
            log.debug("{0}: MemoryCache hit for {1}", () -> this.getCacheName(), () -> key);
        } else {
            this.missCnt.incrementAndGet();
            log.debug("{0}: MemoryCache miss for {1}", () -> this.getCacheName(), () -> key);
        }
        return ce;
    }

    protected abstract void lockedGetElement(MemoryElementDescriptor<K, V> var1);
}

