/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.JosmEditorPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Stopwatch;
import org.openstreetmap.josm.tools.Utils;

public class SplashScreen
extends JFrame
implements ChangeListener {
    private final transient SplashProgressMonitor progressMonitor;
    private final SplashScreenProgressRenderer progressRenderer;

    public SplashScreen() {
        this.setUndecorated(true);
        Container contentPane = this.getContentPane();
        EtchedBorder margin = new EtchedBorder(1, Color.white, Color.gray);
        if (contentPane instanceof JComponent) {
            ((JComponent)contentPane).setBorder(margin);
        }
        JPanel innerContentPane = new JPanel(new GridBagLayout());
        innerContentPane.setBorder(new EmptyBorder(10, 10, 2, 10));
        contentPane.add(innerContentPane);
        JLabel logo = new JLabel(ImageProvider.get("logo.svg", ImageProvider.ImageSizes.SPLASH_LOGO));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridheight = 2;
        gbc.insets = new Insets(0, 0, 0, 70);
        innerContentPane.add((Component)logo, gbc);
        JLabel caption = new JLabel("JOSM \u2013 " + I18n.tr("Java OpenStreetMap Editor", new Object[0]));
        caption.setFont(GuiHelper.getTitleFont());
        gbc.gridheight = 1;
        gbc.gridx = 1;
        gbc.insets = new Insets(30, 0, 0, 0);
        innerContentPane.add((Component)caption, gbc);
        JLabel version = new JLabel(I18n.tr("Version {0}", Version.getInstance().getVersionString()));
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        innerContentPane.add((Component)version, gbc);
        JSeparator separator = new JSeparator(0);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(15, 0, 5, 0);
        innerContentPane.add((Component)separator, gbc);
        this.progressRenderer = new SplashScreenProgressRenderer();
        gbc.gridy = 3;
        gbc.insets = new Insets(0, 0, 10, 0);
        innerContentPane.add((Component)this.progressRenderer, gbc);
        this.progressMonitor = new SplashProgressMonitor(null, this);
        this.pack();
        WindowGeometry.centerOnScreen(this.getSize(), "gui.geometry").applySafe(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                SplashScreen.this.setVisible(false);
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent ignore) {
        GuiHelper.runInEDT(() -> this.progressRenderer.setTasks(this.progressMonitor.toString()));
    }

    public SplashProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    private static class SplashScreenProgressRenderer
    extends JPanel {
        private final JosmEditorPane lblTaskTitle = new JosmEditorPane();
        private final JScrollPane scrollPane = new JScrollPane(this.lblTaskTitle, 20, 31);
        private final JProgressBar progressBar = new JProgressBar(0);
        private static final String LABEL_HTML = "<html><style>ul {margin-top: 0; margin-bottom: 0; padding: 0;} li {margin: 0; padding: 0;}</style>";

        protected void build() {
            this.setLayout(new GridBagLayout());
            JosmEditorPane.makeJLabelLike(this.lblTaskTitle, false);
            this.lblTaskTitle.setText(LABEL_HTML);
            this.scrollPane.setPreferredSize(new Dimension(0, 320));
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)this.scrollPane, GBC.eol().insets(5, 5, 0, 0).fill(2));
            this.progressBar.setIndeterminate(true);
            this.add((Component)this.progressBar, GBC.eol().insets(5, 15, 0, 0).fill(2));
        }

        SplashScreenProgressRenderer() {
            this.build();
        }

        public void setTasks(String tasks) {
            this.lblTaskTitle.setText(LABEL_HTML + tasks);
            this.lblTaskTitle.setCaretPosition(this.lblTaskTitle.getDocument().getLength());
            this.scrollPane.getHorizontalScrollBar().setValue(0);
        }
    }

    public static class SplashProgressMonitor
    extends Task
    implements ProgressMonitor {
        private final String name;
        private final ChangeListener listener;
        private final List<Task> tasks = new CopyOnWriteArrayList<Task>();
        private SplashProgressMonitor latestSubtask;

        public SplashProgressMonitor(String name, ChangeListener listener) {
            this.name = name;
            this.listener = listener;
        }

        @Override
        public StringBuilder toHtml(StringBuilder sb) {
            sb.append(Utils.firstNonNull(this.name, ""));
            if (!this.tasks.isEmpty()) {
                sb.append("<ul>");
                for (Task i : this.tasks) {
                    sb.append("<li>");
                    i.toHtml(sb);
                    sb.append("</li>");
                }
                sb.append("</ul>");
            }
            return sb;
        }

        @Override
        public void beginTask(String title) {
            if (title != null && !title.isEmpty()) {
                Logging.debug(title);
                MeasurableTask task = new MeasurableTask(title);
                this.tasks.add(task);
                this.listener.stateChanged(null);
            }
        }

        @Override
        public void beginTask(String title, int ticks) {
            this.beginTask(title);
        }

        @Override
        public void setCustomText(String text) {
            this.beginTask(text);
        }

        @Override
        public void setExtraText(String text) {
            this.beginTask(text);
        }

        @Override
        public void indeterminateSubTask(String title) {
            this.subTask(title);
        }

        @Override
        public void subTask(String title) {
            Logging.debug(title);
            this.latestSubtask = new SplashProgressMonitor(title, this.listener);
            this.tasks.add(this.latestSubtask);
            this.listener.stateChanged(null);
        }

        @Override
        public ProgressMonitor createSubTaskMonitor(int ticks, boolean internal) {
            if (this.latestSubtask != null) {
                return this.latestSubtask;
            }
            return this;
        }

        @Override
        @Deprecated
        public void finishTask() {
        }

        public void finishTask(String title) {
            Optional<Task> taskOptional = this.tasks.stream().filter(new MeasurableTask(title)::equals).filter(MeasurableTask.class::isInstance).findAny();
            taskOptional.ifPresent(task -> {
                ((MeasurableTask)task).finish();
                this.listener.stateChanged(null);
            });
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void setTicksCount(int ticks) {
        }

        @Override
        public int getTicksCount() {
            return 0;
        }

        @Override
        public void setTicks(int ticks) {
        }

        @Override
        public int getTicks() {
            return 0;
        }

        @Override
        public void worked(int ticks) {
        }

        @Override
        public boolean isCanceled() {
            return false;
        }

        @Override
        public void cancel() {
        }

        @Override
        public void addCancelListener(ProgressMonitor.CancelListener listener) {
        }

        @Override
        public void removeCancelListener(ProgressMonitor.CancelListener listener) {
        }

        @Override
        public void appendLogMessage(String message) {
        }

        @Override
        public void setProgressTaskId(ProgressTaskId taskId) {
        }

        @Override
        public ProgressTaskId getProgressTaskId() {
            return null;
        }

        @Override
        public Component getWindowParent() {
            return MainApplication.getMainFrame();
        }
    }

    private static class MeasurableTask
    extends Task {
        private final String name;
        private final Stopwatch stopwatch;
        private String duration = "";

        MeasurableTask(String name) {
            this.name = name;
            this.stopwatch = Stopwatch.createStarted();
        }

        public void finish() {
            if (this.isFinished()) {
                throw new IllegalStateException("This task has already been finished: " + this.name);
            }
            if (this.stopwatch.elapsed() >= 0L) {
                Logging.debug(this.stopwatch.toString(this.name));
                this.duration = I18n.tr(" ({0})", this.stopwatch);
            }
        }

        public boolean isFinished() {
            return !this.duration.isEmpty();
        }

        @Override
        public StringBuilder toHtml(StringBuilder sb) {
            return sb.append(this.name).append("<i style='color: #666666;'>").append(this.duration).append("</i>");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MeasurableTask that = (MeasurableTask)o;
            return Objects.equals(this.name, that.name) && this.isFinished() == that.isFinished();
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }
    }

    private static abstract class Task {
        private Task() {
        }

        public abstract StringBuilder toHtml(StringBuilder var1);

        public final String toString() {
            return this.toHtml(new StringBuilder(1024)).toString();
        }
    }
}

