/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxDataContainer;
import org.openstreetmap.josm.data.osm.DownloadPolicy;
import org.openstreetmap.josm.data.osm.UploadPolicy;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.gpx.ConvertFromGpxLayerAction;
import org.openstreetmap.josm.tools.I18n;

public final class CorrelationSupportLayer
extends OsmDataLayer
implements GpxDataContainer {
    private static final String CORRELATION_PREFIX = "correlation:";
    private final GpxData gpxData = new GpxData();

    public CorrelationSupportLayer(GpxData fauxGpxData) {
        this(fauxGpxData, I18n.tr("Correlation support layer", new Object[0]));
    }

    public CorrelationSupportLayer(GpxData fauxGpxData, String name) {
        super(ConvertFromGpxLayerAction.convert(fauxGpxData, "list", CORRELATION_PREFIX), name, null);
        this.data.setDownloadPolicy(DownloadPolicy.BLOCKED);
        this.data.setUploadPolicy(UploadPolicy.BLOCKED);
        this.rebuildGpxData();
    }

    private void rebuildGpxData() {
        this.gpxData.beginUpdate();
        try {
            this.gpxData.clear();
            CorrelationSupportLayer.fillGpxData(this.gpxData, this.data, null, CORRELATION_PREFIX);
        }
        finally {
            this.gpxData.endUpdate();
        }
    }

    @Override
    public GpxData getGpxData() {
        return this.gpxData;
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        this.invalidate();
        this.rebuildGpxData();
    }

    @Override
    protected void setRequiresSaveToFile(boolean newValue) {
    }

    @Override
    protected void setRequiresUploadToServer(boolean newValue) {
    }

    @Override
    public boolean isMergable(Layer other) {
        return false;
    }

    @Override
    public boolean isDownloadable() {
        return false;
    }

    @Override
    public boolean isUploadable() {
        return false;
    }

    @Override
    public boolean requiresUploadToServer() {
        return false;
    }

    @Override
    public boolean requiresSaveToFile() {
        return false;
    }

    @Override
    public boolean isSavable() {
        return false;
    }
}

